/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Iterator;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class CardinalityCounter
implements Iterator<int[]>,
Iterable<int[]> {
    private int[] cards;
    private int[] valList;
    private boolean hasNext;

    public CardinalityCounter(int[] cards) {
        this.cards = cards;
        this.valList = new int[cards.length];
        for (int i = 0; i < cards.length; ++i) {
            if (this.cards[i] <= 0) {
                throw new IllegalArgumentException("CANNOT have zero cardinalities!");
            }
            this.valList[i] = 0;
        }
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int[] next() {
        int i;
        if (!this.hasNext()) {
            throw new ReviewedStingException("CANNOT iterate past end!");
        }
        int[] nextList = new int[this.valList.length];
        for (i = 0; i < this.valList.length; ++i) {
            nextList[i] = this.valList[i];
        }
        this.hasNext = false;
        for (i = this.cards.length - 1; i >= 0; --i) {
            if (this.valList[i] < this.cards[i] - 1) {
                int n = i;
                this.valList[n] = this.valList[n] + 1;
                this.hasNext = true;
                break;
            }
            this.valList[i] = 0;
        }
        return nextList;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Cannot remove from CardinalityCounter!");
    }

    @Override
    public Iterator<int[]> iterator() {
        return this;
    }
}

