/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.BadCigarFilter;
import org.broadinstitute.sting.gatk.filters.BadMateFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.filters.Platform454Filter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@ReadFilters(value={Platform454Filter.class, MappingQualityZeroFilter.class, BadCigarFilter.class})
@Reference(window=@Window(start=-1, stop=50))
@Allows(value={DataSource.READS, DataSource.REFERENCE})
@By(value=DataSource.REFERENCE)
@BAQMode(ApplicationTime=BAQ.ApplicationTime.FORBIDDEN)
public class RealignerTargetCreator
extends RodWalker<Event, Event> {
    @Output
    protected PrintStream out;
    @Input(fullName="known", shortName="known", doc="Input VCF file with known indels", required=false)
    public List<RodBinding<VariantContext>> known = Collections.emptyList();
    @Argument(fullName="windowSize", shortName="window", doc="window size for calculating entropy or SNP clusters", required=false)
    protected int windowSize = 10;
    @Argument(fullName="mismatchFraction", shortName="mismatch", doc="fraction of base qualities needing to mismatch for a position to have high entropy", required=false)
    protected double mismatchThreshold = 0.0;
    @Argument(fullName="minReadsAtLocus", shortName="minReads", doc="minimum reads at a locus to enable using the entropy calculation", required=false)
    protected int minReadsAtLocus = 4;
    @Argument(fullName="maxIntervalSize", shortName="maxInterval", doc="maximum interval size", required=false)
    protected int maxIntervalSize = 500;

    @Override
    public boolean generateExtendedEvents() {
        return true;
    }

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public void initialize() {
        if (this.windowSize < 2) {
            throw new UserException.BadArgumentValue("windowSize", "Window Size must be an integer greater than 1");
        }
    }

    @Override
    public Event map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        ReadBackedPileup pileup;
        boolean hasIndel = false;
        boolean hasInsertion = false;
        boolean hasPointEvent = false;
        int furthestStopPos = -1;
        if (context.hasExtendedEventPileup() && (pileup = context.getExtendedEventPileup()).getNumberOfInsertions() > 0) {
            hasInsertion = true;
            hasIndel = true;
            for (ExtendedEventPileupElement p : pileup.toExtendedIterable()) {
                furthestStopPos = Math.max(furthestStopPos, p.getRead().getAlignmentEnd());
            }
        }
        if (tracker != null) {
            for (VariantContext vc : tracker.getValues(this.known)) {
                switch (vc.getType()) {
                    case INDEL: {
                        hasIndel = true;
                        if (!vc.isSimpleInsertion()) break;
                        hasInsertion = true;
                        break;
                    }
                    case SNP: {
                        hasPointEvent = true;
                        break;
                    }
                    case MIXED: {
                        hasPointEvent = true;
                        hasIndel = true;
                        if (!vc.isSimpleInsertion()) break;
                        hasInsertion = true;
                        break;
                    }
                }
                if (!hasIndel) continue;
                furthestStopPos = vc.getEnd();
            }
        }
        if (context.hasBasePileup()) {
            pileup = context.getBasePileup();
            int mismatchQualities = 0;
            int totalQualities = 0;
            byte refBase = ref.getBase();
            for (PileupElement p : pileup) {
                if (BadMateFilter.hasBadMate(p.getRead())) continue;
                furthestStopPos = Math.max(furthestStopPos, p.getRead().getAlignmentEnd());
                if (p.isDeletion()) {
                    hasIndel = true;
                    continue;
                }
                if (p.getBase() != refBase) {
                    mismatchQualities += p.getQual();
                }
                totalQualities += p.getQual();
            }
            if (this.mismatchThreshold > 0.0 && this.mismatchThreshold <= 1.0 && pileup.size() >= this.minReadsAtLocus && (double)mismatchQualities / (double)totalQualities >= this.mismatchThreshold) {
                hasPointEvent = true;
            }
        }
        if (!hasIndel && !hasPointEvent) {
            return null;
        }
        if (furthestStopPos == -1) {
            return null;
        }
        GenomeLoc eventLoc = context.getLocation();
        if (hasInsertion) {
            eventLoc = this.getToolkit().getGenomeLocParser().createGenomeLoc(eventLoc.getContig(), eventLoc.getStart(), eventLoc.getStart() + 1);
        } else if (hasIndel && !context.hasBasePileup()) {
            eventLoc = this.getToolkit().getGenomeLocParser().createGenomeLoc(eventLoc.getContig(), eventLoc.getStart(), furthestStopPos);
        }
        EVENT_TYPE eventType = hasIndel ? (hasPointEvent ? EVENT_TYPE.BOTH : EVENT_TYPE.INDEL_EVENT) : EVENT_TYPE.POINT_EVENT;
        return new Event(eventLoc, furthestStopPos, eventType);
    }

    @Override
    public void onTraversalDone(Event sum) {
        if (sum != null && sum.isReportableEvent()) {
            this.out.println(sum.toString());
        }
    }

    @Override
    public Event reduceInit() {
        return null;
    }

    @Override
    public Event reduce(Event value, Event sum) {
        if (value == null) {
            return sum;
        }
        if (sum == null) {
            return value;
        }
        if (sum.loc.getContigIndex() != value.loc.getContigIndex() || sum.furthestStopPos < value.loc.getStart()) {
            if (sum.isReportableEvent()) {
                this.out.println(sum.toString());
            }
            return value;
        }
        sum.merge(value);
        return sum;
    }

    class Event {
        public int furthestStopPos;
        public GenomeLoc loc;
        public int eventStartPos;
        private int eventStopPos;
        private EVENT_TYPE type;
        private ArrayList<Integer> pointEvents = new ArrayList();

        public Event(GenomeLoc loc, int furthestStopPos, EVENT_TYPE type) {
            this.loc = loc;
            this.furthestStopPos = furthestStopPos;
            this.type = type;
            if (type == EVENT_TYPE.INDEL_EVENT || type == EVENT_TYPE.BOTH) {
                this.eventStartPos = loc.getStart();
                this.eventStopPos = loc.getStop();
            } else {
                this.eventStartPos = -1;
                this.eventStopPos = -1;
            }
            if (type == EVENT_TYPE.POINT_EVENT || type == EVENT_TYPE.BOTH) {
                this.pointEvents.add(loc.getStart());
            }
        }

        public void merge(Event e) {
            if (e.type == EVENT_TYPE.INDEL_EVENT || e.type == EVENT_TYPE.BOTH) {
                if (this.eventStartPos == -1) {
                    this.eventStartPos = e.eventStartPos;
                }
                this.eventStopPos = e.eventStopPos;
                this.furthestStopPos = e.furthestStopPos;
            }
            if (e.type == EVENT_TYPE.POINT_EVENT || e.type == EVENT_TYPE.BOTH) {
                int lastPosition;
                int newPosition = e.pointEvents.get(0);
                if (this.pointEvents.size() > 0 && newPosition - (lastPosition = this.pointEvents.get(this.pointEvents.size() - 1).intValue()) < RealignerTargetCreator.this.windowSize) {
                    this.eventStopPos = Math.max(this.eventStopPos, newPosition);
                    this.furthestStopPos = e.furthestStopPos;
                    this.eventStartPos = this.eventStartPos == -1 ? lastPosition : Math.min(this.eventStartPos, lastPosition);
                }
                this.pointEvents.add(newPosition);
            }
        }

        public boolean isReportableEvent() {
            return RealignerTargetCreator.this.getToolkit().getGenomeLocParser().isValidGenomeLoc(this.loc.getContig(), this.eventStartPos, this.eventStopPos, true) && this.eventStopPos >= 0 && this.eventStopPos - this.eventStartPos < RealignerTargetCreator.this.maxIntervalSize;
        }

        public String toString() {
            return String.format("%s:%d-%d", this.loc.getContig(), this.eventStartPos, this.eventStopPos);
        }
    }

    private static enum EVENT_TYPE {
        POINT_EVENT,
        INDEL_EVENT,
        BOTH;

    }
}

