/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.genotype.Haplotype;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class PairHMMIndelErrorModel {
    public static final int BASE_QUAL_THRESHOLD = 20;
    private static final int MATCH_OFFSET = 0;
    private static final int X_OFFSET = 1;
    private static final int Y_OFFSET = 2;
    private static final int DIAG = 0;
    private static final int UP = 1;
    private static final int LEFT = 2;
    private static final int DIAG_GOTO_M = 0;
    private static final int DIAG_GOTO_X = 1;
    private static final int DIAG_GOTO_Y = 2;
    private static final int UP_GOTO_M = 4;
    private static final int UP_GOTO_X = 5;
    private static final int UP_GOTO_Y = 6;
    private static final int LEFT_GOTO_M = 8;
    private static final int LEFT_GOTO_X = 9;
    private static final int LEFT_GOTO_Y = 10;
    private static final int[] ACTIONS_M = new int[]{0, 1, 2};
    private static final int[] ACTIONS_X = new int[]{4, 5, 6};
    private static final int[] ACTIONS_Y = new int[]{8, 9, 10};
    private final double logGapOpenProbability;
    private final double logGapContinuationProbability;
    private boolean DEBUG = false;
    private static final int MAX_CACHED_QUAL = 127;
    private static final double[] baseMatchArray;
    private static final double[] baseMismatchArray;
    private static final double LOG_ONE_HALF;
    private static final double END_GAP_COST;
    private static final int START_HRUN_GAP_IDX = 4;
    private static final int MAX_HRUN_GAP_IDX = 20;
    private static final double MIN_GAP_OPEN_PENALTY = 30.0;
    private static final double MIN_GAP_CONT_PENALTY = 10.0;
    private static final double GAP_PENALTY_HRUN_STEP = 1.0;
    private boolean doViterbi = false;
    private final boolean useAffineGapModel = true;
    private boolean doContextDependentPenalties = false;
    private final double[] GAP_OPEN_PROB_TABLE;
    private final double[] GAP_CONT_PROB_TABLE;
    private boolean getGapPenaltiesFromFile = false;
    private int SMOOTHING = 1;
    private int MAX_QUALITY_SCORE = 50;
    private int PRESERVE_QSCORES_LESS_THAN = 5;

    public PairHMMIndelErrorModel(double indelGOP, double indelGCP, boolean deb, boolean doCDP, boolean dovit, boolean gpf, File RECAL_FILE) {
        this(indelGOP, indelGCP, deb, doCDP, dovit);
        this.getGapPenaltiesFromFile = gpf;
    }

    public PairHMMIndelErrorModel(double indelGOP, double indelGCP, boolean deb, boolean doCDP, boolean dovit) {
        this(indelGOP, indelGCP, deb, doCDP);
        this.doViterbi = dovit;
    }

    public PairHMMIndelErrorModel(double indelGOP, double indelGCP, boolean deb, boolean doCDP) {
        this.logGapOpenProbability = -indelGOP / 10.0;
        this.logGapContinuationProbability = -indelGCP / 10.0;
        this.doContextDependentPenalties = doCDP;
        this.DEBUG = deb;
        this.GAP_CONT_PROB_TABLE = new double[20];
        this.GAP_OPEN_PROB_TABLE = new double[20];
        for (int i = 0; i < 4; ++i) {
            this.GAP_OPEN_PROB_TABLE[i] = this.logGapOpenProbability;
            this.GAP_CONT_PROB_TABLE[i] = this.logGapContinuationProbability;
        }
        double gop = this.logGapOpenProbability;
        double gcp = this.logGapContinuationProbability;
        double step = 0.1;
        double maxGOP = -3.0;
        double maxGCP = -1.0;
        for (int i = 4; i < 20; ++i) {
            if ((gop += step) > maxGOP) {
                gop = maxGOP;
            }
            if ((gcp += step) > maxGCP) {
                gcp = maxGCP;
            }
            this.GAP_OPEN_PROB_TABLE[i] = gop;
            this.GAP_CONT_PROB_TABLE[i] = gcp;
        }
    }

    private double computeReadLikelihoodGivenHaplotype(byte[] haplotypeBases, byte[] readBases, byte[] readQuals) {
        int X_METRIC_LENGTH = readBases.length + 1;
        int Y_METRIC_LENGTH = haplotypeBases.length + 1;
        double[][] pathMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        int[][] bestMetricArray = new int[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        pathMetricArray[0][0] = 0.0;
        for (int i = 1; i < X_METRIC_LENGTH; ++i) {
            pathMetricArray[i][0] = 0.0;
            bestMetricArray[i][0] = 1;
        }
        for (int j = 1; j < Y_METRIC_LENGTH; ++j) {
            pathMetricArray[0][j] = 0.0;
            bestMetricArray[0][j] = 2;
        }
        for (int indI = 1; indI < X_METRIC_LENGTH; ++indI) {
            for (int indJ = 1; indJ < Y_METRIC_LENGTH; ++indJ) {
                byte x = readBases[indI - 1];
                byte y = haplotypeBases[indJ - 1];
                int qual = readQuals[indI - 1];
                double bestMetric = 0.0;
                int bestMetricIdx = 0;
                if (qual < 1) {
                    qual = 1;
                }
                if (qual > 127) {
                    qual = 127;
                }
                double pBaseRead = x == y ? baseMatchArray[qual] : baseMismatchArray[qual];
                double[] metrics = new double[]{pathMetricArray[indI - 1][indJ - 1] + pBaseRead, pathMetricArray[indI - 1][indJ] + this.logGapOpenProbability, pathMetricArray[indI][indJ - 1] + this.logGapOpenProbability};
                if (this.doViterbi) {
                    bestMetricIdx = MathUtils.maxElementIndex(metrics);
                    bestMetric = metrics[bestMetricIdx];
                } else {
                    bestMetric = MathUtils.softMax(metrics);
                }
                pathMetricArray[indI][indJ] = bestMetric;
                bestMetricArray[indI][indJ] = bestMetricIdx;
            }
        }
        double bestMetric = 0.0;
        int bestMetricIdx = 0;
        int bestI = X_METRIC_LENGTH - 1;
        int bestJ = Y_METRIC_LENGTH - 1;
        for (int i = 0; i < X_METRIC_LENGTH; ++i) {
            int j = Y_METRIC_LENGTH - 1;
            if (!(pathMetricArray[i][j] > bestMetric)) continue;
            bestMetric = pathMetricArray[i][j];
            bestI = i;
            bestJ = j;
        }
        for (int j = 0; j < Y_METRIC_LENGTH; ++j) {
            int i = X_METRIC_LENGTH - 1;
            if (!(pathMetricArray[i][j] >= bestMetric)) continue;
            bestMetric = pathMetricArray[i][j];
            bestI = i;
            bestJ = j;
        }
        if (this.DEBUG && this.doViterbi) {
            String haplotypeString = new String(haplotypeBases);
            String readString = new String(readBases);
            int i = bestI;
            int j = bestJ;
            System.out.println("Simple NW");
            while (i > 0 || j > 0) {
                bestMetricIdx = bestMetricArray[i][j];
                System.out.print(bestMetricIdx);
                if (bestMetricIdx == 1) {
                    haplotypeString = haplotypeString.substring(0, j) + "-" + haplotypeString.substring(j);
                    --i;
                    continue;
                }
                if (bestMetricIdx == 2) {
                    readString = readString.substring(0, i) + "-" + readString.substring(i);
                    --j;
                    continue;
                }
                --i;
                --j;
            }
            System.out.println("\nAlignment: ");
            System.out.println("R:" + readString);
            System.out.println("H:" + haplotypeString);
            System.out.println();
        }
        if (this.DEBUG) {
            System.out.format("Likelihood: %5.4f\n", bestMetric);
        }
        return bestMetric;
    }

    private static void getContextHomopolymerLength(byte[] refBytes, int[] hrunArray) {
        int i;
        boolean runCount = false;
        hrunArray[0] = 0;
        int[] hforward = new int[hrunArray.length];
        int[] hreverse = new int[hrunArray.length];
        for (i = 1; i < refBytes.length; ++i) {
            hforward[i] = refBytes[i] == refBytes[i - 1] ? hforward[i - 1] + 1 : 0;
        }
        for (i = refBytes.length - 1; i > 0; --i) {
            if (refBytes[i - 1] != refBytes[i]) continue;
            int n = i - 1;
            hreverse[n] = hreverse[n] + (hreverse[i] + 1);
        }
        for (i = 1; i < refBytes.length; ++i) {
            hrunArray[i] = hforward[i] + hreverse[i];
        }
    }

    private double computeReadLikelihoodGivenHaplotypeAffineGaps(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, double[] currentGOP, double[] currentGCP) {
        double bestMetric;
        int X_METRIC_LENGTH = readBases.length + 1;
        int Y_METRIC_LENGTH = haplotypeBases.length + 1;
        double[][] matchMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        double[][] XMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        double[][] YMetricArray = new double[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        int[][] bestActionArrayM = new int[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        int[][] bestActionArrayX = new int[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        int[][] bestActionArrayY = new int[X_METRIC_LENGTH][Y_METRIC_LENGTH];
        matchMetricArray[0][0] = END_GAP_COST;
        for (int i = 1; i < X_METRIC_LENGTH; ++i) {
            matchMetricArray[i][0] = Double.NEGATIVE_INFINITY;
            YMetricArray[i][0] = Double.NEGATIVE_INFINITY;
            XMetricArray[i][0] = END_GAP_COST * (double)i;
            bestActionArrayM[i][0] = 5;
            bestActionArrayY[i][0] = 5;
            bestActionArrayX[i][0] = 5;
        }
        for (int j = 1; j < Y_METRIC_LENGTH; ++j) {
            matchMetricArray[0][j] = Double.NEGATIVE_INFINITY;
            XMetricArray[0][j] = Double.NEGATIVE_INFINITY;
            YMetricArray[0][j] = END_GAP_COST * (double)j;
            bestActionArrayX[0][j] = 10;
            bestActionArrayM[0][j] = 10;
            bestActionArrayY[0][j] = 10;
        }
        for (int indI = 1; indI < X_METRIC_LENGTH; ++indI) {
            int im1 = indI - 1;
            for (int indJ = 1; indJ < Y_METRIC_LENGTH; ++indJ) {
                double d;
                double c;
                int jm1 = indJ - 1;
                byte x = readBases[im1];
                byte y = haplotypeBases[jm1];
                int qual = readQuals[im1];
                double bestMetric2 = 0.0;
                int bestMetricIdx = 0;
                if (qual < 1) {
                    qual = 1;
                }
                if (qual > 127) {
                    qual = 127;
                }
                double pBaseRead = x == y ? baseMatchArray[qual] : baseMismatchArray[qual];
                double[] metrics = new double[3];
                if (this.doViterbi) {
                    metrics[0] = matchMetricArray[im1][jm1] + pBaseRead;
                    metrics[1] = XMetricArray[im1][jm1] + pBaseRead;
                    metrics[2] = YMetricArray[im1][jm1] + pBaseRead;
                    bestMetricIdx = MathUtils.maxElementIndex(metrics);
                    bestMetric2 = metrics[bestMetricIdx];
                } else {
                    bestMetric2 = MathUtils.softMax(matchMetricArray[im1][jm1] + pBaseRead, XMetricArray[im1][jm1] + pBaseRead, YMetricArray[im1][jm1] + pBaseRead);
                }
                matchMetricArray[indI][indJ] = bestMetric2;
                bestActionArrayM[indI][indJ] = ACTIONS_M[bestMetricIdx];
                if (this.getGapPenaltiesFromFile) {
                    c = currentGOP[im1];
                    d = this.logGapContinuationProbability;
                } else {
                    c = currentGOP[jm1];
                    d = currentGCP[jm1];
                }
                if (indJ == Y_METRIC_LENGTH - 1) {
                    c = d = END_GAP_COST;
                }
                if (this.doViterbi) {
                    metrics[0] = matchMetricArray[im1][indJ] + c;
                    metrics[1] = XMetricArray[im1][indJ] + d;
                    metrics[2] = Double.NEGATIVE_INFINITY;
                    bestMetricIdx = MathUtils.maxElementIndex(metrics);
                    bestMetric2 = metrics[bestMetricIdx];
                } else {
                    bestMetric2 = MathUtils.softMax(matchMetricArray[im1][indJ] + c, XMetricArray[im1][indJ] + d);
                }
                XMetricArray[indI][indJ] = bestMetric2;
                bestActionArrayX[indI][indJ] = ACTIONS_X[bestMetricIdx];
                if (this.getGapPenaltiesFromFile) {
                    c = currentGOP[im1];
                    d = this.logGapContinuationProbability;
                } else {
                    c = currentGOP[jm1];
                    d = currentGCP[jm1];
                }
                if (indI == X_METRIC_LENGTH - 1) {
                    c = d = END_GAP_COST;
                }
                if (this.doViterbi) {
                    metrics[0] = matchMetricArray[indI][jm1] + c;
                    metrics[1] = Double.NEGATIVE_INFINITY;
                    metrics[2] = YMetricArray[indI][jm1] + d;
                    bestMetricIdx = MathUtils.maxElementIndex(metrics);
                    bestMetric2 = metrics[bestMetricIdx];
                } else {
                    bestMetric2 = MathUtils.softMax(matchMetricArray[indI][jm1] + c, YMetricArray[indI][jm1] + d);
                }
                YMetricArray[indI][indJ] = bestMetric2;
                bestActionArrayY[indI][indJ] = ACTIONS_Y[bestMetricIdx];
            }
        }
        double[] metrics = new double[3];
        int bestTable = 0;
        int bestI = X_METRIC_LENGTH - 1;
        int bestJ = Y_METRIC_LENGTH - 1;
        metrics[0] = matchMetricArray[bestI][bestJ];
        metrics[1] = XMetricArray[bestI][bestJ];
        metrics[2] = YMetricArray[bestI][bestJ];
        if (this.doViterbi) {
            bestTable = MathUtils.maxElementIndex(metrics);
            bestMetric = metrics[bestTable];
        } else {
            bestMetric = MathUtils.softMax(metrics);
        }
        if (this.DEBUG && this.doViterbi) {
            int i = bestI;
            int j = bestJ;
            System.out.println("Affine gap NW");
            String haplotypeString = new String(haplotypeBases);
            String readString = new String(readBases);
            while (i > 0 || j > 0) {
                int bestAction;
                if (bestTable == 1) {
                    haplotypeString = haplotypeString.substring(0, j) + "-" + haplotypeString.substring(j);
                    bestAction = bestActionArrayX[i][j];
                } else if (bestTable == 2) {
                    readString = readString.substring(0, i) + "-" + readString.substring(i);
                    bestAction = bestActionArrayY[i][j];
                } else {
                    bestAction = bestActionArrayM[i][j];
                }
                System.out.print(bestAction);
                bestTable = bestAction & 3;
                int nextDirection = bestAction >> 2;
                if (nextDirection == 1) {
                    --i;
                    continue;
                }
                if (nextDirection == 2) {
                    --j;
                    continue;
                }
                --i;
                --j;
            }
            System.out.println("\nAlignment: ");
            System.out.println("R:" + readString);
            System.out.println("H:" + haplotypeString);
            System.out.println();
        }
        if (this.DEBUG) {
            System.out.format("Likelihood: %5.4f\n", bestMetric);
        }
        return bestMetric;
    }

    private void fillGapProbabilities(int[] hrunProfile, double[] contextLogGapOpenProbabilities, double[] contextLogGapContinuationProbabilities) {
        for (int i = 0; i < hrunProfile.length; ++i) {
            if (hrunProfile[i] >= 20) {
                contextLogGapOpenProbabilities[i] = this.GAP_OPEN_PROB_TABLE[19];
                contextLogGapContinuationProbabilities[i] = this.GAP_CONT_PROB_TABLE[19];
                continue;
            }
            contextLogGapOpenProbabilities[i] = this.GAP_OPEN_PROB_TABLE[hrunProfile[i]];
            contextLogGapContinuationProbabilities[i] = this.GAP_CONT_PROB_TABLE[hrunProfile[i]];
        }
    }

    public synchronized double[] computeReadHaplotypeLikelihoods(ReadBackedPileup pileup, LinkedHashMap<Allele, Haplotype> haplotypeMap, ReferenceContext ref, int eventLength, HashMap<PileupElement, LinkedHashMap<Allele, Double>> indelLikelihoodMap) {
        int numHaplotypes = haplotypeMap.size();
        double[][] haplotypeLikehoodMatrix = new double[numHaplotypes][numHaplotypes];
        double[][] readLikelihoods = new double[pileup.getReads().size()][numHaplotypes];
        int readIdx = 0;
        LinkedHashMap<Allele, double[]> gapOpenProbabilityMap = new LinkedHashMap<Allele, double[]>();
        LinkedHashMap<Allele, double[]> gapContProbabilityMap = new LinkedHashMap<Allele, double[]>();
        if (this.DEBUG) {
            System.out.println("Reference bases:");
            System.out.println(new String(ref.getBases()));
        }
        if (this.doContextDependentPenalties && !this.getGapPenaltiesFromFile) {
            for (Allele a : haplotypeMap.keySet()) {
                Haplotype haplotype = haplotypeMap.get(a);
                byte[] haplotypeBases = haplotype.getBasesAsBytes();
                double[] contextLogGapOpenProbabilities = new double[haplotypeBases.length];
                double[] contextLogGapContinuationProbabilities = new double[haplotypeBases.length];
                int[] hrunProfile = new int[haplotypeBases.length];
                PairHMMIndelErrorModel.getContextHomopolymerLength(haplotypeBases, hrunProfile);
                if (this.DEBUG) {
                    System.out.println("Haplotype bases:");
                    System.out.println(new String(haplotypeBases));
                    for (int i = 0; i < hrunProfile.length; ++i) {
                        System.out.format("%d", hrunProfile[i]);
                    }
                    System.out.println();
                }
                this.fillGapProbabilities(hrunProfile, contextLogGapOpenProbabilities, contextLogGapContinuationProbabilities);
                gapOpenProbabilityMap.put(a, contextLogGapOpenProbabilities);
                gapContProbabilityMap.put(a, contextLogGapContinuationProbabilities);
            }
        }
        for (PileupElement p : pileup) {
            if (indelLikelihoodMap.containsKey(p)) {
                HashMap el = indelLikelihoodMap.get(p);
                int j = 0;
                for (Allele a : haplotypeMap.keySet()) {
                    readLikelihoods[readIdx][j++] = (Double)el.get(a);
                }
            } else {
                int i;
                GATKSAMRecord read = ReadUtils.hardClipAdaptorSequence(p.getRead());
                if (read == null || ReadUtils.is454Read(read) && !this.getGapPenaltiesFromFile) continue;
                double[] recalQuals = null;
                int trailingBases = 3;
                long readStart = read.getUnclippedStart();
                long readEnd = read.getUnclippedEnd();
                long eventStartPos = ref.getLocus().getStart();
                int numStartSoftClippedBases = read.getAlignmentStart() - read.getUnclippedStart();
                int numEndSoftClippedBases = read.getUnclippedEnd() - read.getAlignmentEnd();
                Cigar c = read.getCigar();
                CigarElement first = c.getCigarElement(0);
                CigarElement last = c.getCigarElement(c.numCigarElements() - 1);
                int numStartHardClippedBases = 0;
                int numEndHardClippedBases = 0;
                if (first.getOperator() == CigarOperator.H) {
                    numStartHardClippedBases = first.getLength();
                }
                if (last.getOperator() == CigarOperator.H) {
                    numEndHardClippedBases = last.getLength();
                }
                numStartSoftClippedBases -= numStartHardClippedBases;
                numEndSoftClippedBases -= numEndHardClippedBases;
                readStart += (long)numStartHardClippedBases;
                readEnd -= (long)numEndHardClippedBases;
                if ((long)read.getAlignmentStart() >= eventStartPos - (long)eventLength && (long)read.getAlignmentStart() <= eventStartPos + 1L || (long)read.getAlignmentEnd() >= eventStartPos && (long)read.getAlignmentEnd() <= eventStartPos + (long)eventLength) {
                    numStartSoftClippedBases = 0;
                    numEndSoftClippedBases = 0;
                }
                int numStartClippedBases = numStartSoftClippedBases;
                int numEndClippedBases = numEndSoftClippedBases;
                byte[] unclippedReadBases = read.getReadBases();
                byte[] unclippedReadQuals = read.getBaseQualities();
                for (i = numStartSoftClippedBases; i < unclippedReadBases.length && unclippedReadQuals[i] < 20; ++i) {
                    ++numStartClippedBases;
                }
                for (i = unclippedReadBases.length - numEndSoftClippedBases - 1; i >= 0 && unclippedReadQuals[i] < 20; --i) {
                    ++numEndClippedBases;
                }
                int extraOffset = Math.abs(eventLength);
                long start = Math.max(readStart + (long)numStartClippedBases - 3L - (long)ReadUtils.getFirstInsertionOffset(read) - (long)extraOffset, 0L);
                long stop = readEnd - (long)numEndClippedBases + 3L + (long)ReadUtils.getLastInsertionOffset(read) + (long)extraOffset;
                int readLength = read.getReadLength() - numStartSoftClippedBases - numEndSoftClippedBases;
                if (start < (long)ref.getWindow().getStart()) {
                    start = ref.getWindow().getStart();
                }
                if (stop > (long)ref.getWindow().getStop()) {
                    stop = ref.getWindow().getStop();
                }
                if (stop <= start + (long)readLength) {
                    stop = start + (long)readLength - 1L;
                }
                if (this.DEBUG) {
                    System.out.format("numStartClippedBases: %d numEndClippedBases: %d WinStart:%d WinStop:%d start: %d stop: %d readLength: %d\n", numStartClippedBases, numEndClippedBases, ref.getWindow().getStart(), ref.getWindow().getStop(), start, stop, read.getReadLength());
                }
                LinkedHashMap<Allele, Double> readEl = new LinkedHashMap<Allele, Double>();
                if (numStartClippedBases + numEndClippedBases >= unclippedReadBases.length) {
                    if (this.DEBUG) {
                        System.out.println("BAD READ!!");
                    }
                    int j = 0;
                    for (Allele a : haplotypeMap.keySet()) {
                        readEl.put(a, 0.0);
                        readLikelihoods[readIdx][j++] = 0.0;
                    }
                } else {
                    byte[] readBases = Arrays.copyOfRange(unclippedReadBases, numStartClippedBases, unclippedReadBases.length - numEndClippedBases);
                    byte[] readQuals = Arrays.copyOfRange(unclippedReadQuals, numStartClippedBases, unclippedReadBases.length - numEndClippedBases);
                    double[] recalCDP = null;
                    if (this.getGapPenaltiesFromFile) {
                        recalCDP = Arrays.copyOfRange(recalQuals, numStartClippedBases, unclippedReadBases.length - numEndClippedBases);
                    }
                    if (this.DEBUG) {
                        System.out.println("Read bases:");
                        System.out.println(new String(readBases));
                    }
                    int j = 0;
                    for (Allele a : haplotypeMap.keySet()) {
                        Haplotype haplotype = haplotypeMap.get(a);
                        if (stop > haplotype.getStopPosition()) {
                            stop = haplotype.getStopPosition();
                        }
                        if (start < haplotype.getStartPosition()) {
                            start = haplotype.getStartPosition();
                        }
                        long indStart = start - haplotype.getStartPosition();
                        long indStop = stop - haplotype.getStartPosition();
                        byte[] haplotypeBases = Arrays.copyOfRange(haplotype.getBasesAsBytes(), (int)indStart, (int)indStop);
                        if (this.DEBUG) {
                            System.out.println("Haplotype to test:");
                            System.out.println(new String(haplotypeBases));
                        }
                        Double readLikelihood = 0.0;
                        double[] currentContextGOP = null;
                        double[] currentContextGCP = null;
                        if (this.doContextDependentPenalties) {
                            if (this.getGapPenaltiesFromFile) {
                                readLikelihood = this.computeReadLikelihoodGivenHaplotypeAffineGaps(haplotypeBases, readBases, readQuals, recalCDP, null);
                            } else {
                                currentContextGOP = Arrays.copyOfRange((double[])gapOpenProbabilityMap.get(a), (int)indStart, (int)indStop);
                                currentContextGCP = Arrays.copyOfRange((double[])gapContProbabilityMap.get(a), (int)indStart, (int)indStop);
                                readLikelihood = this.computeReadLikelihoodGivenHaplotypeAffineGaps(haplotypeBases, readBases, readQuals, currentContextGOP, currentContextGCP);
                            }
                        }
                        readEl.put(a, readLikelihood);
                        readLikelihoods[readIdx][j++] = readLikelihood;
                    }
                }
                indelLikelihoodMap.put(p, readEl);
            }
            ++readIdx;
        }
        if (this.DEBUG) {
            System.out.println("\nLikelihood summary");
            for (readIdx = 0; readIdx < pileup.getReads().size(); ++readIdx) {
                System.out.format("Read Index: %d ", readIdx);
                for (int i = 0; i < readLikelihoods[readIdx].length; ++i) {
                    System.out.format("L%d: %f ", i, readLikelihoods[readIdx][i]);
                }
                System.out.println();
            }
        }
        for (int i = 0; i < numHaplotypes; ++i) {
            for (int j = i; j < numHaplotypes; ++j) {
                for (readIdx = 0; readIdx < pileup.getReads().size(); ++readIdx) {
                    if (Double.isInfinite(readLikelihoods[readIdx][i]) && Double.isInfinite(readLikelihoods[readIdx][j])) continue;
                    double[] dArray = haplotypeLikehoodMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + (MathUtils.softMax(readLikelihoods[readIdx][i], readLikelihoods[readIdx][j]) + LOG_ONE_HALF);
                }
            }
        }
        return PairHMMIndelErrorModel.getHaplotypeLikelihoods(haplotypeLikehoodMatrix);
    }

    public static double[] getHaplotypeLikelihoods(double[][] haplotypeLikehoodMatrix) {
        int hSize = haplotypeLikehoodMatrix.length;
        double[] genotypeLikelihoods = new double[hSize * (hSize + 1) / 2];
        int k = 0;
        double maxElement = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < hSize; ++j) {
            for (int i = 0; i <= j; ++i) {
                genotypeLikelihoods[k++] = haplotypeLikehoodMatrix[i][j];
                if (!(haplotypeLikehoodMatrix[i][j] > maxElement)) continue;
                maxElement = haplotypeLikehoodMatrix[i][j];
            }
        }
        int i = 0;
        while (i < genotypeLikelihoods.length) {
            int n = i++;
            genotypeLikelihoods[n] = genotypeLikelihoods[n] - maxElement;
        }
        return genotypeLikelihoods;
    }

    static {
        END_GAP_COST = LOG_ONE_HALF = -Math.log10(2.0);
        baseMatchArray = new double[128];
        baseMismatchArray = new double[128];
        for (int k = 1; k <= 127; ++k) {
            double baseProb = Math.pow(10.0, (double)(-k) / 10.0);
            PairHMMIndelErrorModel.baseMatchArray[k] = Math.log10(1.0 - baseProb);
            PairHMMIndelErrorModel.baseMismatchArray[k] = Math.log10(baseProb);
        }
    }
}

