/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidIndelGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.ExactAFCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.GridSearchAFEstimation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.MultiallelicGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.SNPGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class UnifiedGenotyperEngine {
    public static final String LOW_QUAL_FILTER_NAME = "LowQual";
    private final UnifiedArgumentCollection UAC;
    private final VariantAnnotatorEngine annotationEngine;
    private ThreadLocal<Map<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel>> glcm = new ThreadLocal();
    private ThreadLocal<AlleleFrequencyCalculationModel> afcm = new ThreadLocal();
    private final double[] log10AlleleFrequencyPriorsSNPs;
    private final double[] log10AlleleFrequencyPriorsIndels;
    private ThreadLocal<double[]> log10AlleleFrequencyPosteriors = new ThreadLocal();
    private final GenotypePriors genotypePriorsSNPs;
    private final GenotypePriors genotypePriorsIndels;
    private final Set<String> samples;
    private final Logger logger;
    private final PrintStream verboseWriter;
    private final int N;
    private static final Set<String> filter = new HashSet<String>(1);
    private final boolean BAQEnabledOnCMDLine;

    public UnifiedArgumentCollection getUAC() {
        return this.UAC;
    }

    @Requires(value={"toolkit != null", "UAC != null"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC) {
        this(toolkit, UAC, Logger.getLogger(UnifiedGenotyperEngine.class), null, null, UAC.ASSUME_SINGLE_SAMPLE != null ? new TreeSet<String>(Arrays.asList(UAC.ASSUME_SINGLE_SAMPLE)) : SampleUtils.getSAMFileSamples(toolkit.getSAMFileHeader()));
    }

    @Requires(value={"toolkit != null", "UAC != null", "logger != null", "samples != null && samples.size() > 0"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC, Logger logger, PrintStream verboseWriter, VariantAnnotatorEngine engine, Set<String> samples) {
        this.BAQEnabledOnCMDLine = toolkit.getArguments().BAQMode != BAQ.CalculationMode.OFF;
        this.samples = new TreeSet<String>(samples);
        this.UAC = UAC.clone();
        this.UAC.MIN_MAPPING_QUALTY_SCORE = Math.max(UAC.MIN_MAPPING_QUALTY_SCORE, UAC.MIN_BASE_QUALTY_SCORE);
        this.logger = logger;
        this.verboseWriter = verboseWriter;
        this.annotationEngine = engine;
        this.N = 2 * this.samples.size();
        this.log10AlleleFrequencyPriorsSNPs = new double[this.N + 1];
        this.log10AlleleFrequencyPriorsIndels = new double[this.N + 1];
        this.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsSNPs, GenotypeLikelihoodsCalculationModel.Model.SNP);
        this.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsIndels, GenotypeLikelihoodsCalculationModel.Model.INDEL);
        this.genotypePriorsSNPs = UnifiedGenotyperEngine.createGenotypePriors(GenotypeLikelihoodsCalculationModel.Model.SNP);
        this.genotypePriorsIndels = UnifiedGenotyperEngine.createGenotypePriors(GenotypeLikelihoodsCalculationModel.Model.INDEL);
        filter.add(LOW_QUAL_FILTER_NAME);
    }

    public VariantCallContext calculateLikelihoodsAndGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        if (this.UAC.COVERAGE_AT_WHICH_TO_ABORT > 0 && rawContext.size() > this.UAC.COVERAGE_AT_WHICH_TO_ABORT) {
            return null;
        }
        GenotypeLikelihoodsCalculationModel.Model model = this.getCurrentGLModel(tracker, refContext, rawContext);
        if (model == null) {
            return this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, null, rawContext) : null;
        }
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        if (stratifiedContexts == null) {
            return this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext) : null;
        }
        VariantContext vc = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model);
        if (vc == null) {
            return null;
        }
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model);
    }

    public VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        GenotypeLikelihoodsCalculationModel.Model model = this.getCurrentGLModel(tracker, refContext, rawContext);
        if (model == null) {
            return null;
        }
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        if (stratifiedContexts == null) {
            return null;
        }
        return this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model);
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, VariantContext vc) {
        GenotypeLikelihoodsCalculationModel.Model model = this.getCurrentGLModel(tracker, refContext, rawContext);
        if (model == null) {
            return null;
        }
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model);
    }

    private VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, Map<String, AlignmentContext> stratifiedContexts, AlignmentContextUtils.ReadOrientation type, Allele alternateAlleleToUse, boolean useBAQedPileup, GenotypeLikelihoodsCalculationModel.Model model) {
        if (this.glcm.get() == null) {
            this.glcm.set(UnifiedGenotyperEngine.getGenotypeLikelihoodsCalculationObject(this.logger, this.UAC));
        }
        HashMap<String, MultiallelicGenotypeLikelihoods> GLs = new HashMap<String, MultiallelicGenotypeLikelihoods>();
        Allele refAllele = this.glcm.get().get((Object)model).getLikelihoods(tracker, refContext, stratifiedContexts, type, this.getGenotypePriors(model), GLs, alternateAlleleToUse, useBAQedPileup && this.BAQEnabledOnCMDLine);
        if (refAllele != null) {
            return this.createVariantContextFromLikelihoods(refContext, refAllele, GLs);
        }
        return null;
    }

    private VariantCallContext generateEmptyContext(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, AlignmentContext rawContext) {
        VariantContext vc;
        if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
            if (vcInput == null) {
                return null;
            }
            vc = new VariantContext("UG_call", vcInput.getChr(), (long)vcInput.getStart(), (long)vcInput.getEnd(), vcInput.getAlleles(), -1.0, null, null, ref.getBase());
        } else {
            if (!Allele.acceptableAlleleBases(new byte[]{ref.getBase()})) {
                return null;
            }
            HashSet<Allele> alleles = new HashSet<Allele>();
            alleles.add(Allele.create(ref.getBase(), true));
            vc = new VariantContext("UG_call", ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStart(), alleles);
        }
        if (this.annotationEngine != null) {
            ReadBackedPileup pileup = null;
            if (rawContext.hasExtendedEventPileup()) {
                pileup = rawContext.getExtendedEventPileup();
            } else if (rawContext.hasBasePileup()) {
                pileup = rawContext.getBasePileup();
            }
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup, this.UAC.ASSUME_SINGLE_SAMPLE);
            vc = this.annotationEngine.annotateContext(tracker, ref, stratifiedContexts, vc);
        }
        return new VariantCallContext(vc, false);
    }

    private VariantContext createVariantContextFromLikelihoods(ReferenceContext refContext, Allele refAllele, Map<String, MultiallelicGenotypeLikelihoods> GLs) {
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        LinkedHashSet<Allele> alleles = new LinkedHashSet<Allele>();
        alleles.add(refAllele);
        boolean addedAltAlleles = false;
        HashMap<String, Genotype> genotypes = new HashMap<String, Genotype>();
        for (MultiallelicGenotypeLikelihoods GL : GLs.values()) {
            if (!addedAltAlleles) {
                addedAltAlleles = true;
                for (Allele a : GL.getAlleles()) {
                    alleles.add(a);
                }
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            GenotypeLikelihoods likelihoods = GenotypeLikelihoods.fromLog10Likelihoods(GL.getLikelihoods());
            attributes.put("DP", GL.getDepth());
            attributes.put("PL", likelihoods);
            genotypes.put(GL.getSample(), new Genotype(GL.getSample(), noCall, -1.0, null, attributes, false));
        }
        GenomeLoc loc = refContext.getLocus();
        int endLoc = this.calculateEndPos(alleles, refAllele, loc);
        return new VariantContext("UG_call", loc.getContig(), loc.getStart(), endLoc, alleles, genotypes, -1.0, null, null, refContext.getBase());
    }

    private VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model) {
        double phredScaledConfidence;
        if (this.afcm.get() == null) {
            this.log10AlleleFrequencyPosteriors.set(new double[this.N + 1]);
            this.afcm.set(UnifiedGenotyperEngine.getAlleleFrequencyCalculationObject(this.N, this.logger, this.verboseWriter, this.UAC));
        }
        if (vc.getNSamples() == 0) {
            return this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES ? this.estimateReferenceConfidence(vc, stratifiedContexts, this.getGenotypePriors(model).getHeterozygosity(), false, 1.0) : this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext);
        }
        UnifiedGenotyperEngine.clearAFarray(this.log10AlleleFrequencyPosteriors.get());
        this.afcm.get().getLog10PNonRef(tracker, refContext, vc.getGenotypes(), vc.getAlleles(), this.getAlleleFrequencyPriors(model), this.log10AlleleFrequencyPosteriors.get());
        int bestAFguess = MathUtils.maxElementIndex(this.log10AlleleFrequencyPosteriors.get());
        double[] normalizedPosteriors = MathUtils.normalizeFromLog10(this.log10AlleleFrequencyPosteriors.get());
        double sum = 0.0;
        for (int i = 1; i <= this.N; ++i) {
            sum += normalizedPosteriors[i];
        }
        double PofF = Math.min(sum, 1.0);
        if (bestAFguess != 0 || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            phredScaledConfidence = QualityUtils.phredScaleErrorRate(normalizedPosteriors[0]);
            if (Double.isInfinite(phredScaledConfidence)) {
                phredScaledConfidence = -10.0 * this.log10AlleleFrequencyPosteriors.get()[0];
            }
        } else {
            phredScaledConfidence = QualityUtils.phredScaleErrorRate(PofF);
            if (Double.isInfinite(phredScaledConfidence)) {
                sum = 0.0;
                for (int i = 1; i <= this.N && this.log10AlleleFrequencyPosteriors.get()[i] != -1.7976931348623157E308; ++i) {
                    sum += this.log10AlleleFrequencyPosteriors.get()[i];
                }
                double d = phredScaledConfidence = MathUtils.compareDoubles(sum, 0.0) == 0 ? 0.0 : -10.0 * sum;
            }
        }
        if (this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES && !this.passesEmitThreshold(phredScaledConfidence, bestAFguess)) {
            return this.estimateReferenceConfidence(vc, stratifiedContexts, this.getGenotypePriors(model).getHeterozygosity(), true, 1.0 - PofF);
        }
        Map<String, Genotype> genotypes = this.afcm.get().assignGenotypes(vc, this.log10AlleleFrequencyPosteriors.get(), bestAFguess);
        if (this.verboseWriter != null) {
            this.printVerboseData(refContext.getLocus().toString(), vc, PofF, phredScaledConfidence, normalizedPosteriors, model);
        }
        HashMap<String, Comparable<Boolean>> attributes = new HashMap<String, Comparable<Boolean>>();
        if (rawContext.hasPileupBeenDownsampled()) {
            attributes.put("DS", Boolean.valueOf(true));
        }
        if (this.UAC.COMPUTE_SLOD && bestAFguess != 0) {
            VariantContext vcOverall = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, vc.getAlternateAllele(0), false, model);
            UnifiedGenotyperEngine.clearAFarray(this.log10AlleleFrequencyPosteriors.get());
            this.afcm.get().getLog10PNonRef(tracker, refContext, vcOverall.getGenotypes(), vc.getAlleles(), this.getAlleleFrequencyPriors(model), this.log10AlleleFrequencyPosteriors.get());
            double overallLog10PofF = MathUtils.log10sumLog10(this.log10AlleleFrequencyPosteriors.get(), 1);
            VariantContext vcForward = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.FORWARD, vc.getAlternateAllele(0), false, model);
            UnifiedGenotyperEngine.clearAFarray(this.log10AlleleFrequencyPosteriors.get());
            this.afcm.get().getLog10PNonRef(tracker, refContext, vcForward.getGenotypes(), vc.getAlleles(), this.getAlleleFrequencyPriors(model), this.log10AlleleFrequencyPosteriors.get());
            double forwardLog10PofNull = this.log10AlleleFrequencyPosteriors.get()[0];
            double forwardLog10PofF = MathUtils.log10sumLog10(this.log10AlleleFrequencyPosteriors.get(), 1);
            VariantContext vcReverse = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.REVERSE, vc.getAlternateAllele(0), false, model);
            UnifiedGenotyperEngine.clearAFarray(this.log10AlleleFrequencyPosteriors.get());
            this.afcm.get().getLog10PNonRef(tracker, refContext, vcReverse.getGenotypes(), vc.getAlleles(), this.getAlleleFrequencyPriors(model), this.log10AlleleFrequencyPosteriors.get());
            double reverseLog10PofNull = this.log10AlleleFrequencyPosteriors.get()[0];
            double reverseLog10PofF = MathUtils.log10sumLog10(this.log10AlleleFrequencyPosteriors.get(), 1);
            double forwardLod = forwardLog10PofF + reverseLog10PofNull - overallLog10PofF;
            double reverseLod = reverseLog10PofF + forwardLog10PofNull - overallLog10PofF;
            double strandScore = Math.max(forwardLod, reverseLod);
            attributes.put("SB", Double.valueOf(strandScore *= 10.0));
        }
        GenomeLoc loc = refContext.getLocus();
        int endLoc = this.calculateEndPos(vc.getAlleles(), vc.getReference(), loc);
        Set<Allele> myAlleles = vc.getAlleles();
        if (bestAFguess == 0 && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY) {
            myAlleles = new HashSet<Allele>(1);
            myAlleles.add(vc.getReference());
        }
        VariantContext vcCall = new VariantContext("UG_call", loc.getContig(), loc.getStart(), endLoc, myAlleles, genotypes, phredScaledConfidence / 10.0, this.passesCallThreshold(phredScaledConfidence) ? null : filter, attributes, refContext.getBase());
        if (this.annotationEngine != null) {
            ReadBackedPileup pileup = null;
            if (rawContext.hasExtendedEventPileup()) {
                pileup = rawContext.getExtendedEventPileup();
            } else if (rawContext.hasBasePileup()) {
                pileup = rawContext.getBasePileup();
            }
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup, this.UAC.ASSUME_SINGLE_SAMPLE);
            vcCall = this.annotationEngine.annotateContext(tracker, refContext, stratifiedContexts, vcCall);
        }
        return new VariantCallContext(vcCall, this.confidentlyCalled(phredScaledConfidence, PofF));
    }

    private int calculateEndPos(Set<Allele> alleles, Allele refAllele, GenomeLoc loc) {
        boolean isSNP = true;
        boolean hasNullAltAllele = false;
        for (Allele a : alleles) {
            if (a.length() == 1) continue;
            isSNP = false;
            break;
        }
        for (Allele a : alleles) {
            if (!a.isNull()) continue;
            hasNullAltAllele = true;
            break;
        }
        int endLoc = loc.getStart();
        if (!isSNP) {
            endLoc += refAllele.length();
            if (!hasNullAltAllele) {
                --endLoc;
            }
        }
        return endLoc;
    }

    private Map<String, AlignmentContext> getFilteredAndStratifiedContexts(UnifiedArgumentCollection UAC, ReferenceContext refContext, AlignmentContext rawContext, GenotypeLikelihoodsCalculationModel.Model model) {
        Map<String, AlignmentContext> stratifiedContexts = null;
        if (!BaseUtils.isRegularBase(refContext.getBase())) {
            return null;
        }
        if (model == GenotypeLikelihoodsCalculationModel.Model.INDEL) {
            if (UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                ReadBackedPileup pileup = rawContext.getBasePileup().getMappingFilteredPileup(UAC.MIN_MAPPING_QUALTY_SCORE);
                if (pileup.size() == 0 && UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES) {
                    return null;
                }
                stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup, UAC.ASSUME_SINGLE_SAMPLE);
            } else {
                if (!rawContext.hasExtendedEventPileup()) {
                    return null;
                }
                ReadBackedExtendedEventPileup rawPileup = rawContext.getExtendedEventPileup();
                ReadBackedExtendedEventPileup pileup = rawPileup.getMappingFilteredPileup(UAC.MIN_MAPPING_QUALTY_SCORE);
                if (pileup.size() == 0 && UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES) {
                    return null;
                }
                stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup, UAC.ASSUME_SINGLE_SAMPLE);
            }
        } else if (model == GenotypeLikelihoodsCalculationModel.Model.SNP) {
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(rawContext.getBasePileup(), UAC.ASSUME_SINGLE_SAMPLE);
            if (UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES || UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                int numDeletions = 0;
                for (PileupElement p : rawContext.getBasePileup()) {
                    if (!p.isDeletion()) continue;
                    ++numDeletions;
                }
                if ((double)numDeletions / (double)rawContext.getBasePileup().size() > UAC.MAX_DELETION_FRACTION) {
                    return null;
                }
            }
        }
        return stratifiedContexts;
    }

    protected static void clearAFarray(double[] AFs) {
        for (int i = 0; i < AFs.length; ++i) {
            AFs[i] = -1.7976931348623157E308;
        }
    }

    private VariantCallContext estimateReferenceConfidence(VariantContext vc, Map<String, AlignmentContext> contexts, double theta, boolean ignoreCoveredSamples, double initialPofRef) {
        if (contexts == null) {
            return null;
        }
        double P_of_ref = initialPofRef;
        for (String sample : this.samples) {
            boolean isCovered = contexts.containsKey(sample);
            if (ignoreCoveredSamples && isCovered) continue;
            int depth = 0;
            if (isCovered) {
                AlignmentContext context = contexts.get(sample);
                if (context.hasBasePileup()) {
                    depth = context.getBasePileup().size();
                } else if (context.hasExtendedEventPileup()) {
                    depth = context.getExtendedEventPileup().size();
                }
            }
            P_of_ref *= 1.0 - theta / 2.0 * MathUtils.binomialProbability(0, depth, 0.5);
        }
        return new VariantCallContext(vc, QualityUtils.phredScaleErrorRate(1.0 - P_of_ref) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, false);
    }

    protected void printVerboseData(String pos, VariantContext vc, double PofF, double phredScaledConfidence, double[] normalizedPosteriors, GenotypeLikelihoodsCalculationModel.Model model) {
        Allele refAllele = null;
        Allele altAllele = null;
        for (Allele allele : vc.getAlleles()) {
            if (allele.isReference()) {
                refAllele = allele;
                continue;
            }
            altAllele = allele;
        }
        for (int i = 0; i <= this.N; ++i) {
            StringBuilder AFline = new StringBuilder("AFINFO\t");
            AFline.append(pos);
            AFline.append("\t");
            AFline.append(refAllele);
            AFline.append("\t");
            if (altAllele != null) {
                AFline.append(altAllele);
            } else {
                AFline.append("N/A");
            }
            AFline.append("\t");
            AFline.append(i + "/" + this.N + "\t");
            AFline.append(String.format("%.2f\t", Float.valueOf((float)i / (float)this.N)));
            AFline.append(String.format("%.8f\t", this.getAlleleFrequencyPriors(model)[i]));
            if (this.log10AlleleFrequencyPosteriors.get()[i] == -1.7976931348623157E308) {
                AFline.append("0.00000000\t");
            } else {
                AFline.append(String.format("%.8f\t", this.log10AlleleFrequencyPosteriors.get()[i]));
            }
            AFline.append(String.format("%.8f\t", normalizedPosteriors[i]));
            this.verboseWriter.println(AFline.toString());
        }
        this.verboseWriter.println("P(f>0) = " + PofF);
        this.verboseWriter.println("Qscore = " + phredScaledConfidence);
        this.verboseWriter.println();
    }

    protected boolean passesEmitThreshold(double conf, int bestAFguess) {
        return (this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_CONFIDENT_SITES || bestAFguess != 0) && conf >= Math.min(this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING);
    }

    protected boolean passesCallThreshold(double conf) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    protected boolean confidentlyCalled(double conf, double PofF) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES && QualityUtils.phredScaleErrorRate(PofF) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    private GenotypeLikelihoodsCalculationModel.Model getCurrentGLModel(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        if (rawContext.hasExtendedEventPileup()) {
            if ((this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.INDEL) && this.UAC.GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                return GenotypeLikelihoodsCalculationModel.Model.INDEL;
            }
        } else if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, refContext, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
            if (vcInput == null) {
                return null;
            }
            if (vcInput.isMNP()) {
                return null;
            }
            if (vcInput.isSNP()) {
                if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.SNP) {
                    return GenotypeLikelihoodsCalculationModel.Model.SNP;
                }
                return null;
            }
            if ((vcInput.isIndel() || vcInput.isMixed()) && (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.INDEL)) {
                return GenotypeLikelihoodsCalculationModel.Model.INDEL;
            }
        } else {
            if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.SNP) {
                return GenotypeLikelihoodsCalculationModel.Model.SNP;
            }
            if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.INDEL) {
                return GenotypeLikelihoodsCalculationModel.Model.INDEL;
            }
        }
        return null;
    }

    protected void computeAlleleFrequencyPriors(int N, double[] priors, GenotypeLikelihoodsCalculationModel.Model model) {
        double sum = 0.0;
        double heterozygosity = model == GenotypeLikelihoodsCalculationModel.Model.INDEL ? this.UAC.INDEL_HETEROZYGOSITY : this.UAC.heterozygosity;
        for (int i = 1; i <= N; ++i) {
            double value = heterozygosity / (double)i;
            priors[i] = Math.log10(value);
            sum += value;
        }
        priors[0] = Math.log10(1.0 - sum);
    }

    protected double[] getAlleleFrequencyPriors(GenotypeLikelihoodsCalculationModel.Model model) {
        switch (model) {
            case SNP: {
                return this.log10AlleleFrequencyPriorsSNPs;
            }
            case INDEL: {
                return this.log10AlleleFrequencyPriorsIndels;
            }
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    private static GenotypePriors createGenotypePriors(GenotypeLikelihoodsCalculationModel.Model model) {
        GenotypePriors priors;
        switch (model) {
            case SNP: {
                priors = new DiploidSNPGenotypePriors();
                break;
            }
            case INDEL: {
                priors = new DiploidIndelGenotypePriors();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
            }
        }
        return priors;
    }

    protected GenotypePriors getGenotypePriors(GenotypeLikelihoodsCalculationModel.Model model) {
        switch (model) {
            case SNP: {
                return this.genotypePriorsSNPs;
            }
            case INDEL: {
                return this.genotypePriorsIndels;
            }
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    private static Map<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel> getGenotypeLikelihoodsCalculationObject(Logger logger, UnifiedArgumentCollection UAC) {
        HashMap<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel> glcm = new HashMap<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel>();
        glcm.put(GenotypeLikelihoodsCalculationModel.Model.SNP, new SNPGenotypeLikelihoodsCalculationModel(UAC, logger));
        glcm.put(GenotypeLikelihoodsCalculationModel.Model.INDEL, new IndelGenotypeLikelihoodsCalculationModel(UAC, logger));
        return glcm;
    }

    private static AlleleFrequencyCalculationModel getAlleleFrequencyCalculationObject(int N, Logger logger, PrintStream verboseWriter, UnifiedArgumentCollection UAC) {
        AlleleFrequencyCalculationModel afcm;
        switch (UAC.AFmodel) {
            case EXACT: {
                afcm = new ExactAFCalculationModel(UAC, N, logger, verboseWriter);
                break;
            }
            case GRID_SEARCH: {
                afcm = new GridSearchAFEstimation(UAC, N, logger, verboseWriter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected AlleleFrequencyCalculationModel " + (Object)((Object)UAC.AFmodel));
            }
        }
        return afcm;
    }

    public static VariantContext getVCFromAllelesRod(RefMetaDataTracker tracker, ReferenceContext ref, GenomeLoc loc, boolean requireSNP, Logger logger, RodBinding<VariantContext> allelesBinding) {
        if (tracker == null || ref == null || logger == null) {
            throw new ReviewedStingException("Bad arguments: tracker=" + tracker + " ref=" + ref + " logger=" + logger);
        }
        VariantContext vc = null;
        for (VariantContext vc_input : tracker.getValues(allelesBinding, loc)) {
            if (vc_input == null || vc_input.isFiltered() || requireSNP && !vc_input.isSNP()) continue;
            if (vc == null) {
                vc = vc_input;
                continue;
            }
            logger.warn("Multiple valid VCF records detected in the alleles input file at site " + ref.getLocus() + ", only considering the first record");
        }
        return vc;
    }

    public static enum OUTPUT_MODE {
        EMIT_VARIANTS_ONLY,
        EMIT_ALL_CONFIDENT_SITES,
        EMIT_ALL_SITES;

    }
}

