/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class UGCallVariants
extends RodWalker<VariantCallContext, Integer> {
    @ArgumentCollection
    private UnifiedArgumentCollection UAC = new UnifiedArgumentCollection();
    @Input(fullName="variant", shortName="V", doc="Input VCF file", required=true)
    public List<RodBinding<VariantContext>> variants;
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    private UnifiedGenotyperEngine UG_engine = null;
    private Set<String> trackNames = new HashSet<String>();

    @Override
    public void initialize() {
        for (RodBinding<VariantContext> rb : this.variants) {
            this.trackNames.add(rb.getName());
        }
        Set<String> samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), this.trackNames);
        this.UG_engine = new UnifiedGenotyperEngine(this.getToolkit(), this.UAC, logger, null, null, samples);
        HashSet<VCFHeaderLine> headerInfo = new HashSet<VCFHeaderLine>();
        headerInfo.add(new VCFInfoHeaderLine("AF", -1, VCFHeaderLineType.Float, "Allele Frequency, for each ALT allele, in the same order as listed"));
        headerInfo.add(new VCFInfoHeaderLine("AC", -1, VCFHeaderLineType.Integer, "Allele count in genotypes, for each ALT allele, in the same order as listed"));
        headerInfo.add(new VCFInfoHeaderLine("AN", 1, VCFHeaderLineType.Integer, "Total number of alleles in called genotypes"));
        headerInfo.add(new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
        headerInfo.add(new VCFFormatHeaderLine("GQ", 1, VCFHeaderLineType.Float, "Genotype Quality"));
        headerInfo.add(new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Read Depth (only filtered reads used for calling)"));
        headerInfo.add(new VCFFormatHeaderLine("PL", 3, VCFHeaderLineType.Float, "Normalized, Phred-scaled likelihoods for AA,AB,BB genotypes where A=ref and B=alt; not applicable if site is not biallelic"));
        if (this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING < this.UAC.STANDARD_CONFIDENCE_FOR_CALLING) {
            headerInfo.add(new VCFFilterHeaderLine("LowQual", "Low quality"));
        }
        this.writer.writeHeader(new VCFHeader(headerInfo, samples));
    }

    @Override
    public VariantCallContext map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        List<VariantContext> VCs = tracker.getValues(this.variants, context.getLocation());
        VariantContext mergedVC = UGCallVariants.mergeVCsWithGLs(VCs);
        if (mergedVC == null) {
            return null;
        }
        return this.UG_engine.calculateGenotypes(tracker, ref, context, mergedVC);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(VariantCallContext value, Integer sum) {
        if (value == null) {
            return sum;
        }
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>(value.getAttributes());
            VariantContextUtils.calculateChromosomeCounts(value, attrs, true);
            this.writer.add(VariantContext.modifyAttributes(value, attrs));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "; this is often caused by using the --assume_single_sample_reads argument with the wrong sample name");
        }
        return sum + 1;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info(String.format("Visited sites: %d", result));
    }

    private static VariantContext mergeVCsWithGLs(List<VariantContext> VCs) {
        if (VCs.size() == 0) {
            return null;
        }
        VariantContext variantVC = null;
        HashMap<String, Genotype> genotypes = new HashMap<String, Genotype>();
        for (VariantContext vc : VCs) {
            if (variantVC == null && vc.isVariant()) {
                variantVC = vc;
            }
            genotypes.putAll(UGCallVariants.getGenotypesWithGLs(vc.getGenotypes()));
        }
        if (variantVC == null) {
            VariantContext vc = VCs.get(0);
            throw new UserException("There is no ALT allele in any of the VCF records passed in at " + vc.getChr() + ":" + vc.getStart());
        }
        return new VariantContext("VCwithGLs", variantVC.getChr(), (long)variantVC.getStart(), (long)variantVC.getEnd(), variantVC.getAlleles(), genotypes, -1.0, null, null);
    }

    private static Map<String, Genotype> getGenotypesWithGLs(Map<String, Genotype> genotypes) {
        HashMap<String, Genotype> genotypesWithGLs = new HashMap<String, Genotype>();
        for (Map.Entry<String, Genotype> g : genotypes.entrySet()) {
            if (!g.getValue().hasLikelihoods() || g.getValue().getLikelihoods().getAsVector() == null) continue;
            genotypesWithGLs.put(g.getKey(), g.getValue());
        }
        return genotypesWithGLs;
    }
}

