/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.HashSet;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Downsample;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@BAQMode(QualityMode=BAQ.QualityMode.ADD_TAG, ApplicationTime=BAQ.ApplicationTime.ON_INPUT)
@Reference(window=@Window(start=-200, stop=200))
@By(value=DataSource.READS)
@Downsample(by=DownsampleType.BY_SAMPLE, toCoverage=250)
public class UGCalcLikelihoods
extends LocusWalker<VariantCallContext, Integer>
implements TreeReducible<Integer> {
    @ArgumentCollection
    private UnifiedArgumentCollection UAC = new UnifiedArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    private UnifiedGenotyperEngine UG_engine = null;

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public boolean generateExtendedEvents() {
        return this.UAC.GLmodel != GenotypeLikelihoodsCalculationModel.Model.SNP;
    }

    @Override
    public void initialize() {
        TreeSet<String> samples = new TreeSet<String>();
        if (this.UAC.ASSUME_SINGLE_SAMPLE != null) {
            samples.add(this.UAC.ASSUME_SINGLE_SAMPLE);
        } else {
            samples = SampleUtils.getSAMFileSamples(this.getToolkit().getSAMFileHeader());
        }
        this.UG_engine = new UnifiedGenotyperEngine(this.getToolkit(), this.UAC, logger, null, null, samples);
        HashSet<VCFHeaderLine> headerInfo = new HashSet<VCFHeaderLine>();
        headerInfo.add(new VCFInfoHeaderLine("DS", 0, VCFHeaderLineType.Flag, "Were any of the samples downsampled?"));
        headerInfo.add(new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
        headerInfo.add(new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Read Depth (only filtered reads used for calling)"));
        headerInfo.add(new VCFFormatHeaderLine("PL", 3, VCFHeaderLineType.Float, "Normalized, Phred-scaled likelihoods for AA,AB,BB genotypes where A=ref and B=alt; not applicable if site is not biallelic"));
        this.writer.writeHeader(new VCFHeader(headerInfo, samples));
    }

    @Override
    public VariantCallContext map(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        VariantContext call = this.UG_engine.calculateLikelihoods(tracker, refContext, rawContext);
        return call == null ? null : new VariantCallContext(call, true);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    @Override
    public Integer reduce(VariantCallContext value, Integer sum) {
        if (value == null) {
            return sum;
        }
        try {
            this.writer.add(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "; this is often caused by using the --assume_single_sample_reads argument with the wrong sample name");
        }
        return sum + 1;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        logger.info(String.format("Visited bases: %d", sum));
    }
}

