/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import org.broadinstitute.sting.utils.variantcontext.Allele;

public class BiallelicGenotypeLikelihoods {
    private String sample;
    private double[] GLs;
    private Allele A;
    private Allele B;
    private int depth;

    public BiallelicGenotypeLikelihoods(String sample, Allele A, Allele B, double log10AALikelihoods, double log10ABLikelihoods, double log10BBLikelihoods, int depth) {
        this.sample = sample;
        this.A = A;
        this.B = B;
        this.GLs = new double[]{log10AALikelihoods, log10ABLikelihoods, log10BBLikelihoods};
        this.depth = depth;
    }

    public String getSample() {
        return this.sample;
    }

    public double getAALikelihoods() {
        return this.GLs[0];
    }

    public double getABLikelihoods() {
        return this.GLs[1];
    }

    public double getBBLikelihoods() {
        return this.GLs[2];
    }

    public double[] getLikelihoods() {
        return this.GLs;
    }

    public Allele getAlleleA() {
        return this.A;
    }

    public Allele getAlleleB() {
        return this.B;
    }

    public int getDepth() {
        return this.depth;
    }
}

