/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics;

import java.io.PrintStream;
import java.util.List;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;

public class ReadLengthDistribution
extends ReadWalker<Integer, Integer> {
    @Output
    public PrintStream out;
    private GATKReport report;

    @Override
    public void initialize() {
        this.report = new GATKReport();
        this.report.addTable("ReadLengthDistribution", "Table of read length distributions");
        GATKReportTable table = this.report.getTable("ReadLengthDistribution");
        table.addPrimaryKey("readLength");
        List<SAMReadGroupRecord> readGroups = this.getToolkit().getSAMFileHeader().getReadGroups();
        if (readGroups.isEmpty()) {
            table.addColumn("SINGLE_SAMPLE", 0);
        } else {
            for (SAMReadGroupRecord rg : readGroups) {
                table.addColumn(rg.getSample(), 0);
            }
        }
    }

    @Override
    public boolean filter(ReferenceContext ref, SAMRecord read) {
        return !read.getReadPairedFlag() || read.getReadPairedFlag() && read.getFirstOfPairFlag();
    }

    @Override
    public Integer map(ReferenceContext referenceContext, SAMRecord samRecord, ReadMetaDataTracker readMetaDataTracker) {
        GATKReportTable table = this.report.getTable("ReadLengthDistribution");
        int length = Math.abs(samRecord.getReadLength());
        String sample = samRecord.getReadGroup().getSample();
        table.increment(length, sample);
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer integer, Integer integer1) {
        return null;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        this.report.print(this.out);
    }
}

