/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.MannWhitneyU;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class RankSumTest
extends InfoFieldAnnotation
implements StandardAnnotation {
    static final double INDEL_LIKELIHOOD_THRESH = 0.1;
    static final boolean DEBUG = false;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        AlignmentContext context;
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        Map<String, Genotype> genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        ArrayList<Double> refQuals = new ArrayList<Double>();
        ArrayList<Double> altQuals = new ArrayList<Double>();
        if (vc.isSNP() && vc.isBiallelic()) {
            for (Map.Entry<String, Genotype> genotype : genotypes.entrySet()) {
                context = stratifiedContexts.get(genotype.getKey());
                if (context == null) continue;
                this.fillQualsFromPileup(ref.getBase(), vc.getAlternateAllele(0).getBases()[0], context.getBasePileup(), refQuals, altQuals);
            }
        } else if (vc.isIndel() || vc.isMixed()) {
            for (Map.Entry<String, Genotype> genotype : genotypes.entrySet()) {
                context = stratifiedContexts.get(genotype.getKey());
                if (context == null) continue;
                ReadBackedPileup pileup = null;
                if (context.hasExtendedEventPileup()) {
                    pileup = context.getExtendedEventPileup();
                } else if (context.hasBasePileup()) {
                    pileup = context.getBasePileup();
                }
                if (pileup == null) continue;
                if (IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap() == null || IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap().size() == 0) {
                    return null;
                }
                this.fillIndelQualsFromPileup(pileup, refQuals, altQuals);
            }
        } else {
            return null;
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU();
        for (Double qual : altQuals) {
            mannWhitneyU.add(qual, MannWhitneyU.USet.SET1);
        }
        for (Double qual : refQuals) {
            mannWhitneyU.add(qual, MannWhitneyU.USet.SET2);
        }
        Pair<Double, Double> testResults = mannWhitneyU.runOneSidedTest(MannWhitneyU.USet.SET1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Double.isNaN((Double)testResults.first)) {
            map.put(this.getKeyNames().get(0), String.format("%.3f", testResults.first));
        }
        return map;
    }

    protected abstract void fillQualsFromPileup(byte var1, byte var2, ReadBackedPileup var3, List<Double> var4, List<Double> var5);

    protected abstract void fillIndelQualsFromPileup(ReadBackedPileup var1, List<Double> var2, List<Double> var3);

    protected static boolean isUsableBase(PileupElement p) {
        return !p.isDeletion() && p.getMappingQual() != 0 && p.getMappingQual() != 255 && p.getQual() >= 6;
    }
}

