/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.filters.MalformedReadFilter;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@ReadFilters(value={MalformedReadFilter.class})
@PartitionBy(value=PartitionType.NONE)
@BAQMode(QualityMode=BAQ.QualityMode.OVERWRITE_QUALS, ApplicationTime=BAQ.ApplicationTime.ON_INPUT)
@DocumentedGATKFeature(groupName="GATK walkers", summary="General tools available for running on the command line as part of the GATK package", extraDocs={CommandLineGATK.class})
public abstract class Walker<MapType, ReduceType> {
    protected static final Logger logger = Logger.getLogger(Walker.class);
    private GenomeAnalysisEngine toolkit;

    protected Walker() {
    }

    public void setToolkit(GenomeAnalysisEngine toolkit) {
        this.toolkit = toolkit;
    }

    protected GenomeAnalysisEngine getToolkit() {
        return this.toolkit;
    }

    public boolean includeReadsWithDeletionAtLoci() {
        return false;
    }

    public boolean generateExtendedEvents() {
        return false;
    }

    public void initialize() {
    }

    public boolean isDone() {
        return false;
    }

    public abstract ReduceType reduceInit();

    public abstract ReduceType reduce(MapType var1, ReduceType var2);

    public void onTraversalDone(ReduceType result) {
        logger.info("[REDUCE RESULT] Traversal result is: " + result);
    }

    public void onTraversalDone(List<Pair<GenomeLoc, ReduceType>> results) {
        for (Pair<GenomeLoc, ReduceType> result : results) {
            logger.info(String.format("[INTERVAL REDUCE RESULT] at %s ", result.getFirst()));
            this.onTraversalDone(result.getSecond());
        }
    }

    public boolean isReduceByInterval() {
        return false;
    }
}

