/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;

@BAQMode(QualityMode=BAQ.QualityMode.ADD_TAG, ApplicationTime=BAQ.ApplicationTime.ON_OUTPUT)
@Requires(value={DataSource.READS, DataSource.REFERENCE})
public class PrintReadsWalker
extends ReadWalker<SAMRecord, SAMFileWriter> {
    @Output(doc="Write output to this BAM filename instead of STDOUT")
    SAMFileWriter out;
    @Argument(fullName="readGroup", shortName="readGroup", doc="Exclude all reads with this read group from the output", required=false)
    String readGroup = null;
    @Argument(fullName="platform", shortName="platform", doc="Exclude all reads with this platform from the output", required=false)
    String platform = null;
    @Argument(fullName="number", shortName="n", doc="Print the first n reads from the file, discarding the rest", required=false)
    int nReadsToPrint = -1;
    @Argument(fullName="sample_file", shortName="sf", doc="File containing a list of samples (one per line). Can be specified multiple times", required=false)
    public Set<File> sampleFile = new TreeSet<File>();
    @Argument(fullName="sample_name", shortName="sn", doc="Sample name to be included in the analysis. Can be specified multiple times.", required=false)
    public Set<String> sampleNames = new TreeSet<String>();
    private TreeSet<String> samplesToChoose = new TreeSet();
    private boolean SAMPLES_SPECIFIED = false;

    @Override
    public void initialize() {
        if (this.platform != null) {
            this.platform = this.platform.toUpperCase();
        }
        if (!this.sampleFile.isEmpty()) {
            Collection<String> samplesFromFile = SampleUtils.getSamplesFromFiles(this.sampleFile);
            this.samplesToChoose.addAll(samplesFromFile);
        }
        if (!this.sampleNames.isEmpty()) {
            this.samplesToChoose.addAll(this.sampleNames);
        }
        if (!this.samplesToChoose.isEmpty()) {
            this.SAMPLES_SPECIFIED = true;
        }
    }

    @Override
    public boolean filter(ReferenceContext ref, SAMRecord read) {
        SAMReadGroupRecord myReadGroup;
        if (!(this.readGroup == null || (myReadGroup = read.getReadGroup()) != null && this.readGroup.equals(myReadGroup.getReadGroupId()))) {
            return false;
        }
        if (this.platform != null) {
            SAMReadGroupRecord readGroup = read.getReadGroup();
            if (readGroup == null) {
                return false;
            }
            String readPlatformAttr = readGroup.getAttribute("PL");
            if (readPlatformAttr == null || !readPlatformAttr.toString().toUpperCase().contains(this.platform)) {
                return false;
            }
        }
        if (this.SAMPLES_SPECIFIED && !this.samplesToChoose.contains(read.getReadGroup().getSample())) {
            return false;
        }
        if (this.nReadsToPrint == 0) {
            return false;
        }
        if (this.nReadsToPrint > 0) {
            --this.nReadsToPrint;
        }
        return true;
    }

    @Override
    public SAMRecord map(ReferenceContext ref, SAMRecord read, ReadMetaDataTracker metaDataTracker) {
        return read;
    }

    @Override
    public SAMFileWriter reduceInit() {
        return this.out;
    }

    @Override
    public SAMFileWriter reduce(SAMRecord read, SAMFileWriter output) {
        output.addAlignment(read);
        return output;
    }
}

