/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.clipreads.ClippingOp;
import org.broadinstitute.sting.utils.clipreads.ClippingRepresentation;
import org.broadinstitute.sting.utils.clipreads.ReadClipper;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.sam.ReadUtils;

@Requires(value={DataSource.READS})
public class ClipReadsWalker
extends ReadWalker<ReadClipperWithData, ClippingData> {
    @Output(fullName="outputStatistics", shortName="os", doc="Write output statistics to this file", required=false)
    PrintStream out = null;
    @Output(doc="Write BAM output here", required=true)
    StingSAMFileWriter outputBam;
    @Argument(fullName="qTrimmingThreshold", shortName="QT", doc="If provided, the Q-score clipper will be applied", required=false)
    int qTrimmingThreshold = -1;
    @Argument(fullName="cyclesToTrim", shortName="CT", doc="String indicating machine cycles to clip from the reads", required=false)
    String cyclesToClipArg = null;
    @Argument(fullName="clipSequencesFile", shortName="XF", doc="Remove sequences within reads matching the sequences in this FASTA file", required=false)
    String clipSequenceFile = null;
    @Argument(fullName="clipSequence", shortName="X", doc="Remove sequences within reads matching this sequence", required=false)
    String[] clipSequencesArgs = null;
    @Argument(fullName="clipRepresentation", shortName="CR", doc="How should we actually clip the bases?", required=false)
    ClippingRepresentation clippingRepresentation = ClippingRepresentation.WRITE_NS;
    @Hidden
    @Advanced
    @Argument(fullName="read", doc="", required=false)
    String onlyDoRead = null;
    List<SeqToClip> sequencesToClip = new ArrayList<SeqToClip>();
    List<Pair<Integer, Integer>> cyclesToClip = null;

    @Override
    public void initialize() {
        if (this.qTrimmingThreshold >= 0) {
            logger.info(String.format("Creating Q-score clipper with threshold %d", this.qTrimmingThreshold));
        }
        if (this.clipSequencesArgs != null) {
            int i = 0;
            for (String toClip : this.clipSequencesArgs) {
                ReferenceSequence rs = new ReferenceSequence("CMDLINE-" + ++i, -1, StringUtil.stringToBytes(toClip));
                this.addSeqToClip(rs.getName(), rs.getBases());
            }
        }
        if (this.clipSequenceFile != null) {
            ReferenceSequence rs;
            ReferenceSequenceFile rsf = ReferenceSequenceFileFactory.getReferenceSequenceFile(new File(this.clipSequenceFile));
            while ((rs = rsf.nextSequence()) != null) {
                this.addSeqToClip(rs.getName(), rs.getBases());
            }
        }
        if (this.cyclesToClipArg != null) {
            this.cyclesToClip = new ArrayList<Pair<Integer, Integer>>();
            for (String range : this.cyclesToClipArg.split(",")) {
                try {
                    String[] elts = range.split("-");
                    int start = Integer.parseInt(elts[0]) - 1;
                    int stop = Integer.parseInt(elts[1]) - 1;
                    if (start < 0) {
                        throw new Exception();
                    }
                    if (stop < start) {
                        throw new Exception();
                    }
                    logger.info(String.format("Creating cycle clipper %d-%d", start, stop));
                    this.cyclesToClip.add(new Pair<Integer, Integer>(start, stop));
                }
                catch (Exception e) {
                    throw new RuntimeException("Badly formatted cyclesToClip argument: " + this.cyclesToClipArg);
                }
            }
        }
        if (this.outputBam != null) {
            EnumSet<ClippingRepresentation> presorted = EnumSet.of(ClippingRepresentation.WRITE_NS, ClippingRepresentation.WRITE_NS_Q0S, ClippingRepresentation.WRITE_Q0S);
            this.outputBam.setPresorted(presorted.contains((Object)this.clippingRepresentation));
        }
    }

    private void addSeqToClip(String name, byte[] bases) {
        SeqToClip clip = new SeqToClip(name, StringUtil.bytesToString(bases));
        this.sequencesToClip.add(clip);
        logger.info(String.format("Creating sequence clipper %s: %s/%s", clip.name, clip.seq, clip.revSeq));
    }

    @Override
    public ReadClipperWithData map(ReferenceContext ref, SAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (this.onlyDoRead == null || read.getReadName().equals(this.onlyDoRead)) {
            if (this.clippingRepresentation == ClippingRepresentation.HARDCLIP_BASES) {
                read = ReadUtils.replaceSoftClipsWithMatches(read);
            }
            ReadClipperWithData clipper = new ReadClipperWithData(read, this.sequencesToClip);
            this.clipBadQualityScores(clipper);
            this.clipCycles(clipper);
            this.clipSequences(clipper);
            return clipper;
        }
        return null;
    }

    private void clipSequences(ReadClipperWithData clipper) {
        if (this.sequencesToClip != null) {
            SAMRecord read = clipper.getRead();
            ClippingData data = clipper.getData();
            for (SeqToClip stc : this.sequencesToClip) {
                Pattern pattern = read.getReadNegativeStrandFlag() ? stc.revPat : stc.fwdPat;
                String bases = read.getReadString();
                Matcher match = pattern.matcher(bases);
                boolean found = true;
                while (found) {
                    found = match.find();
                    if (!found) continue;
                    int start = match.start();
                    int stop = match.end() - 1;
                    ClippingOp op = new ClippingOp(start, stop);
                    clipper.addOp(op);
                    data.incSeqClippedBases(stc.seq, op.getLength());
                }
            }
            clipper.setData(data);
        }
    }

    private Pair<Integer, Integer> strandAwarePositions(SAMRecord read, int start, int stop) {
        if (read.getReadNegativeStrandFlag()) {
            return new Pair<Integer, Integer>(read.getReadLength() - stop - 1, read.getReadLength() - start - 1);
        }
        return new Pair<Integer, Integer>(start, stop);
    }

    private void clipCycles(ReadClipperWithData clipper) {
        if (this.cyclesToClip != null) {
            SAMRecord read = clipper.getRead();
            ClippingData data = clipper.getData();
            for (Pair<Integer, Integer> p : this.cyclesToClip) {
                int cycleStart = (Integer)p.first;
                int cycleStop = (Integer)p.second;
                if (cycleStart >= read.getReadLength()) continue;
                if (cycleStop >= read.getReadLength()) {
                    cycleStop = read.getReadLength() - 1;
                }
                Pair<Integer, Integer> startStop = this.strandAwarePositions(read, cycleStart, cycleStop);
                int start = (Integer)startStop.first;
                int stop = (Integer)startStop.second;
                ClippingOp op = new ClippingOp(start, stop);
                clipper.addOp(op);
                data.incNRangeClippedBases(op.getLength());
            }
            clipper.setData(data);
        }
    }

    private void clipBadQualityScores(ReadClipperWithData clipper) {
        SAMRecord read = clipper.getRead();
        ClippingData data = clipper.getData();
        int readLen = read.getReadBases().length;
        byte[] quals = read.getBaseQualities();
        int clipSum = 0;
        int lastMax = -1;
        int clipPoint = -1;
        for (int i = readLen - 1; i >= 0; --i) {
            int baseIndex = read.getReadNegativeStrandFlag() ? readLen - i - 1 : i;
            byte qual = quals[baseIndex];
            if ((clipSum += this.qTrimmingThreshold - qual) < 0 || clipSum < lastMax) continue;
            lastMax = clipSum;
            clipPoint = baseIndex;
        }
        if (clipPoint != -1) {
            int start = read.getReadNegativeStrandFlag() ? 0 : clipPoint;
            int stop = read.getReadNegativeStrandFlag() ? clipPoint : readLen - 1;
            ClippingOp op = new ClippingOp(start, stop);
            clipper.addOp(op);
            data.incNQClippedBases(op.getLength());
        }
        clipper.setData(data);
    }

    @Override
    public ClippingData reduceInit() {
        return new ClippingData(this.sequencesToClip);
    }

    @Override
    public ClippingData reduce(ReadClipperWithData clipper, ClippingData data) {
        if (clipper == null) {
            return data;
        }
        SAMRecord clippedRead = clipper.clipRead(this.clippingRepresentation);
        if (this.outputBam != null) {
            this.outputBam.addAlignment(clippedRead);
        } else {
            this.out.println(clippedRead.format());
        }
        ++data.nTotalReads;
        data.nTotalBases += (long)clipper.getRead().getReadLength();
        if (clipper.wasClipped()) {
            ++data.nClippedReads;
            data.addData(clipper.getData());
        }
        return data;
    }

    @Override
    public void onTraversalDone(ClippingData data) {
        this.out.printf(data.toString(), new Object[0]);
    }

    public class ReadClipperWithData
    extends ReadClipper {
        private ClippingData data;

        public ReadClipperWithData(SAMRecord read, List<SeqToClip> clipSeqs) {
            super(read);
            this.data = new ClippingData(clipSeqs);
        }

        public ClippingData getData() {
            return this.data;
        }

        public void setData(ClippingData data) {
            this.data = data;
        }

        public void addData(ClippingData data) {
            this.data.addData(data);
        }
    }

    public static class ClippingData {
        public long nTotalReads = 0L;
        public long nTotalBases = 0L;
        public long nClippedReads = 0L;
        public long nClippedBases = 0L;
        public long nQClippedBases = 0L;
        public long nRangeClippedBases = 0L;
        public long nSeqClippedBases = 0L;
        HashMap<String, Long> seqClipCounts = new HashMap();

        public ClippingData(List<SeqToClip> clipSeqs) {
            for (SeqToClip clipSeq : clipSeqs) {
                this.seqClipCounts.put(clipSeq.seq, 0L);
            }
        }

        public void incNQClippedBases(int n) {
            this.nQClippedBases += (long)n;
            this.nClippedBases += (long)n;
        }

        public void incNRangeClippedBases(int n) {
            this.nRangeClippedBases += (long)n;
            this.nClippedBases += (long)n;
        }

        public void incSeqClippedBases(String seq, int n) {
            this.nSeqClippedBases += (long)n;
            this.nClippedBases += (long)n;
            this.seqClipCounts.put(seq, this.seqClipCounts.get(seq) + (long)n);
        }

        public void addData(ClippingData data) {
            this.nTotalReads += data.nTotalReads;
            this.nTotalBases += data.nTotalBases;
            this.nClippedReads += data.nClippedReads;
            this.nClippedBases += data.nClippedBases;
            this.nQClippedBases += data.nQClippedBases;
            this.nRangeClippedBases += data.nRangeClippedBases;
            this.nSeqClippedBases += data.nSeqClippedBases;
            for (String seqClip : data.seqClipCounts.keySet()) {
                Long count = data.seqClipCounts.get(seqClip);
                if (this.seqClipCounts.containsKey(seqClip)) {
                    count = count + this.seqClipCounts.get(seqClip);
                }
                this.seqClipCounts.put(seqClip, count);
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(Utils.dupString('-', 80) + "\n");
            s.append(String.format("Number of examined reads              %d%n", this.nTotalReads));
            s.append(String.format("Number of clipped reads               %d%n", this.nClippedReads));
            s.append(String.format("Percent of clipped reads              %.2f%n", 100.0 * (double)this.nClippedReads / (double)this.nTotalReads));
            s.append(String.format("Number of examined bases              %d%n", this.nTotalBases));
            s.append(String.format("Number of clipped bases               %d%n", this.nClippedBases));
            s.append(String.format("Percent of clipped bases              %.2f%n", 100.0 * (double)this.nClippedBases / (double)this.nTotalBases));
            s.append(String.format("Number of quality-score clipped bases %d%n", this.nQClippedBases));
            s.append(String.format("Number of range clipped bases         %d%n", this.nRangeClippedBases));
            s.append(String.format("Number of sequence clipped bases      %d%n", this.nSeqClippedBases));
            for (Map.Entry<String, Long> elt : this.seqClipCounts.entrySet()) {
                s.append(String.format("  %8d clip sites matching %s%n", elt.getValue(), elt.getKey()));
            }
            s.append(Utils.dupString('-', 80) + "\n");
            return s.toString();
        }
    }

    private static class SeqToClip {
        String name;
        String seq;
        String revSeq;
        Pattern fwdPat;
        Pattern revPat;

        public SeqToClip(String name, String seq) {
            this.name = name;
            this.seq = seq;
            this.fwdPat = Pattern.compile(seq, 2);
            this.revSeq = BaseUtils.simpleReverseComplement(seq);
            this.revPat = Pattern.compile(this.revSeq, 2);
        }
    }
}

