/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.phonehome;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.GATKArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.Mimetypes;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;

public class GATKRunReport {
    private static File REPORT_DIR = new File("/humgen/gsa-hpprojects/GATK/reports");
    private static final String REPORT_BUCKET_NAME = "GATK_Run_Reports";
    private static File REPORT_SUBMIT_DIR = new File(REPORT_DIR.getAbsolutePath() + "/submitted");
    private static File REPORT_SENTINEL = new File(REPORT_DIR.getAbsolutePath() + "/ENABLE");
    protected static Logger logger = Logger.getLogger(GATKRunReport.class);
    @ElementList(required=true, name="gatk_header_Information")
    private List<String> mGATKHeader;
    @Element(required=false, name="id")
    private final String id;
    @Element(required=false, name="exception")
    private final ExceptionToXML mException;
    @Element(required=false, name="argument_collection")
    private final GATKArgumentCollection mCollection;
    @Element(required=true, name="working_directory")
    private String currentPath;
    @Element(required=true, name="start_time")
    private String startTime = "ND";
    @Element(required=true, name="end_time")
    private String endTime;
    @Element(required=true, name="run_time")
    private long runTime = 0L;
    @Element(required=true, name="command_line")
    private String cmdLine = "COULD NOT BE DETERMINED";
    @Element(required=true, name="walker_name")
    private String walkerName;
    @Element(required=true, name="svn_version")
    private String svnVersion;
    @Element(required=true, name="total_memory")
    private long totalMemory;
    @Element(required=true, name="max_memory")
    private long maxMemory;
    @Element(required=true, name="java_tmp_directory")
    private String tmpDir;
    @Element(required=true, name="user_name")
    private String userName;
    @Element(required=true, name="host_name")
    private String hostName;
    @Element(required=true, name="java")
    private String java;
    @Element(required=true, name="machine")
    private String machine;
    @Element(required=true, name="iterations")
    private long nIterations;
    @Element(required=true, name="reads")
    private long nReads;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH.mm.ss");

    public GATKRunReport(Walker<?, ?> walker, Exception e, GenomeAnalysisEngine engine, PhoneHomeOption type) {
        if (type == PhoneHomeOption.NO_ET) {
            throw new ReviewedStingException("Trying to create a run report when type is NO_ET!");
        }
        logger.debug("Aggregating data for run report");
        this.mGATKHeader = CommandLineGATK.createApplicationHeader();
        this.currentPath = System.getProperty("user.dir");
        this.id = RandomStringUtils.randomAlphanumeric(32);
        try {
            this.cmdLine = engine.createApproximateCommandLineArgumentString(engine, walker);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.mCollection = engine.getArguments();
        this.walkerName = engine.getWalkerName(walker.getClass());
        this.svnVersion = CommandLineGATK.getVersionNumber();
        Date end = new Date();
        this.endTime = dateFormat.format(end);
        if (engine.getStartTime() != null) {
            this.startTime = dateFormat.format(engine.getStartTime());
            this.runTime = (end.getTime() - engine.getStartTime().getTime()) / 1000L;
        }
        this.tmpDir = System.getProperty("java.io.tmpdir");
        Runtime.getRuntime().gc();
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        if (engine.getCumulativeMetrics() != null) {
            this.nIterations = engine.getCumulativeMetrics().getNumIterations();
            this.nReads = engine.getCumulativeMetrics().getNumReadsSeen();
        }
        this.userName = System.getProperty("user.name");
        this.hostName = "unknown";
        this.java = Utils.join("-", Arrays.asList(System.getProperty("java.vendor"), System.getProperty("java.version")));
        this.machine = Utils.join("-", Arrays.asList(System.getProperty("os.name"), System.getProperty("os.arch")));
        this.mException = e == null ? null : new ExceptionToXML(e);
    }

    public String getID() {
        return this.id;
    }

    public void postReport(PhoneHomeOption type) {
        logger.debug("Posting report of type " + (Object)((Object)type));
        switch (type) {
            case NO_ET: {
                break;
            }
            case STANDARD: {
                if (this.repositoryIsOnline()) {
                    this.postReportToLocalDisk(REPORT_SUBMIT_DIR);
                    break;
                }
                this.postReportToAWSS3();
                break;
            }
            case STDOUT: {
                this.postReportToStream(System.out);
                break;
            }
            case AWS_S3: {
                this.postReportToAWSS3();
                break;
            }
            default: {
                this.exceptDuringRunReport("BUG: unexcepted PhoneHomeOption ");
            }
        }
    }

    private void postReportToStream(OutputStream stream) {
        Persister serializer = new Persister(new Format(new HyphenStyle()));
        try {
            serializer.write((Object)this, stream);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data to the file " + stream, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postReportToFile(File destination) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(destination)));
        try {
            this.postReportToStream(out);
        }
        finally {
            out.close();
        }
    }

    private File postReportToLocalDisk(File rootDir) {
        try {
            String filename = this.getID() + ".report.xml.gz";
            File file = new File(rootDir, filename);
            this.postReportToFile(file);
            logger.debug("Wrote report to " + file);
            return file;
        }
        catch (Exception e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postReportToAWSS3() {
        this.hostName = Utils.resolveHostname();
        File localFile = this.postReportToLocalDisk(new File("./"));
        logger.debug("Generating GATK report to AWS S3 based on local file " + localFile);
        if (localFile != null) {
            try {
                Logger mimeTypeLogger = Logger.getLogger(Mimetypes.class);
                mimeTypeLogger.setLevel(Level.FATAL);
                String awsAccessKey = "AKIAJXU7VIHBPDW4TDSQ";
                String awsSecretKey = "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";
                AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
                RestS3Service s3Service = new RestS3Service(awsCredentials);
                S3Object fileObject = new S3Object(localFile);
                S3Object s3Object = s3Service.putObject(REPORT_BUCKET_NAME, fileObject);
                logger.debug("Uploaded to AWS: " + s3Object);
            }
            catch (S3ServiceException e) {
                this.exceptDuringRunReport("S3 exception occurred", e);
            }
            catch (NoSuchAlgorithmException e) {
                this.exceptDuringRunReport("Couldn't calculate MD5", e);
            }
            catch (IOException e) {
                this.exceptDuringRunReport("Couldn't read report file", e);
            }
            finally {
                localFile.delete();
            }
        }
    }

    private void exceptDuringRunReport(String msg, Throwable e) {
        logger.debug("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is: " + msg + ".  Error message is: " + e.getMessage());
    }

    private void exceptDuringRunReport(String msg) {
        logger.debug("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is " + msg);
    }

    private boolean repositoryIsOnline() {
        return REPORT_SENTINEL.exists();
    }

    private class ExceptionToXML {
        @Element(required=false, name="message")
        String message = null;
        @ElementList(required=false, name="stacktrace")
        final List<String> stackTrace = new ArrayList<String>();
        @Element(required=false, name="cause")
        ExceptionToXML cause = null;
        @Element(required=false, name="is-user-exception")
        Boolean isUserException;

        public ExceptionToXML(Throwable e) {
            this.message = e.getMessage();
            this.isUserException = e instanceof UserException;
            for (StackTraceElement element : e.getStackTrace()) {
                this.stackTrace.add(element.toString());
            }
            if (e.getCause() != null) {
                this.cause = new ExceptionToXML(e.getCause());
            }
        }
    }

    public static enum PhoneHomeOption {
        NO_ET,
        STANDARD,
        STDOUT,
        AWS_S3;

    }
}

