/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadFormattingIterator
implements StingSAMIterator {
    protected static final Logger logger = Logger.getLogger(ReadFormattingIterator.class);
    private StingSAMIterator wrappedIterator;
    private final boolean useOriginalBaseQualities;
    private final byte defaultBaseQualities;

    public ReadFormattingIterator(StingSAMIterator wrappedIterator, boolean useOriginalBaseQualities, byte defaultBaseQualities) {
        this.wrappedIterator = wrappedIterator;
        this.useOriginalBaseQualities = useOriginalBaseQualities;
        this.defaultBaseQualities = defaultBaseQualities;
    }

    public StingSAMIterator iterator() {
        return this;
    }

    @Override
    public void close() {
        this.wrappedIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.wrappedIterator.hasNext();
    }

    @Override
    public SAMRecord next() {
        return new GATKSAMRecord((SAMRecord)this.wrappedIterator.next(), this.useOriginalBaseQualities, this.defaultBaseQualities);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a ReadWrappingIterator");
    }
}

