/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BufferingReadIterator
implements CloseableIterator<SAMRecord> {
    private final CloseableIterator<SAMRecord> wrappedIterator;
    private final Queue<SAMRecord> buffer;
    private final int bufferSize;

    public BufferingReadIterator(CloseableIterator<SAMRecord> readIterator, int bufferSize) {
        this.wrappedIterator = readIterator;
        this.buffer = new LinkedList<SAMRecord>();
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean hasNext() {
        this.assureBufferFull();
        return !this.buffer.isEmpty();
    }

    @Override
    public SAMRecord next() {
        this.assureBufferFull();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element available");
        }
        return this.buffer.remove();
    }

    @Override
    public void close() {
        this.wrappedIterator.close();
    }

    @Override
    public void remove() {
        throw new ReviewedStingException("Unable to remove from a BufferingReadIterator");
    }

    private void assureBufferFull() {
        if (!this.buffer.isEmpty()) {
            return;
        }
        while (this.buffer.size() < this.bufferSize && this.wrappedIterator.hasNext()) {
            this.buffer.add((SAMRecord)this.wrappedIterator.next());
        }
    }
}

