/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class MalformedReadFilter
extends ReadFilter {
    private SAMFileHeader header;

    @Override
    public void initialize(GenomeAnalysisEngine engine) {
        this.header = engine.getSAMFileHeader();
    }

    @Override
    public boolean filterOut(SAMRecord read) {
        return !MalformedReadFilter.checkInvalidAlignmentStart(read) || !MalformedReadFilter.checkInvalidAlignmentEnd(read) || !MalformedReadFilter.checkAlignmentDisagreesWithHeader(this.header, read) || !MalformedReadFilter.checkCigarDisagreesWithAlignment(read);
    }

    private static boolean checkInvalidAlignmentStart(SAMRecord read) {
        if (!read.getReadUnmappedFlag() && read.getAlignmentStart() == 0) {
            return false;
        }
        return read.getReadUnmappedFlag() || read.getAlignmentStart() != -1;
    }

    private static boolean checkInvalidAlignmentEnd(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getAlignmentEnd() == -1 || read.getAlignmentEnd() - read.getAlignmentStart() + 1 >= 0;
    }

    private static boolean checkAlignmentDisagreesWithHeader(SAMFileHeader header, SAMRecord read) {
        if (read.getReferenceIndex() == -1 && read.getAlignmentStart() != 0) {
            return false;
        }
        SAMSequenceRecord contigHeader = header.getSequence(read.getReferenceIndex());
        return read.getReadUnmappedFlag() || read.getAlignmentStart() <= contigHeader.getSequenceLength();
    }

    private static boolean checkCigarDisagreesWithAlignment(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getAlignmentStart() == -1 || read.getAlignmentStart() == 0 || read.getAlignmentBlocks().size() >= 0;
    }
}

