/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.util.PeekableIterator;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.sample.SampleDataSource;
import org.broadinstitute.sting.gatk.iterators.LocusIterator;
import org.broadinstitute.sting.gatk.iterators.LocusIteratorByState;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class WindowMaker
implements Iterable<WindowMakerIterator>,
Iterator<WindowMakerIterator> {
    private final ReadProperties sourceInfo;
    private final StingSAMIterator readIterator;
    private final Iterator<AlignmentContext> sourceIterator;
    private final PeekableIterator<GenomeLoc> intervalIterator;
    private boolean shardGenerated = false;
    private AlignmentContext currentAlignmentContext;

    public WindowMaker(Shard shard, GenomeLocParser genomeLocParser, StingSAMIterator iterator, List<GenomeLoc> intervals, SampleDataSource sampleData) {
        this.sourceInfo = shard.getReadProperties();
        this.readIterator = iterator;
        this.sourceIterator = new LocusIteratorByState(iterator, this.sourceInfo, genomeLocParser, sampleData);
        this.intervalIterator = intervals.size() > 0 ? new PeekableIterator<GenomeLoc>(intervals.iterator()) : null;
    }

    @Override
    public Iterator<WindowMakerIterator> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.intervalIterator != null && this.intervalIterator.hasNext() || !this.shardGenerated;
    }

    @Override
    public WindowMakerIterator next() {
        this.shardGenerated = true;
        return new WindowMakerIterator(this.intervalIterator != null ? this.intervalIterator.next() : null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a window maker.");
    }

    public void close() {
        this.readIterator.close();
    }

    public class WindowMakerIterator
    extends LocusIterator {
        private final GenomeLoc locus;
        private boolean atNextElement = false;

        public WindowMakerIterator(GenomeLoc locus) {
            this.locus = locus;
            this.advance();
        }

        public ReadProperties getSourceInfo() {
            return WindowMaker.this.sourceInfo;
        }

        public GenomeLoc getLocus() {
            return this.locus;
        }

        public WindowMakerIterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.advance();
            return this.atNextElement;
        }

        @Override
        public AlignmentContext next() {
            this.advance();
            if (!this.atNextElement) {
                throw new NoSuchElementException("WindowMakerIterator is out of elements for this interval.");
            }
            AlignmentContext toReturn = WindowMaker.this.currentAlignmentContext;
            WindowMaker.this.currentAlignmentContext = null;
            this.atNextElement = false;
            return toReturn;
        }

        private void advance() {
            if (this.locus == null) {
                if (!this.atNextElement && WindowMaker.this.sourceIterator.hasNext()) {
                    WindowMaker.this.currentAlignmentContext = (AlignmentContext)WindowMaker.this.sourceIterator.next();
                    this.atNextElement = true;
                }
                return;
            }
            if (WindowMaker.this.currentAlignmentContext == null && !WindowMaker.this.sourceIterator.hasNext()) {
                return;
            }
            while (WindowMaker.this.sourceIterator.hasNext()) {
                if (WindowMaker.this.currentAlignmentContext == null) {
                    WindowMaker.this.currentAlignmentContext = (AlignmentContext)WindowMaker.this.sourceIterator.next();
                }
                if (this.locus.containsP(WindowMaker.this.currentAlignmentContext.getLocation())) {
                    this.atNextElement = true;
                    break;
                }
                if (this.locus.isBefore(WindowMaker.this.currentAlignmentContext.getLocation()) || !WindowMaker.this.sourceIterator.hasNext()) break;
                WindowMaker.this.currentAlignmentContext = (AlignmentContext)WindowMaker.this.sourceIterator.next();
            }
        }
    }
}

