/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.rmd;

import java.io.File;
import java.lang.reflect.Type;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.rmd.DataStreamSegment;
import org.broadinstitute.sting.gatk.datasources.rmd.EntireStream;
import org.broadinstitute.sting.gatk.datasources.rmd.MappedStreamSegment;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataPool;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedQueryDataPool;
import org.broadinstitute.sting.gatk.datasources.rmd.ResourcePool;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class ReferenceOrderedDataSource {
    private final RMDTriplet fileDescriptor;
    private final Object header;
    private final SAMSequenceDictionary sequenceDictionary;
    private final RMDTrackBuilder builder;
    private final ResourcePool<?, LocationAwareSeekableRODIterator> iteratorPool;

    public ReferenceOrderedDataSource(RMDTriplet fileDescriptor, RMDTrackBuilder builder, SAMSequenceDictionary referenceSequenceDictionary, GenomeLocParser genomeLocParser, boolean flashbackData) {
        this.fileDescriptor = fileDescriptor;
        this.builder = builder;
        if (fileDescriptor.getStorageType() != RMDTriplet.RMDStorageType.STREAM) {
            this.iteratorPool = new ReferenceOrderedQueryDataPool(fileDescriptor, builder, referenceSequenceDictionary, genomeLocParser);
            this.header = ((ReferenceOrderedQueryDataPool)this.iteratorPool).getHeader();
            this.sequenceDictionary = ((ReferenceOrderedQueryDataPool)this.iteratorPool).getSequenceDictionary();
        } else {
            this.iteratorPool = new ReferenceOrderedDataPool(fileDescriptor, builder, referenceSequenceDictionary, genomeLocParser, flashbackData);
            this.header = ((ReferenceOrderedDataPool)this.iteratorPool).getHeader();
            this.sequenceDictionary = ((ReferenceOrderedDataPool)this.iteratorPool).getSequenceDictionary();
        }
    }

    public String getName() {
        return this.fileDescriptor.getName();
    }

    public Class getType() {
        return this.builder.getFeatureManager().getByTriplet(this.fileDescriptor).getCodecClass();
    }

    public Class getRecordType() {
        return this.builder.getFeatureManager().getByTriplet(this.fileDescriptor).getFeatureClass();
    }

    public File getFile() {
        return new File(this.fileDescriptor.getFile());
    }

    public Object getHeader() {
        return this.header;
    }

    public Tags getTags() {
        return this.fileDescriptor.getTags();
    }

    public String getTagValue(String key) {
        return this.fileDescriptor.getTags().getValue(key);
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    public boolean matchesNameAndRecordType(String name, Type type) {
        return name.equals(this.fileDescriptor.getName()) && type.getClass().isAssignableFrom(this.getType().getClass());
    }

    public LocationAwareSeekableRODIterator seek(Shard shard) {
        DataStreamSegment dataStreamSegment = shard.getGenomeLocs().size() != 0 ? new MappedStreamSegment(shard.getGenomeLocs().get(0)) : new EntireStream();
        return this.iteratorPool.iterator(dataStreamSegment);
    }

    public LocationAwareSeekableRODIterator seek(GenomeLoc loc) {
        DataStreamSegment dataStreamSegment = loc != null ? new MappedStreamSegment(loc) : new EntireStream();
        return this.iteratorPool.iterator(dataStreamSegment);
    }

    public void close(LocationAwareSeekableRODIterator iterator) {
        this.iteratorPool.release(iterator);
    }
}

