/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.MonolithicShard;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.filters.CountingFilteringIterator;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.iterators.BufferingReadIterator;
import org.broadinstitute.sting.gatk.iterators.DownsampleIterator;
import org.broadinstitute.sting.gatk.iterators.ReadFormattingIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIteratorAdapter;
import org.broadinstitute.sting.gatk.iterators.VerifyingSamIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.baq.BAQSamIterator;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class SAMDataSource {
    protected final ReadProperties readProperties;
    private final ReadMetrics readMetrics;
    private final GenomeLocParser genomeLocParser;
    private final Collection<SAMReaderID> readerIDs;
    private final SAMFileReader.ValidationStringency validationStringency;
    private final Map<SAMReaderID, GATKBAMIndex> bamIndices = new HashMap<SAMReaderID, GATKBAMIndex>();
    private final Map<SAMReaderID, SAMFileSpan> readerPositions = new HashMap<SAMReaderID, SAMFileSpan>();
    private final SAMFileHeader mergedHeader;
    private SAMFileHeader.SortOrder sortOrder = null;
    private final boolean hasReadGroupCollisions;
    private final ReadGroupMapping mergedToOriginalReadGroupMappings = new ReadGroupMapping();
    private final Map<SAMReaderID, ReadGroupMapping> originalToMergedReadGroupMappings = new HashMap<SAMReaderID, ReadGroupMapping>();
    private static Logger logger = Logger.getLogger(SAMDataSource.class);
    private final SAMResourcePool resourcePool;
    private boolean enableLowMemorySharding = false;

    public SAMDataSource(Collection<SAMReaderID> samFiles, GenomeLocParser genomeLocParser) {
        this(samFiles, genomeLocParser, false, SAMFileReader.ValidationStringency.STRICT, null, null, new ValidationExclusion(), new ArrayList<ReadFilter>(), false, false, true);
    }

    public SAMDataSource(Collection<SAMReaderID> samFiles, GenomeLocParser genomeLocParser, boolean useOriginalBaseQualities, SAMFileReader.ValidationStringency strictness, Integer readBufferSize, DownsamplingMethod downsamplingMethod, ValidationExclusion exclusionList, Collection<ReadFilter> supplementalFilters, boolean includeReadsWithDeletionAtLoci, boolean generateExtendedEvents, boolean enableLowMemorySharding) {
        this(samFiles, genomeLocParser, useOriginalBaseQualities, strictness, readBufferSize, downsamplingMethod, exclusionList, supplementalFilters, includeReadsWithDeletionAtLoci, generateExtendedEvents, BAQ.CalculationMode.OFF, BAQ.QualityMode.DONT_MODIFY, null, -1, enableLowMemorySharding);
    }

    public SAMDataSource(Collection<SAMReaderID> samFiles, GenomeLocParser genomeLocParser, boolean useOriginalBaseQualities, SAMFileReader.ValidationStringency strictness, Integer readBufferSize, DownsamplingMethod downsamplingMethod, ValidationExclusion exclusionList, Collection<ReadFilter> supplementalFilters, boolean includeReadsWithDeletionAtLoci, boolean generateExtendedEvents, BAQ.CalculationMode cmode, BAQ.QualityMode qmode, IndexedFastaSequenceFile refReader, byte defaultBaseQualities, boolean enableLowMemorySharding) {
        this.enableLowMemorySharding(enableLowMemorySharding);
        this.readMetrics = new ReadMetrics();
        this.genomeLocParser = genomeLocParser;
        this.readerIDs = samFiles;
        this.validationStringency = strictness;
        for (SAMReaderID readerID : samFiles) {
            if (readerID.samFile.canRead()) continue;
            throw new UserException.CouldNotReadInputFile(readerID.samFile, "file is not present or user does not have appropriate permissions.  Please check that the file is present and readable and try again.");
        }
        this.resourcePool = new SAMResourcePool(Integer.MAX_VALUE);
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        for (SAMFileReader reader : readers.values()) {
            SAMFileHeader.SortOrder sortOrder;
            SAMFileHeader header = reader.getFileHeader();
            SAMFileHeader.SortOrder sortOrder2 = sortOrder = header.getSortOrder() != SAMFileHeader.SortOrder.unsorted ? header.getSortOrder() : SAMFileHeader.SortOrder.coordinate;
            if (this.sortOrder != null && this.sortOrder != sortOrder) {
                throw new UserException.MissortedBAM(String.format("Attempted to process mixed of files sorted as %s and %s.", new Object[]{this.sortOrder, sortOrder}));
            }
            this.sortOrder = sortOrder;
        }
        this.initializeReaderPositions(readers);
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, readers.headers(), true);
        this.mergedHeader = headerMerger.getMergedHeader();
        this.hasReadGroupCollisions = headerMerger.hasReadGroupCollisions();
        this.readProperties = new ReadProperties(samFiles, this.mergedHeader, useOriginalBaseQualities, strictness, readBufferSize, downsamplingMethod, exclusionList, supplementalFilters, includeReadsWithDeletionAtLoci, generateExtendedEvents, cmode, qmode, refReader, defaultBaseQualities);
        for (SAMReaderID id : this.readerIDs) {
            SAMFileReader reader = readers.getReader(id);
            ReadGroupMapping mappingToMerged = new ReadGroupMapping();
            List<SAMReadGroupRecord> readGroups = reader.getFileHeader().getReadGroups();
            for (SAMReadGroupRecord readGroup : readGroups) {
                if (headerMerger.hasReadGroupCollisions()) {
                    mappingToMerged.put(readGroup.getReadGroupId(), headerMerger.getReadGroupId(reader, readGroup.getReadGroupId()));
                    this.mergedToOriginalReadGroupMappings.put(headerMerger.getReadGroupId(reader, readGroup.getReadGroupId()), readGroup.getReadGroupId());
                    continue;
                }
                mappingToMerged.put(readGroup.getReadGroupId(), readGroup.getReadGroupId());
                this.mergedToOriginalReadGroupMappings.put(readGroup.getReadGroupId(), readGroup.getReadGroupId());
            }
            this.originalToMergedReadGroupMappings.put(id, mappingToMerged);
        }
        if (enableLowMemorySharding) {
            for (SAMReaderID id : this.readerIDs) {
                File indexFile = this.findIndexFile(id.samFile);
                if (indexFile == null) continue;
                this.bamIndices.put(id, new GATKBAMIndex(indexFile));
            }
        }
        this.resourcePool.releaseReaders(readers);
    }

    public ReadProperties getReadsInfo() {
        return this.readProperties;
    }

    public void enableLowMemorySharding(boolean enable) {
        this.enableLowMemorySharding = enable;
    }

    public boolean isLowMemoryShardingEnabled() {
        return this.enableLowMemorySharding;
    }

    public boolean isEmpty() {
        return this.readProperties.getSAMReaderIDs().size() == 0;
    }

    public File getSAMFile(SAMReaderID id) {
        return id.samFile;
    }

    public Collection<SAMReaderID> getReaderIDs() {
        return this.readerIDs;
    }

    public SAMReaderID getReaderID(SAMRecord read) {
        return this.resourcePool.getReaderID(read.getFileSource().getReader());
    }

    public Map<SAMReaderID, SAMFileSpan> getCurrentPosition() {
        return this.readerPositions;
    }

    public SAMFileHeader getHeader() {
        return this.mergedHeader;
    }

    public SAMFileHeader getHeader(SAMReaderID id) {
        return this.resourcePool.getReadersWithoutLocking().getReader(id).getFileHeader();
    }

    public String getReadGroupId(SAMReaderID reader, String originalReadGroupId) {
        return (String)this.originalToMergedReadGroupMappings.get(reader).get(originalReadGroupId);
    }

    public String getOriginalReadGroupId(String mergedReadGroupId) {
        return (String)this.mergedToOriginalReadGroupMappings.get(mergedReadGroupId);
    }

    public boolean hasReadGroupCollisions() {
        return this.hasReadGroupCollisions;
    }

    public boolean hasIndex() {
        if (this.enableLowMemorySharding) {
            return this.readerIDs.size() == this.bamIndices.size();
        }
        for (SAMFileReader reader : this.resourcePool.getReadersWithoutLocking()) {
            if (reader.hasIndex()) continue;
            return false;
        }
        return true;
    }

    public Object getIndex(SAMReaderID id) {
        if (this.enableLowMemorySharding) {
            return this.bamIndices.get(id);
        }
        SAMReaders readers = this.resourcePool.getReadersWithoutLocking();
        return readers.getReader(id).getBrowseableIndex();
    }

    public SAMFileHeader.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMetrics getCumulativeReadMetrics() {
        ReadMetrics readMetrics = this.readMetrics;
        synchronized (readMetrics) {
            return this.readMetrics.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incorporateReadMetrics(ReadMetrics readMetrics) {
        ReadMetrics readMetrics2 = this.readMetrics;
        synchronized (readMetrics2) {
            this.readMetrics.incrementMetrics(readMetrics);
        }
    }

    public void fillShard(Shard shard) {
        if (!shard.buffersReads()) {
            throw new ReviewedStingException("Attempting to fill a non-buffering shard.");
        }
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        SAMRecord read = null;
        StingSAMIterator iterator = this.getIterator(readers, shard, this.sortOrder == SAMFileHeader.SortOrder.coordinate);
        while (!shard.isBufferFull() && iterator.hasNext()) {
            read = (SAMRecord)iterator.next();
            this.addReadToBufferingShard(shard, this.getReaderID(readers, read), read);
        }
        if (this.sortOrder == SAMFileHeader.SortOrder.queryname) {
            while (iterator.hasNext()) {
                SAMRecord nextRead = (SAMRecord)iterator.next();
                if (read == null || !read.getReadName().equals(nextRead.getReadName())) break;
                this.addReadToBufferingShard(shard, this.getReaderID(readers, nextRead), nextRead);
            }
        }
        iterator.close();
    }

    public StingSAMIterator seek(Shard shard) {
        if (shard instanceof MonolithicShard) {
            return this.seekMonolithic(shard);
        }
        if (shard.buffersReads()) {
            return shard.iterator();
        }
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        return this.getIterator(readers, shard, shard instanceof ReadShard);
    }

    private SAMReaderID getReaderID(SAMReaders readers, SAMRecord read) {
        for (SAMReaderID id : this.getReaderIDs()) {
            if (readers.getReader(id) != read.getFileSource().getReader()) continue;
            return id;
        }
        throw new ReviewedStingException("Unable to find id for reader associated with read " + read.getReadName());
    }

    private void initializeReaderPositions(SAMReaders readers) {
        for (SAMReaderID id : this.getReaderIDs()) {
            this.readerPositions.put(id, readers.getReader(id).getFilePointerSpanningReads());
        }
    }

    private StingSAMIterator getIterator(SAMReaders readers, Shard shard, boolean enableVerification) {
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, readers.headers(), true);
        MergingSamRecordIterator mergingIterator = new MergingSamRecordIterator(headerMerger, readers.values(), true);
        for (SAMReaderID id : this.getReaderIDs()) {
            CloseableIterator<SAMRecord> iterator = null;
            if (!shard.isUnmapped() && shard.getFileSpans().get(id) == null) continue;
            SAMRecordIterator sAMRecordIterator = iterator = shard.getFileSpans().get(id) != null ? readers.getReader(id).iterator(shard.getFileSpans().get(id)) : readers.getReader(id).queryUnmapped();
            if (this.readProperties.getReadBufferSize() != null) {
                iterator = new BufferingReadIterator(iterator, this.readProperties.getReadBufferSize());
            }
            if (shard.getGenomeLocs() != null) {
                iterator = new IntervalOverlapFilteringIterator(iterator, shard.getGenomeLocs());
            }
            mergingIterator.addIterator(readers.getReader(id), iterator);
        }
        return this.applyDecoratingIterators(shard.getReadMetrics(), enableVerification, this.readProperties.useOriginalBaseQualities(), new ReleasingIterator(readers, StingSAMIteratorAdapter.adapt(mergingIterator)), this.readProperties.getDownsamplingMethod().toFraction, this.readProperties.getValidationExclusionList().contains(ValidationExclusion.TYPE.NO_READ_ORDER_VERIFICATION), this.readProperties.getSupplementalFilters(), this.readProperties.getBAQCalculationMode(), this.readProperties.getBAQQualityMode(), this.readProperties.getRefReader(), this.readProperties.defaultBaseQualities());
    }

    private StingSAMIterator seekMonolithic(Shard shard) {
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, readers.headers(), true);
        MergingSamRecordIterator mergingIterator = new MergingSamRecordIterator(headerMerger, readers.values(), true);
        for (SAMReaderID id : this.getReaderIDs()) {
            mergingIterator.addIterator(readers.getReader(id), readers.getReader(id).iterator());
        }
        return this.applyDecoratingIterators(shard.getReadMetrics(), shard instanceof ReadShard, this.readProperties.useOriginalBaseQualities(), new ReleasingIterator(readers, StingSAMIteratorAdapter.adapt(mergingIterator)), this.readProperties.getDownsamplingMethod().toFraction, this.readProperties.getValidationExclusionList().contains(ValidationExclusion.TYPE.NO_READ_ORDER_VERIFICATION), this.readProperties.getSupplementalFilters(), this.readProperties.getBAQCalculationMode(), this.readProperties.getBAQQualityMode(), this.readProperties.getRefReader(), this.readProperties.defaultBaseQualities());
    }

    private void addReadToBufferingShard(Shard shard, SAMReaderID id, SAMRecord read) {
        SAMFileSpan endChunk = read.getFileSource().getFilePointer().getContentsFollowing();
        shard.addRead(read);
        this.readerPositions.put(id, endChunk);
    }

    protected StingSAMIterator applyDecoratingIterators(ReadMetrics readMetrics, boolean enableVerification, boolean useOriginalBaseQualities, StingSAMIterator wrappedIterator, Double downsamplingFraction, Boolean noValidationOfReadOrder, Collection<ReadFilter> supplementalFilters, BAQ.CalculationMode cmode, BAQ.QualityMode qmode, IndexedFastaSequenceFile refReader, byte defaultBaseQualities) {
        wrappedIterator = new ReadFormattingIterator(wrappedIterator, useOriginalBaseQualities, defaultBaseQualities);
        if (downsamplingFraction != null) {
            wrappedIterator = new DownsampleIterator(wrappedIterator, downsamplingFraction);
        }
        if (!noValidationOfReadOrder.booleanValue() && enableVerification) {
            wrappedIterator = new VerifyingSamIterator(this.genomeLocParser, wrappedIterator);
        }
        if (cmode != BAQ.CalculationMode.OFF) {
            wrappedIterator = new BAQSamIterator(refReader, wrappedIterator, cmode, qmode);
        }
        wrappedIterator = StingSAMIteratorAdapter.adapt(new CountingFilteringIterator(readMetrics, wrappedIterator, supplementalFilters));
        return wrappedIterator;
    }

    private File findIndexFile(File bamFile) {
        File indexFile;
        try {
            Class<?> bamFileReaderClass = Class.forName("net.sf.samtools.BAMFileReader");
            Method indexFileLocator = bamFileReaderClass.getDeclaredMethod("findIndexFile", File.class);
            indexFileLocator.setAccessible(true);
            indexFile = (File)indexFileLocator.invoke(null, bamFile);
        }
        catch (ClassNotFoundException ex) {
            throw new ReviewedStingException("Unable to locate BAMFileReader class, used to check for index files");
        }
        catch (NoSuchMethodException ex) {
            throw new ReviewedStingException("Unable to locate Picard index file locator.");
        }
        catch (IllegalAccessException ex) {
            throw new ReviewedStingException("Unable to access Picard index file locator.");
        }
        catch (InvocationTargetException ex) {
            throw new ReviewedStingException("Unable to invoke Picard index file locator.");
        }
        return indexFile;
    }

    private class IntervalOverlapFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private CloseableIterator<SAMRecord> iterator;
        private SAMRecord nextRead;
        private boolean keepOnlyUnmappedReads;
        private int[] intervalContigIndices;
        private int[] intervalStarts;
        private int[] intervalEnds;
        private int currentBound = 0;

        public IntervalOverlapFilteringIterator(CloseableIterator<SAMRecord> iterator, List<GenomeLoc> intervals) {
            this.iterator = iterator;
            boolean foundMappedIntervals = false;
            for (GenomeLoc location : intervals) {
                if (!GenomeLoc.isUnmapped(location)) {
                    foundMappedIntervals = true;
                }
                this.keepOnlyUnmappedReads |= GenomeLoc.isUnmapped(location);
            }
            if (foundMappedIntervals) {
                if (this.keepOnlyUnmappedReads) {
                    throw new ReviewedStingException("Tried to apply IntervalOverlapFilteringIterator to a mixed of mapped and unmapped intervals.  Please apply this filter to only mapped or only unmapped reads");
                }
                this.intervalContigIndices = new int[intervals.size()];
                this.intervalStarts = new int[intervals.size()];
                this.intervalEnds = new int[intervals.size()];
                int i = 0;
                for (GenomeLoc interval : intervals) {
                    this.intervalContigIndices[i] = interval.getContigIndex();
                    this.intervalStarts[i] = interval.getStart();
                    this.intervalEnds[i] = interval.getStop();
                    ++i;
                }
            }
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextRead != null;
        }

        @Override
        public SAMRecord next() {
            if (this.nextRead == null) {
                throw new NoSuchElementException("No more reads left in this iterator.");
            }
            SAMRecord currentRead = this.nextRead;
            this.advance();
            return currentRead;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from an IntervalOverlapFilteringIterator");
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        private void advance() {
            this.nextRead = null;
            if (!this.iterator.hasNext()) {
                return;
            }
            SAMRecord candidateRead = (SAMRecord)this.iterator.next();
            while (this.nextRead == null && (this.keepOnlyUnmappedReads || this.currentBound < this.intervalStarts.length)) {
                if (!this.keepOnlyUnmappedReads) {
                    if (this.readEndsOnOrAfterStartingBound(candidateRead)) {
                        if (this.readStartsOnOrBeforeEndingBound(candidateRead)) {
                            this.nextRead = candidateRead;
                            break;
                        }
                        ++this.currentBound;
                        continue;
                    }
                } else if (candidateRead.getReadUnmappedFlag()) {
                    this.nextRead = candidateRead;
                    break;
                }
                if (!this.iterator.hasNext()) break;
                candidateRead = (SAMRecord)this.iterator.next();
            }
        }

        private boolean readEndsOnOrAfterStartingBound(SAMRecord read) {
            return read.getReferenceIndex() > this.intervalContigIndices[this.currentBound] || read.getReferenceIndex() == this.intervalContigIndices[this.currentBound] && (read.getAlignmentEnd() >= this.intervalStarts[this.currentBound] || read.getReadUnmappedFlag() && read.getAlignmentStart() >= this.intervalStarts[this.currentBound]);
        }

        private boolean readStartsOnOrBeforeEndingBound(SAMRecord read) {
            return read.getReferenceIndex() < this.intervalContigIndices[this.currentBound] || read.getReferenceIndex() == this.intervalContigIndices[this.currentBound] && read.getAlignmentStart() <= this.intervalEnds[this.currentBound];
        }
    }

    private class ReadGroupMapping
    extends HashMap<String, String> {
        private ReadGroupMapping() {
        }
    }

    private class ReleasingIterator
    implements StingSAMIterator {
        private final SAMReaders resource;
        private final StingSAMIterator wrappedIterator;

        public ReleasingIterator(SAMReaders resource, StingSAMIterator wrapped) {
            this.resource = resource;
            this.wrappedIterator = wrapped;
        }

        public ReleasingIterator iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove from a StingSAMIterator");
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
            SAMDataSource.this.resourcePool.releaseReaders(this.resource);
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            return (SAMRecord)this.wrappedIterator.next();
        }
    }

    private class SAMReaders
    implements Iterable<SAMFileReader> {
        private final Map<SAMReaderID, SAMFileReader> readers = new LinkedHashMap<SAMReaderID, SAMFileReader>();

        public SAMReaders(Collection<SAMReaderID> readerIDs, SAMFileReader.ValidationStringency validationStringency) {
            for (SAMReaderID readerID : readerIDs) {
                SAMFileReader reader = new SAMFileReader(readerID.samFile);
                reader.enableFileSource(true);
                reader.enableIndexMemoryMapping(false);
                if (!SAMDataSource.this.enableLowMemorySharding) {
                    reader.enableIndexCaching(true);
                }
                reader.setValidationStringency(validationStringency);
                SAMFileHeader header = reader.getFileHeader();
                logger.debug(String.format("Sort order is: " + (Object)((Object)header.getSortOrder()), new Object[0]));
                this.readers.put(readerID, reader);
            }
        }

        public SAMFileReader getReader(SAMReaderID id) {
            if (!this.readers.containsKey(id)) {
                throw new NoSuchElementException("No reader is associated with id " + id);
            }
            return this.readers.get(id);
        }

        protected SAMReaderID getReaderID(SAMFileReader reader) {
            for (Map.Entry<SAMReaderID, SAMFileReader> entry : this.readers.entrySet()) {
                if (reader != entry.getValue()) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<SAMFileReader> iterator() {
            return this.readers.values().iterator();
        }

        public boolean isEmpty() {
            return this.readers.isEmpty();
        }

        public Collection<SAMFileReader> values() {
            return this.readers.values();
        }

        public Collection<SAMFileHeader> headers() {
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.readers.size());
            for (SAMFileReader reader : this.values()) {
                headers.add(reader.getFileHeader());
            }
            return headers;
        }
    }

    private class SAMResourcePool {
        private final int maxEntries;
        private List<SAMReaders> allResources = new ArrayList<SAMReaders>();
        private List<SAMReaders> availableResources = new ArrayList<SAMReaders>();

        public SAMResourcePool(int maxEntries) {
            this.maxEntries = maxEntries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SAMReaders getReadersWithoutLocking() {
            SAMResourcePool sAMResourcePool = this;
            synchronized (sAMResourcePool) {
                if (this.allResources.size() == 0) {
                    this.createNewResource();
                }
            }
            return this.allResources.get(0);
        }

        public synchronized SAMReaders getAvailableReaders() {
            if (this.availableResources.size() == 0) {
                this.createNewResource();
            }
            SAMReaders readers = this.availableResources.get(0);
            this.availableResources.remove(readers);
            return readers;
        }

        public synchronized void releaseReaders(SAMReaders readers) {
            if (!this.allResources.contains(readers)) {
                throw new ReviewedStingException("Tried to return readers from the pool that didn't originate in the pool.");
            }
            this.availableResources.add(readers);
        }

        protected synchronized SAMReaderID getReaderID(SAMFileReader reader) {
            for (SAMReaders readers : this.allResources) {
                SAMReaderID id = readers.getReaderID(reader);
                if (id == null) continue;
                return id;
            }
            throw new ReviewedStingException("No such reader id is available");
        }

        private synchronized void createNewResource() {
            if (this.allResources.size() > this.maxEntries) {
                throw new ReviewedStingException("Cannot create a new resource pool.  All resources are in use.");
            }
            SAMReaders readers = new SAMReaders(SAMDataSource.this.readerIDs, SAMDataSource.this.validationStringency);
            this.allResources.add(readers);
            this.availableResources.add(readers);
        }
    }
}

