/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.sting.gatk.datasources.reads.MonolithicShard;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategy;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class MonolithicShardStrategy
implements ShardStrategy {
    private MonolithicShard shard;

    public MonolithicShardStrategy(GenomeLocParser parser, SAMDataSource readsDataSource, Shard.ShardType shardType, List<GenomeLoc> region) {
        this.shard = new MonolithicShard(parser, readsDataSource, shardType, region);
    }

    @Override
    public Iterator<Shard> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.shard != null;
    }

    @Override
    public Shard next() {
        if (this.shard == null) {
            throw new NoSuchElementException("Monolithic shard has already been retrived.");
        }
        MonolithicShard working = this.shard;
        this.shard = null;
        return working;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a shard strategy");
    }

    public void adjustNextShardSize(long size) {
        throw new UnsupportedOperationException("Cannot adjust the next size of a monolithic shard; there will be no next shard.");
    }
}

