/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.IntervalSharder;
import org.broadinstitute.sting.gatk.datasources.reads.LocusShard;
import org.broadinstitute.sting.gatk.datasources.reads.LowMemoryIntervalSharder;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategy;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class LocusShardStrategy
implements ShardStrategy {
    private final SAMDataSource reads;
    private GenomeLocParser genomeLocParser;
    private final Iterator<FilePointer> filePointerIterator;
    public long shardNumber = 0L;

    public LocusShardStrategy(SAMDataSource reads, IndexedFastaSequenceFile reference, GenomeLocParser genomeLocParser, GenomeLocSortedSet locations) {
        this.reads = reads;
        this.genomeLocParser = genomeLocParser;
        if (!reads.isEmpty()) {
            GenomeLocSortedSet intervals;
            if (locations == null) {
                SAMFileHeader header = reads.getHeader();
                intervals = new GenomeLocSortedSet(genomeLocParser);
                for (SAMSequenceRecord readsSequenceRecord : header.getSequenceDictionary().getSequences()) {
                    SAMSequenceRecord refSequenceRecord = reference.getSequenceDictionary().getSequence(readsSequenceRecord.getSequenceName());
                    if (refSequenceRecord == null) continue;
                    int length = Math.min(readsSequenceRecord.getSequenceLength(), refSequenceRecord.getSequenceLength());
                    intervals.add(genomeLocParser.createGenomeLoc(readsSequenceRecord.getSequenceName(), 1, length));
                }
            } else {
                intervals = locations;
            }
            this.filePointerIterator = reads.isLowMemoryShardingEnabled() ? new LowMemoryIntervalSharder(this.reads, intervals) : IntervalSharder.shardIntervals(this.reads, intervals);
        } else {
            int maxShardSize = 100000;
            ArrayList<FilePointer> filePointers = new ArrayList<FilePointer>();
            if (locations == null) {
                for (SAMSequenceRecord refSequenceRecord : reference.getSequenceDictionary().getSequences()) {
                    for (int shardStart = 1; shardStart <= refSequenceRecord.getSequenceLength(); shardStart += 100000) {
                        int shardStop = Math.min(shardStart + 100000 - 1, refSequenceRecord.getSequenceLength());
                        filePointers.add(new FilePointer(genomeLocParser.createGenomeLoc(refSequenceRecord.getSequenceName(), shardStart, shardStop)));
                    }
                }
            } else {
                for (GenomeLoc interval : locations) {
                    while (interval.size() > 100000L) {
                        filePointers.add(new FilePointer(locations.getGenomeLocParser().createGenomeLoc(interval.getContig(), interval.getStart(), interval.getStart() + 100000 - 1)));
                        interval = locations.getGenomeLocParser().createGenomeLoc(interval.getContig(), interval.getStart() + 100000, interval.getStop());
                    }
                    filePointers.add(new FilePointer(interval));
                }
            }
            this.filePointerIterator = filePointers.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.filePointerIterator.hasNext();
    }

    @Override
    public LocusShard next() {
        FilePointer nextFilePointer = this.filePointerIterator.next();
        SortedMap<SAMReaderID, SAMFileSpan> fileSpansBounding = nextFilePointer.fileSpans != null ? nextFilePointer.fileSpans : null;
        return new LocusShard(this.genomeLocParser, this.reads, nextFilePointer.locations, fileSpansBounding);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ShardStrategies don't support remove()");
    }

    @Override
    public Iterator<Shard> iterator() {
        return this;
    }
}

