/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.Bin;
import net.sf.samtools.BrowseableBAMIndex;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.datasources.reads.BAMOverlap;
import org.broadinstitute.sting.gatk.datasources.reads.BinQueueState;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.ReaderBin;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class IntervalSharder {
    private static Logger logger = Logger.getLogger(IntervalSharder.class);

    public static Iterator<FilePointer> shardIntervals(SAMDataSource dataSource, GenomeLocSortedSet loci) {
        return new FilePointerIterator(dataSource, loci);
    }

    private static List<FilePointer> shardIntervalsOnContig(SAMDataSource dataSource, String contig, GenomeLocSortedSet loci) {
        if (contig == null) {
            FilePointer filePointer = new FilePointer(GenomeLoc.UNMAPPED);
            for (SAMReaderID id : dataSource.getReaderIDs()) {
                filePointer.addFileSpans(id, null);
            }
            return Collections.singletonList(filePointer);
        }
        ArrayList<FilePointer> filePointers = new ArrayList<FilePointer>();
        FilePointer lastFilePointer = null;
        BAMOverlap lastBAMOverlap = null;
        HashMap<SAMReaderID, BrowseableBAMIndex> readerToIndexMap = new HashMap<SAMReaderID, BrowseableBAMIndex>();
        BinMergingIterator binMerger = new BinMergingIterator();
        for (SAMReaderID id : dataSource.getReaderIDs()) {
            SAMSequenceRecord referenceSequence = dataSource.getHeader(id).getSequence(contig);
            if (referenceSequence == null && contig != null) continue;
            BrowseableBAMIndex index = (BrowseableBAMIndex)dataSource.getIndex(id);
            binMerger.addReader(id, index, referenceSequence.getSequenceIndex(), index.getBinsOverlapping(referenceSequence.getSequenceIndex(), 1, referenceSequence.getSequenceLength()).iterator());
            readerToIndexMap.put(id, index);
        }
        PeekableIterator<BAMOverlap> binIterator = new PeekableIterator<BAMOverlap>(binMerger);
        for (GenomeLoc location : loci) {
            if (!location.getContig().equals(contig)) {
                throw new ReviewedStingException("Location outside bounds of contig");
            }
            if (!binIterator.hasNext()) break;
            int locationStart = location.getStart();
            int locationStop = location.getStop();
            while (binIterator.peek().stop < locationStart) {
                binIterator.next();
            }
            ArrayList<BAMOverlap> bamOverlaps = new ArrayList<BAMOverlap>();
            while (binIterator.hasNext() && binIterator.peek().stop <= locationStop) {
                bamOverlaps.add(binIterator.next());
            }
            if (binIterator.hasNext() && binIterator.peek().start <= locationStop) {
                bamOverlaps.add(binIterator.peek());
            }
            Iterator bamOverlapIterator = bamOverlaps.iterator();
            while (locationStop >= locationStart) {
                int regionStop;
                int binStop;
                int binStart = lastFilePointer != null ? lastFilePointer.overlap.start : 0;
                int n = binStop = lastFilePointer != null ? lastFilePointer.overlap.stop : 0;
                while (binStop < locationStart && bamOverlapIterator.hasNext()) {
                    if (lastFilePointer != null && lastFilePointer.locations.size() > 0) {
                        filePointers.add(lastFilePointer);
                    }
                    lastBAMOverlap = (BAMOverlap)bamOverlapIterator.next();
                    lastFilePointer = new FilePointer(lastBAMOverlap);
                    binStart = lastFilePointer.overlap.start;
                    binStop = lastFilePointer.overlap.stop;
                }
                if (locationStart < binStart) {
                    if (lastFilePointer != null && lastFilePointer.locations.size() > 0) {
                        filePointers.add(lastFilePointer);
                        lastFilePointer = null;
                        lastBAMOverlap = null;
                    }
                    regionStop = Math.min(locationStop, binStart - 1);
                    GenomeLoc subset = loci.getGenomeLocParser().createGenomeLoc(location.getContig(), locationStart, regionStop);
                    lastFilePointer = new FilePointer(subset);
                    locationStart = regionStop + 1;
                    continue;
                }
                if (locationStart > binStop) {
                    if (lastFilePointer != null && lastFilePointer.locations.size() > 0) {
                        filePointers.add(lastFilePointer);
                        lastFilePointer = null;
                        lastBAMOverlap = null;
                    }
                    GenomeLoc subset = loci.getGenomeLocParser().createGenomeLoc(location.getContig(), locationStart, locationStop);
                    filePointers.add(new FilePointer(subset));
                    locationStart = locationStop + 1;
                    continue;
                }
                if (lastFilePointer == null) {
                    throw new ReviewedStingException("Illegal state: initializer failed to create cached file pointer.");
                }
                regionStop = Math.min(locationStop, binStop);
                lastFilePointer.addLocation(loci.getGenomeLocParser().createGenomeLoc(location.getContig(), locationStart, regionStop));
                locationStart = regionStop + 1;
            }
        }
        if (lastFilePointer != null && lastFilePointer.locations.size() > 0) {
            filePointers.add(lastFilePointer);
        }
        for (SAMReaderID id : readerToIndexMap.keySet()) {
            BrowseableBAMIndex index = (BrowseableBAMIndex)readerToIndexMap.get(id);
            for (FilePointer filePointer : filePointers) {
                filePointer.addFileSpans(id, index.getSpanOverlapping(filePointer.overlap.getBin(id)));
            }
        }
        return filePointers;
    }

    private static class LowestLevelBinFilteringIterator
    implements Iterator<Bin> {
        private BrowseableBAMIndex index;
        private Iterator<Bin> wrappedIterator;
        private Bin nextBin;

        public LowestLevelBinFilteringIterator(BrowseableBAMIndex index, Iterator<Bin> iterator) {
            this.index = index;
            this.wrappedIterator = iterator;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextBin != null;
        }

        @Override
        public Bin next() {
            Bin bin = this.nextBin;
            this.advance();
            return bin;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }

        private void advance() {
            this.nextBin = null;
            while (this.wrappedIterator.hasNext() && this.nextBin == null) {
                Bin bin = this.wrappedIterator.next();
                if (this.index.getLevelForBin(bin) != AbstractBAMFileIndex.getNumIndexLevels() - 1) continue;
                this.nextBin = bin;
            }
        }
    }

    private static class BinMergingIterator
    implements Iterator<BAMOverlap> {
        private PriorityQueue<BinQueueState> binQueue = new PriorityQueue();
        private Queue<BAMOverlap> pendingOverlaps = new LinkedList<BAMOverlap>();

        private BinMergingIterator() {
        }

        public void addReader(SAMReaderID id, BrowseableBAMIndex index, int referenceSequence, Iterator<Bin> bins) {
            this.binQueue.add(new BinQueueState(id, index, referenceSequence, new LowestLevelBinFilteringIterator(index, bins)));
        }

        @Override
        public boolean hasNext() {
            return this.pendingOverlaps.size() > 0 || !this.binQueue.isEmpty();
        }

        @Override
        public BAMOverlap next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No elements left in merging iterator");
            }
            if (this.pendingOverlaps.isEmpty()) {
                this.advance();
            }
            return this.pendingOverlaps.remove();
        }

        public void advance() {
            ArrayList<ReaderBin> bins = new ArrayList<ReaderBin>();
            if (this.binQueue.isEmpty()) {
                return;
            }
            bins.add(this.getNextBin());
            int boundsStart = ((ReaderBin)bins.get(0)).getStart();
            int boundsStop = ((ReaderBin)bins.get(0)).getStop();
            while (!this.binQueue.isEmpty() && this.peekNextBin().getStart() <= boundsStop) {
                ReaderBin bin = this.getNextBin();
                bins.add(bin);
                boundsStart = Math.min(boundsStart, bin.getStart());
                boundsStop = Math.max(boundsStop, bin.getStop());
            }
            ArrayList<Pair<Integer, Integer>> range = new ArrayList<Pair<Integer, Integer>>();
            int start = ((ReaderBin)bins.get(0)).getStart();
            int stop = ((ReaderBin)bins.get(0)).getStop();
            block1: while (start <= boundsStop) {
                ReaderBin readerBin;
                for (ReaderBin readerBin2 : bins) {
                    stop = Math.min(stop, readerBin2.getStop());
                    if (start >= readerBin2.getStart()) continue;
                    stop = Math.min(stop, readerBin2.getStart() - 1);
                }
                range.add(new Pair<Integer, Integer>(start, stop));
                if (stop >= boundsStop) break;
                start = stop + 1;
                Iterator i$ = bins.iterator();
                while (i$.hasNext() && (start < (readerBin = (ReaderBin)i$.next()).getStart() || start > readerBin.getStop())) {
                    if (start >= readerBin.getStart()) continue;
                    start = readerBin.getStart();
                    continue block1;
                }
            }
            for (Pair pair : range) {
                BAMOverlap bamOverlap = new BAMOverlap((Integer)pair.first, (Integer)pair.second);
                for (ReaderBin bin : bins) {
                    bamOverlap.addBin(bin.id, bin.bin);
                }
                this.pendingOverlaps.add(bamOverlap);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a merging iterator.");
        }

        private ReaderBin peekNextBin() {
            if (this.binQueue.isEmpty()) {
                throw new NoSuchElementException("No more bins are available");
            }
            BinQueueState current = this.binQueue.peek();
            return new ReaderBin(current.getReaderID(), current.getIndex(), current.getReferenceSequence(), current.peekNextBin());
        }

        private ReaderBin getNextBin() {
            if (this.binQueue.isEmpty()) {
                throw new NoSuchElementException("No more bins are available");
            }
            BinQueueState current = (BinQueueState)this.binQueue.remove();
            ReaderBin readerBin = new ReaderBin(current.getReaderID(), current.getIndex(), current.getReferenceSequence(), current.nextBin());
            if (current.hasNextBin()) {
                this.binQueue.add(current);
            }
            return readerBin;
        }
    }

    private static class FilePointerIterator
    implements Iterator<FilePointer> {
        final SAMDataSource dataSource;
        final GenomeLocSortedSet loci;
        final PeekableIterator<GenomeLoc> locusIterator;
        final Queue<FilePointer> cachedFilePointers = new LinkedList<FilePointer>();

        public FilePointerIterator(SAMDataSource dataSource, GenomeLocSortedSet loci) {
            this.dataSource = dataSource;
            this.loci = loci;
            this.locusIterator = new PeekableIterator<GenomeLoc>(loci.iterator());
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return !this.cachedFilePointers.isEmpty();
        }

        @Override
        public FilePointer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("FilePointerIterator iteration is complete");
            }
            FilePointer filePointer = this.cachedFilePointers.remove();
            if (this.cachedFilePointers.isEmpty()) {
                this.advance();
            }
            return filePointer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a FilePointerIterator");
        }

        private void advance() {
            GenomeLocSortedSet nextBatch = new GenomeLocSortedSet(this.loci.getGenomeLocParser());
            String contig = null;
            while (this.locusIterator.hasNext() && nextBatch.isEmpty()) {
                contig = null;
                while (this.locusIterator.hasNext() && (contig == null || !GenomeLoc.isUnmapped(this.locusIterator.peek()) && this.locusIterator.peek().getContig().equals(contig))) {
                    GenomeLoc nextLocus = this.locusIterator.next();
                    contig = nextLocus.getContig();
                    nextBatch.add(nextLocus);
                }
            }
            if (nextBatch.size() > 0) {
                this.cachedFilePointers.addAll(IntervalSharder.shardIntervalsOnContig(this.dataSource, contig, nextBatch));
            }
        }
    }
}

