/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.Iterator;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.Bin;
import net.sf.samtools.BrowseableBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class BinQueueState
implements Comparable<BinQueueState> {
    private final SAMReaderID id;
    private final BrowseableBAMIndex index;
    private final int referenceSequence;
    private final PeekableIterator<Bin> bins;
    private int firstLocusInCurrentBin;
    private int lastLocusInCurrentBin;

    public BinQueueState(SAMReaderID id, BrowseableBAMIndex index, int referenceSequence, Iterator<Bin> bins) {
        this.id = id;
        this.index = index;
        this.referenceSequence = referenceSequence;
        this.bins = new PeekableIterator<Bin>(bins);
        this.refreshLocusInBinCache();
    }

    public SAMReaderID getReaderID() {
        return this.id;
    }

    public BrowseableBAMIndex getIndex() {
        return this.index;
    }

    public int getReferenceSequence() {
        return this.referenceSequence;
    }

    public boolean hasNextBin() {
        return this.bins.hasNext();
    }

    public Bin peekNextBin() {
        return this.bins.peek();
    }

    public Bin nextBin() {
        Bin nextBin = this.bins.next();
        this.refreshLocusInBinCache();
        return nextBin;
    }

    @Override
    public int compareTo(BinQueueState other) {
        if (!this.bins.hasNext() && !other.bins.hasNext()) {
            return 0;
        }
        if (!this.bins.hasNext()) {
            return -1;
        }
        if (!this.bins.hasNext()) {
            return 1;
        }
        if (this.firstLocusInCurrentBin <= 0 || this.lastLocusInCurrentBin <= 0 || other.firstLocusInCurrentBin <= 0 || other.lastLocusInCurrentBin <= 0) {
            throw new ReviewedStingException("Sharding mechanism error - bin->locus cache is invalid.");
        }
        if (this.firstLocusInCurrentBin != other.firstLocusInCurrentBin) {
            return this.firstLocusInCurrentBin - other.firstLocusInCurrentBin;
        }
        return this.lastLocusInCurrentBin - other.lastLocusInCurrentBin;
    }

    private void refreshLocusInBinCache() {
        this.firstLocusInCurrentBin = -1;
        this.lastLocusInCurrentBin = -1;
        if (this.bins.hasNext()) {
            Bin bin = this.bins.peek();
            this.firstLocusInCurrentBin = this.index.getFirstLocusInBin(bin);
            this.lastLocusInCurrentBin = this.index.getLastLocusInBin(bin);
        }
    }
}

