/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import org.broadinstitute.sting.gatk.datasources.reads.BAMSchedule;
import org.broadinstitute.sting.gatk.datasources.reads.BAMScheduleEntry;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class BAMScheduler
implements Iterator<FilePointer> {
    private final SAMDataSource dataSource;
    private final Map<SAMReaderID, GATKBAMIndex> indexFiles = new HashMap<SAMReaderID, GATKBAMIndex>();
    private FilePointer nextFilePointer = null;
    private final GenomeLocSortedSet loci;
    private final PeekableIterator<GenomeLoc> locusIterator;
    private GenomeLoc currentLocus;
    private Integer lastReferenceSequenceLoaded = null;
    private PeekableIterator<BAMScheduleEntry> bamScheduleIterator = null;

    public BAMScheduler(SAMDataSource dataSource, GenomeLocSortedSet loci) {
        this.dataSource = dataSource;
        for (SAMReaderID reader : dataSource.getReaderIDs()) {
            this.indexFiles.put(reader, (GATKBAMIndex)dataSource.getIndex(reader));
        }
        this.loci = loci;
        this.locusIterator = new PeekableIterator<GenomeLoc>(loci.iterator());
        if (this.locusIterator.hasNext()) {
            this.currentLocus = this.locusIterator.next();
        }
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextFilePointer != null;
    }

    @Override
    public FilePointer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element available in interval sharder");
        }
        FilePointer currentFilePointer = this.nextFilePointer;
        this.advance();
        return currentFilePointer;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unable to remove FilePointers from an IntervalSharder");
    }

    private void advance() {
        if (this.loci.isEmpty()) {
            return;
        }
        this.nextFilePointer = null;
        while (this.nextFilePointer == null && this.currentLocus != null) {
            if (this.currentLocus == GenomeLoc.UNMAPPED) {
                this.nextFilePointer = new FilePointer(GenomeLoc.UNMAPPED);
                for (SAMReaderID id : this.dataSource.getReaderIDs()) {
                    this.nextFilePointer.addFileSpans(id, new GATKBAMFileSpan(new GATKChunk(this.indexFiles.get(id).getStartOfLastLinearBin(), Long.MAX_VALUE)));
                }
                this.currentLocus = null;
                continue;
            }
            this.nextFilePointer = new FilePointer();
            int coveredRegionStart = 1;
            int coveredRegionStop = Integer.MAX_VALUE;
            GenomeLoc coveredRegion = null;
            BAMScheduleEntry scheduleEntry = this.getNextOverlappingBAMScheduleEntry(this.indexFiles, this.currentLocus);
            if (scheduleEntry != null) {
                coveredRegionStart = Math.max(coveredRegionStart, scheduleEntry.start);
                coveredRegionStop = Math.min(coveredRegionStop, scheduleEntry.stop);
                coveredRegion = this.loci.getGenomeLocParser().createGenomeLoc(this.currentLocus.getContig(), coveredRegionStart, coveredRegionStop);
                this.nextFilePointer.addFileSpans(scheduleEntry.fileSpans);
            } else {
                for (SAMReaderID reader : this.indexFiles.keySet()) {
                    this.nextFilePointer.addFileSpans(reader, new GATKBAMFileSpan());
                }
            }
            if (coveredRegion == null) {
                if (this.currentLocus.size() > 16384L) {
                    GenomeLoc[] splitContigs = this.currentLocus.split(this.currentLocus.getStart() + 16384);
                    this.nextFilePointer.addLocation(splitContigs[0]);
                    this.currentLocus = splitContigs[1];
                    continue;
                }
                this.nextFilePointer.addLocation(this.currentLocus);
                this.currentLocus = this.locusIterator.hasNext() ? this.locusIterator.next() : null;
                continue;
            }
            if (this.currentLocus.startsBefore(coveredRegion)) {
                int splitPoint = Math.min(coveredRegion.getStart() - this.currentLocus.getStart(), 16384) + this.currentLocus.getStart();
                GenomeLoc[] splitContigs = this.currentLocus.split(splitPoint);
                this.nextFilePointer.addLocation(splitContigs[0]);
                this.currentLocus = splitContigs[1];
                continue;
            }
            GenomeLoc initialLocation = this.currentLocus.intersect(coveredRegion);
            this.nextFilePointer.addLocation(initialLocation);
            if (this.nextFilePointer.locations.isEmpty()) continue;
            while (this.locusIterator.hasNext() && this.locusIterator.peek().overlapsP(coveredRegion)) {
                this.currentLocus = this.locusIterator.next();
                this.nextFilePointer.addLocation(this.currentLocus.intersect(coveredRegion));
            }
            if (coveredRegionStop < this.currentLocus.getStop()) {
                this.currentLocus = this.loci.getGenomeLocParser().createGenomeLoc(this.currentLocus.getContig(), coveredRegionStop + 1, this.currentLocus.getStop());
                continue;
            }
            if (this.locusIterator.hasNext()) {
                this.currentLocus = this.locusIterator.next();
                continue;
            }
            this.currentLocus = null;
        }
    }

    private BAMScheduleEntry getNextOverlappingBAMScheduleEntry(Map<SAMReaderID, GATKBAMIndex> indices, GenomeLoc currentLocus) {
        if (this.lastReferenceSequenceLoaded == null || this.lastReferenceSequenceLoaded.intValue() != currentLocus.getContigIndex()) {
            if (this.bamScheduleIterator != null) {
                this.bamScheduleIterator.close();
            }
            this.lastReferenceSequenceLoaded = currentLocus.getContigIndex();
            LinkedList<GenomeLoc> lociInContig = new LinkedList<GenomeLoc>();
            for (GenomeLoc locus : this.loci) {
                if (locus.getContigIndex() != this.lastReferenceSequenceLoaded.intValue()) continue;
                lociInContig.add(locus);
            }
            this.bamScheduleIterator = new PeekableIterator<BAMScheduleEntry>(new BAMSchedule(indices, lociInContig));
        }
        if (!this.bamScheduleIterator.hasNext()) {
            return null;
        }
        BAMScheduleEntry bamScheduleEntry = this.bamScheduleIterator.peek();
        while (bamScheduleEntry != null && bamScheduleEntry.isBefore(currentLocus)) {
            this.bamScheduleIterator.next();
            bamScheduleEntry = this.bamScheduleIterator.hasNext() ? this.bamScheduleIterator.peek() : null;
        }
        return bamScheduleEntry != null && bamScheduleEntry.overlaps(currentLocus) ? bamScheduleEntry : null;
    }
}

