/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.ZipDir;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = Lists.newArrayList(DefaultUrlTypes.values());

    public static List<UrlType> getDefaultUrlTypes() {
        return defaultUrlTypes;
    }

    public static void setDefaultURLTypes(List<UrlType> urlTypes) {
        defaultUrlTypes = urlTypes;
    }

    public static void addDefaultURLTypes(UrlType urlType) {
        defaultUrlTypes.add(urlType);
    }

    public static Dir fromURL(URL url) {
        return Vfs.fromURL(url, defaultUrlTypes);
    }

    public static Dir fromURL(URL url, List<UrlType> urlTypes) {
        for (UrlType type : urlTypes) {
            if (!type.matches(url)) continue;
            try {
                return type.createDir(url);
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create Dir using " + type.getClass().getName() + " from url " + url.toExternalForm());
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + url.toExternalForm() + "]\n" + "either use fromURL(final URL url, final List<UrlType> urlTypes) or " + "use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) " + "with your specialized UrlType.");
    }

    public static Dir fromURL(URL url, UrlType ... urlTypes) {
        return Vfs.fromURL(url, Lists.newArrayList(urlTypes));
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, Predicate<File> filePredicate) {
        Iterable<File> result = new ArrayList<File>();
        for (URL url : inUrls) {
            Iterable<File> iterable = Iterables.filter(Vfs.fromURL(url).getFiles(), filePredicate);
            result = Iterables.concat(result, iterable);
        }
        return result;
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, final String packagePrefix, final Predicate<String> nameFilter) {
        Predicate<File> fileNamePredicate = new Predicate<File>(){

            @Override
            public boolean apply(File file) {
                String path = file.getRelativePath();
                if (path.startsWith(packagePrefix)) {
                    String filename = path.substring(path.indexOf(packagePrefix) + packagePrefix.length());
                    return !Utils.isEmpty(filename) && nameFilter.apply(filename.substring(1));
                }
                return false;
            }
        };
        return Vfs.findFiles(inUrls, fileNamePredicate);
    }

    public static String normalizePath(URL url) {
        return Vfs.normalizePath(url.toExternalForm());
    }

    public static String normalizePath(String urlPath) {
        String[] protocols;
        String path;
        try {
            path = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        path = path.replace("\\", "/");
        while (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        if (path.contains(":") && (protocols = path.split(":")).length > 1) {
            String maybeDrive = protocols[protocols.length - 2].replace("\\", "").replace("/", "");
            String lastSegment = protocols[protocols.length - 1];
            path = maybeDrive.length() == 1 ? maybeDrive.toLowerCase() + ":" + lastSegment : lastSegment;
        }
        if (path.contains("!")) {
            path = path.substring(0, path.lastIndexOf("!"));
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultUrlTypes implements UrlType
    {
        jarfile{

            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && url.toExternalForm().endsWith(".jar");
            }

            public Dir createDir(URL url) {
                return new ZipDir(url);
            }
        }
        ,
        jarUrl{

            public boolean matches(URL url) {
                return url.toExternalForm().contains(".jar!");
            }

            public Dir createDir(URL url) {
                return new ZipDir(url);
            }
        }
        ,
        directory{

            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && new java.io.File(Vfs.normalizePath(url)).isDirectory();
            }

            public Dir createDir(URL url) {
                return new SystemDir(url);
            }
        };

    }

    public static interface UrlType {
        public boolean matches(URL var1);

        public Dir createDir(URL var1);
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public String getFullPath();

        public InputStream getInputStream() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        public void close();
    }
}

