/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class ListFileUtils {
    public static final String LIST_FILE_COMMENT_START = "#";

    public static List<SAMReaderID> unpackBAMFileList(List<String> samFiles, ParsingEngine parser) {
        ArrayList<SAMReaderID> unpackedReads = new ArrayList<SAMReaderID>();
        for (String inputFileName : samFiles) {
            Tags inputFileNameTags = parser.getTags(inputFileName);
            if ((inputFileName = ListFileUtils.expandFileName(inputFileName)).toLowerCase().endsWith(".list")) {
                try {
                    for (String fileName : new XReadLines(new File(inputFileName), true)) {
                        if (fileName.length() <= 0 || fileName.startsWith(LIST_FILE_COMMENT_START)) continue;
                        unpackedReads.add(new SAMReaderID(fileName, parser.getTags(inputFileName)));
                    }
                    continue;
                }
                catch (FileNotFoundException ex) {
                    throw new UserException.CouldNotReadInputFile(new File(inputFileName), "Unable to find file while unpacking reads", ex);
                }
            }
            if (inputFileName.toLowerCase().endsWith(".bam")) {
                unpackedReads.add(new SAMReaderID(inputFileName, inputFileNameTags));
                continue;
            }
            if (inputFileName.endsWith("stdin")) {
                unpackedReads.add(new SAMReaderID(inputFileName, inputFileNameTags));
                continue;
            }
            throw new UserException.CommandLineException(String.format("The GATK reads argument (-I) supports only BAM files with the .bam extension and lists of BAM files with the .list extension, but the file %s has neither extension.  Please ensure that your BAM file or list of BAM files is in the correct format, update the extension, and try again.", inputFileName));
        }
        return unpackedReads;
    }

    @Deprecated
    public static Collection<RMDTriplet> unpackRODBindingsOldStyle(Collection<String> RODBindings, ParsingEngine parser) {
        ArrayList<RMDTriplet> rodBindings = new ArrayList<RMDTriplet>();
        for (String fileName : RODBindings) {
            Tags tags = parser.getTags(fileName);
            fileName = ListFileUtils.expandFileName(fileName);
            List<String> positionalTags = tags.getPositionalTags();
            if (positionalTags.size() != 2) {
                throw new UserException("Invalid syntax for -B (reference-ordered data) input flag.  Please use the following syntax when providing reference-ordered data: -B:<name>,<type> <filename>.");
            }
            String name = positionalTags.get(0);
            String type = positionalTags.get(1);
            RMDTriplet.RMDStorageType storageType = null;
            storageType = tags.getValue("storage") != null ? Enum.valueOf(RMDTriplet.RMDStorageType.class, tags.getValue("storage")) : (fileName.toLowerCase().endsWith("stdin") ? RMDTriplet.RMDStorageType.STREAM : RMDTriplet.RMDStorageType.FILE);
            rodBindings.add(new RMDTriplet(name, type, fileName, storageType, tags));
        }
        return rodBindings;
    }

    public static Collection<RMDTriplet> unpackRODBindings(Collection<RodBinding> RODBindings, ParsingEngine parser) {
        ArrayList<RMDTriplet> rodBindings = new ArrayList<RMDTriplet>();
        FeatureManager builderForValidation = new FeatureManager();
        for (RodBinding rodBinding : RODBindings) {
            String argValue = rodBinding.getSource();
            String fileName = ListFileUtils.expandFileName(argValue);
            String name = rodBinding.getName();
            String type = rodBinding.getTribbleType();
            RMDTriplet.RMDStorageType storageType = null;
            storageType = rodBinding.getTags().getValue("storage") != null ? Enum.valueOf(RMDTriplet.RMDStorageType.class, rodBinding.getTags().getValue("storage")) : (fileName.toLowerCase().endsWith("stdin") ? RMDTriplet.RMDStorageType.STREAM : RMDTriplet.RMDStorageType.FILE);
            RMDTriplet triplet = new RMDTriplet(name, type, fileName, storageType, rodBinding.getTags());
            FeatureManager.FeatureDescriptor descriptor = builderForValidation.getByTriplet(triplet);
            if (descriptor == null) {
                throw new UserException.UnknownTribbleType(rodBinding.getTribbleType(), String.format("Field %s had provided type %s but there's no such Tribble type.  The compatible types are: %n%s", rodBinding.getName(), rodBinding.getTribbleType(), builderForValidation.userFriendlyListOfAvailableFeatures(rodBinding.getType())));
            }
            if (!rodBinding.getType().isAssignableFrom(descriptor.getFeatureClass())) {
                throw new UserException.BadArgumentValue(rodBinding.getName(), String.format("Field %s expects Features of type %s, but the input file produces Features of type %s. The compatible types are: %n%s", rodBinding.getName(), rodBinding.getType().getSimpleName(), descriptor.getSimpleFeatureName(), builderForValidation.userFriendlyListOfAvailableFeatures(rodBinding.getType())));
            }
            rodBindings.add(triplet);
        }
        return rodBindings;
    }

    private static String expandFileName(String argument) {
        if (argument.trim().equals("-")) {
            return "/dev/stdin";
        }
        return argument;
    }
}

