/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.SimplifyingSAMFileWriter;

public class ReadUtils {
    public static final String REDUCED_READ_QUALITY_TAG = "RQ";
    private static int DEFAULT_ADAPTOR_SIZE = 100;
    private static final Map<Integer, String> readFlagNames = new HashMap<Integer, String>();

    private ReadUtils() {
    }

    public static SAMFileHeader copySAMFileHeader(SAMFileHeader toCopy) {
        SAMFileHeader copy = new SAMFileHeader();
        copy.setSortOrder(toCopy.getSortOrder());
        copy.setGroupOrder(toCopy.getGroupOrder());
        copy.setProgramRecords(toCopy.getProgramRecords());
        copy.setReadGroups(toCopy.getReadGroups());
        copy.setSequenceDictionary(toCopy.getSequenceDictionary());
        for (Map.Entry<String, String> e : toCopy.getAttributes()) {
            copy.setAttribute(e.getKey(), e.getValue());
        }
        return copy;
    }

    public static SAMFileWriter createSAMFileWriterWithCompression(SAMFileHeader header, boolean presorted, String file, int compression) {
        if (file.endsWith(".bam")) {
            return new SAMFileWriterFactory().makeBAMWriter(header, presorted, new File(file), compression);
        }
        return new SAMFileWriterFactory().makeSAMOrBAMWriter(header, presorted, new File(file));
    }

    public static boolean isPlatformRead(SAMRecord read, String name) {
        String readPlatformAttr;
        SAMReadGroupRecord readGroup = read.getReadGroup();
        if (readGroup != null && (readPlatformAttr = readGroup.getAttribute("PL")) != null) {
            return readPlatformAttr.toString().toUpperCase().contains(name);
        }
        return false;
    }

    public static OverlapType readPairBaseOverlapType(SAMRecord rec, long basePos, int adaptorLength) {
        OverlapType state = OverlapType.NOT_OVERLAPPING;
        Pair<Integer, Integer> adaptorBoundaries = ReadUtils.getAdaptorBoundaries(rec, adaptorLength);
        if (adaptorBoundaries != null) {
            boolean inAdapator;
            boolean bl = inAdapator = basePos >= (long)((Integer)adaptorBoundaries.first).intValue() && basePos <= (long)((Integer)adaptorBoundaries.second).intValue();
            if (inAdapator) {
                state = OverlapType.IN_ADAPTOR;
            }
        }
        return state;
    }

    private static Pair<Integer, Integer> getAdaptorBoundaries(SAMRecord rec, int adaptorLength) {
        int adaptorEnd;
        int adaptorStart;
        int isize = rec.getInferredInsertSize();
        if (isize == 0) {
            return null;
        }
        if (rec.getReadNegativeStrandFlag()) {
            int mateStart = rec.getMateAlignmentStart();
            adaptorStart = mateStart - adaptorLength - 1;
            adaptorEnd = mateStart - 1;
        } else {
            int mateEnd = rec.getAlignmentStart() + isize - 1;
            adaptorStart = mateEnd + 1;
            adaptorEnd = mateEnd + adaptorLength;
        }
        return new Pair<Integer, Integer>(adaptorStart, adaptorEnd);
    }

    public static GATKSAMRecord hardClipAdaptorSequence(SAMRecord rec, int adaptorLength) {
        Pair<Integer, Integer> adaptorBoundaries = ReadUtils.getAdaptorBoundaries(rec, adaptorLength);
        GATKSAMRecord result = (GATKSAMRecord)rec;
        if (adaptorBoundaries != null) {
            if (rec.getReadNegativeStrandFlag() && (Integer)adaptorBoundaries.second >= rec.getAlignmentStart() && (Integer)adaptorBoundaries.first < rec.getAlignmentEnd()) {
                result = ReadUtils.hardClipStartOfRead(rec, (Integer)adaptorBoundaries.second);
            } else if (!rec.getReadNegativeStrandFlag() && (Integer)adaptorBoundaries.first <= rec.getAlignmentEnd()) {
                result = ReadUtils.hardClipEndOfRead(rec, (Integer)adaptorBoundaries.first);
            }
        }
        return result;
    }

    private static GATKSAMRecord hardClipStartOfRead(SAMRecord oldRec, int stopPosition) {
        GATKSAMRecord rec;
        if (stopPosition >= oldRec.getAlignmentEnd()) {
            return null;
        }
        try {
            rec = (GATKSAMRecord)oldRec.clone();
        }
        catch (Exception e) {
            return null;
        }
        Cigar oldCigar = rec.getCigar();
        LinkedList<CigarElement> newCigarElements = new LinkedList<CigarElement>();
        int currentPos = rec.getAlignmentStart();
        int basesToClip = 0;
        int basesAlreadyClipped = 0;
        block9: for (CigarElement ce : oldCigar.getCigarElements()) {
            if (currentPos > stopPosition) {
                newCigarElements.add(ce);
                continue;
            }
            int elementLength = ce.getLength();
            block1 : switch (ce.getOperator()) {
                case M: {
                    int i = 0;
                    while (i < elementLength) {
                        if (currentPos > stopPosition) {
                            newCigarElements.add(new CigarElement(elementLength - i, CigarOperator.M));
                            break block1;
                        }
                        ++i;
                        ++currentPos;
                        ++basesToClip;
                    }
                    continue block9;
                }
                case I: 
                case S: {
                    basesToClip += elementLength;
                    break;
                }
                case D: 
                case N: {
                    currentPos += elementLength;
                    break;
                }
                case H: {
                    basesAlreadyClipped += elementLength;
                }
                case P: {
                    break;
                }
                default: {
                    throw new ReviewedStingException("The " + (Object)((Object)ce.getOperator()) + " cigar element is not currently supported");
                }
            }
        }
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        int newLength = bases.length - basesToClip;
        byte[] newBases = new byte[newLength];
        byte[] newQuals = new byte[newLength];
        System.arraycopy(bases, basesToClip, newBases, 0, newLength);
        System.arraycopy(quals, basesToClip, newQuals, 0, newLength);
        rec.setReadBases(newBases);
        rec.setBaseQualities(newQuals);
        newCigarElements.addFirst(new CigarElement(basesToClip + basesAlreadyClipped, CigarOperator.H));
        Cigar newCigar = new Cigar(newCigarElements);
        rec.setCigar(newCigar);
        rec.setAlignmentStart(stopPosition + 1);
        return rec;
    }

    private static GATKSAMRecord hardClipEndOfRead(SAMRecord oldRec, int startPosition) {
        GATKSAMRecord rec;
        if (startPosition <= oldRec.getAlignmentStart()) {
            return null;
        }
        try {
            rec = (GATKSAMRecord)oldRec.clone();
        }
        catch (Exception e) {
            return null;
        }
        Cigar oldCigar = rec.getCigar();
        LinkedList<CigarElement> newCigarElements = new LinkedList<CigarElement>();
        int currentPos = rec.getAlignmentStart();
        int basesToKeep = 0;
        int basesAlreadyClipped = 0;
        block8: for (CigarElement ce : oldCigar.getCigarElements()) {
            int elementLength = ce.getLength();
            if (currentPos >= startPosition) {
                if (ce.getOperator() != CigarOperator.H) continue;
                basesAlreadyClipped += elementLength;
                continue;
            }
            switch (ce.getOperator()) {
                case M: {
                    int i = 0;
                    while (i < elementLength) {
                        if (currentPos == startPosition) {
                            newCigarElements.add(new CigarElement(i, CigarOperator.M));
                            break;
                        }
                        ++i;
                        ++currentPos;
                        ++basesToKeep;
                    }
                    if (currentPos == startPosition) continue block8;
                    newCigarElements.add(ce);
                    continue block8;
                }
                case I: 
                case S: {
                    newCigarElements.add(ce);
                    basesToKeep += elementLength;
                    continue block8;
                }
                case D: 
                case N: {
                    newCigarElements.add(ce);
                    currentPos += elementLength;
                    continue block8;
                }
                case H: 
                case P: {
                    newCigarElements.add(ce);
                    continue block8;
                }
            }
            throw new ReviewedStingException("The " + (Object)((Object)ce.getOperator()) + " cigar element is not currently supported");
        }
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        byte[] newBases = new byte[basesToKeep];
        byte[] newQuals = new byte[basesToKeep];
        System.arraycopy(bases, 0, newBases, 0, basesToKeep);
        System.arraycopy(quals, 0, newQuals, 0, basesToKeep);
        rec.setReadBases(newBases);
        rec.setBaseQualities(newQuals);
        newCigarElements.add(new CigarElement(bases.length - basesToKeep + basesAlreadyClipped, CigarOperator.H));
        Cigar newCigar = new Cigar(newCigarElements);
        rec.setCigar(newCigar);
        return rec;
    }

    @Requires(value={"rec != null"})
    @Ensures(value={"result != null"})
    public static SAMRecord hardClipSoftClippedBases(SAMRecord rec) {
        List<CigarElement> cigarElts = rec.getCigar().getCigarElements();
        if (cigarElts.size() == 1) {
            return rec;
        }
        int keepStart = 0;
        int keepEnd = rec.getReadLength() - 1;
        LinkedList<CigarElement> newCigarElements = new LinkedList<CigarElement>();
        block3: for (int i = 0; i < cigarElts.size(); ++i) {
            CigarElement ce = cigarElts.get(i);
            int l = ce.getLength();
            switch (ce.getOperator()) {
                case S: {
                    if (i == 0) {
                        keepStart = l;
                    } else {
                        keepEnd = rec.getReadLength() - l - 1;
                    }
                    newCigarElements.add(new CigarElement(l, CigarOperator.HARD_CLIP));
                    continue block3;
                }
                default: {
                    newCigarElements.add(ce);
                }
            }
        }
        LinkedList<CigarElement> mergedCigarElements = new LinkedList<CigarElement>();
        Iterator cigarElementIterator = newCigarElements.iterator();
        CigarOperator currentOperator = null;
        int currentOperatorLength = 0;
        while (cigarElementIterator.hasNext()) {
            CigarElement cigarElement = (CigarElement)cigarElementIterator.next();
            if (currentOperator != cigarElement.getOperator()) {
                if (currentOperator != null) {
                    mergedCigarElements.add(new CigarElement(currentOperatorLength, currentOperator));
                }
                currentOperator = cigarElement.getOperator();
                currentOperatorLength = cigarElement.getLength();
                continue;
            }
            currentOperatorLength += cigarElement.getLength();
        }
        mergedCigarElements.add(new CigarElement(currentOperatorLength, currentOperator));
        return ReadUtils.hardClipBases(rec, keepStart, keepEnd, mergedCigarElements);
    }

    @Requires(value={"rec != null", "keepStart >= 0", "keepEnd < rec.getReadLength()", "rec.getReadUnmappedFlag() || newCigarElements != null"})
    @Ensures(value={"result != null"})
    public static SAMRecord hardClipBases(SAMRecord rec, int keepStart, int keepEnd, List<CigarElement> newCigarElements) {
        int newLength = keepEnd - keepStart + 1;
        if (newLength != rec.getReadLength()) {
            try {
                rec = SimplifyingSAMFileWriter.simplifyRead((SAMRecord)rec.clone());
                byte[] bases = rec.getReadBases();
                byte[] quals = rec.getBaseQualities();
                byte[] newBases = new byte[newLength];
                byte[] newQuals = new byte[newLength];
                System.arraycopy(bases, keepStart, newBases, 0, newLength);
                System.arraycopy(quals, keepStart, newQuals, 0, newLength);
                rec.setReadBases(newBases);
                rec.setBaseQualities(newQuals);
                if (!rec.getReadUnmappedFlag()) {
                    Cigar newCigar = new Cigar(newCigarElements);
                    rec.setCigar(newCigar);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new ReviewedStingException("WTF, where did clone go?", e);
            }
        }
        return rec;
    }

    public static SAMRecord replaceSoftClipsWithMatches(SAMRecord read) {
        ArrayList<CigarElement> newCigarElements = new ArrayList<CigarElement>();
        for (CigarElement ce : read.getCigar().getCigarElements()) {
            if (ce.getOperator() == CigarOperator.SOFT_CLIP) {
                newCigarElements.add(new CigarElement(ce.getLength(), CigarOperator.MATCH_OR_MISMATCH));
                continue;
            }
            newCigarElements.add(ce);
        }
        if (newCigarElements.size() > 1) {
            CigarElement first = (CigarElement)newCigarElements.get(0);
            CigarElement second = (CigarElement)newCigarElements.get(1);
            if (first.getOperator() == CigarOperator.MATCH_OR_MISMATCH && second.getOperator() == CigarOperator.MATCH_OR_MISMATCH) {
                newCigarElements.set(0, new CigarElement(first.getLength() + second.getLength(), CigarOperator.MATCH_OR_MISMATCH));
                newCigarElements.remove(1);
            }
        }
        if (newCigarElements.size() > 1) {
            CigarElement penult = (CigarElement)newCigarElements.get(newCigarElements.size() - 2);
            CigarElement last = (CigarElement)newCigarElements.get(newCigarElements.size() - 1);
            if (penult.getOperator() == CigarOperator.MATCH_OR_MISMATCH && penult.getOperator() == CigarOperator.MATCH_OR_MISMATCH) {
                newCigarElements.set(newCigarElements.size() - 2, new CigarElement(penult.getLength() + last.getLength(), CigarOperator.MATCH_OR_MISMATCH));
                newCigarElements.remove(newCigarElements.size() - 1);
            }
        }
        read.setCigar(new Cigar(newCigarElements));
        return read;
    }

    public static GATKSAMRecord hardClipAdaptorSequence(SAMRecord rec) {
        return ReadUtils.hardClipAdaptorSequence(rec, DEFAULT_ADAPTOR_SIZE);
    }

    public static OverlapType readPairBaseOverlapType(SAMRecord rec, long basePos) {
        return ReadUtils.readPairBaseOverlapType(rec, basePos, DEFAULT_ADAPTOR_SIZE);
    }

    public static boolean is454Read(SAMRecord read) {
        return ReadUtils.isPlatformRead(read, "454");
    }

    public static boolean isSOLiDRead(SAMRecord read) {
        return ReadUtils.isPlatformRead(read, "SOLID");
    }

    public static boolean isSLXRead(SAMRecord read) {
        return ReadUtils.isPlatformRead(read, "ILLUMINA");
    }

    public static String readFlagsAsString(SAMRecord rec) {
        String flags = "";
        for (int flag : readFlagNames.keySet()) {
            if ((rec.getFlags() & flag) == 0) continue;
            flags = flags + readFlagNames.get(flag) + " ";
        }
        return flags;
    }

    public static final List<SAMRecord> coordinateSortReads(List<SAMRecord> reads) {
        SAMRecordCoordinateComparator comparer = new SAMRecordCoordinateComparator();
        Collections.sort(reads, comparer);
        return reads;
    }

    public static final int getFirstInsertionOffset(SAMRecord read) {
        CigarElement e = read.getCigar().getCigarElement(0);
        if (e.getOperator() == CigarOperator.I) {
            return e.getLength();
        }
        return 0;
    }

    public static final int getLastInsertionOffset(SAMRecord read) {
        CigarElement e = read.getCigar().getCigarElement(read.getCigarLength() - 1);
        if (e.getOperator() == CigarOperator.I) {
            return e.getLength();
        }
        return 0;
    }

    public static ReadAndIntervalOverlap getReadAndIntervalOverlapType(SAMRecord read, GenomeLoc interval) {
        int start = ReadUtils.getRefCoordSoftUnclippedStart(read);
        int stop = ReadUtils.getRefCoordSoftUnclippedEnd(read);
        if (!read.getReferenceName().equals(interval.getContig())) {
            return ReadAndIntervalOverlap.NO_OVERLAP_CONTIG;
        }
        if (stop < interval.getStart()) {
            return ReadAndIntervalOverlap.NO_OVERLAP_LEFT;
        }
        if (start > interval.getStop()) {
            return ReadAndIntervalOverlap.NO_OVERLAP_RIGHT;
        }
        if (start >= interval.getStart() && stop <= interval.getStop()) {
            return ReadAndIntervalOverlap.OVERLAP_CONTAINED;
        }
        if (start < interval.getStart() && stop > interval.getStop()) {
            return ReadAndIntervalOverlap.OVERLAP_LEFT_AND_RIGHT;
        }
        if (start < interval.getStart()) {
            return ReadAndIntervalOverlap.OVERLAP_LEFT;
        }
        return ReadAndIntervalOverlap.OVERLAP_RIGHT;
    }

    @Ensures(value={"result >= read.getUnclippedStart()", "result <= read.getUnclippedEnd()"})
    public static int getRefCoordSoftUnclippedStart(SAMRecord read) {
        int start = read.getUnclippedStart();
        for (CigarElement cigarElement : read.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.HARD_CLIP) break;
            start += cigarElement.getLength();
        }
        return start;
    }

    @Ensures(value={"result >= read.getUnclippedStart()", "result <= read.getUnclippedEnd()"})
    public static int getRefCoordSoftUnclippedEnd(SAMRecord read) {
        int stop = read.getUnclippedStart();
        int shift = 0;
        CigarOperator lastOperator = null;
        for (CigarElement cigarElement : read.getCigar().getCigarElements()) {
            stop += shift;
            lastOperator = cigarElement.getOperator();
            if (cigarElement.getOperator().consumesReferenceBases() || cigarElement.getOperator() == CigarOperator.SOFT_CLIP || cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                shift = cigarElement.getLength();
                continue;
            }
            shift = 0;
        }
        return lastOperator == CigarOperator.HARD_CLIP ? stop - 1 : stop + shift - 1;
    }

    @Requires(value={"refCoord >= read.getUnclippedStart()", "refCoord < read.getAlignmentStart()"})
    private static int getReadCoordinateForReferenceCoordinateBeforeAlignmentStart(SAMRecord read, int refCoord) {
        if (ReadUtils.getRefCoordSoftUnclippedStart(read) <= refCoord) {
            return refCoord - ReadUtils.getRefCoordSoftUnclippedStart(read) + 1;
        }
        return -1;
    }

    @Requires(value={"refCoord <= read.getUnclippedEnd()", "refCoord > read.getAlignmentEnd()"})
    private static int getReadCoordinateForReferenceCoordinateBeforeAlignmentEnd(SAMRecord read, int refCoord) {
        if (ReadUtils.getRefCoordSoftUnclippedEnd(read) >= refCoord) {
            return refCoord - ReadUtils.getRefCoordSoftUnclippedStart(read) + 1;
        }
        return -1;
    }

    @Requires(value={"refCoord >= read.getUnclippedStart()", "refCoord <= read.getUnclippedEnd()"})
    @Ensures(value={"result >= 0", "result < read.getReadLength()"})
    public static int getReadCoordinateForReferenceCoordinate(SAMRecord read, int refCoord) {
        int readBases = 0;
        int refBases = 0;
        if (refCoord < read.getAlignmentStart()) {
            readBases = ReadUtils.getReadCoordinateForReferenceCoordinateBeforeAlignmentStart(read, refCoord);
            if (readBases < 0) {
                throw new ReviewedStingException("Requested a coordinate in a hard clipped area of the read. No equivalent read coordinate.");
            }
        } else if (refCoord > read.getAlignmentEnd()) {
            readBases = ReadUtils.getReadCoordinateForReferenceCoordinateBeforeAlignmentEnd(read, refCoord);
            if (readBases < 0) {
                throw new ReviewedStingException("Requested a coordinate in a hard clipped area of the read. No equivalent read coordinate.");
            }
        } else {
            int goal = refCoord - read.getAlignmentStart();
            boolean goalReached = refBases == goal;
            Iterator<CigarElement> cigarElementIterator = read.getCigar().getCigarElements().iterator();
            while (!goalReached && cigarElementIterator.hasNext()) {
                CigarElement cigarElement = cigarElementIterator.next();
                int shift = 0;
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    shift = refBases + cigarElement.getLength() < goal ? cigarElement.getLength() : goal - refBases;
                    refBases += shift;
                }
                boolean bl = goalReached = refBases == goal;
                if (!cigarElement.getOperator().consumesReadBases()) continue;
                readBases += goalReached ? shift : cigarElement.getLength();
            }
            if (!goalReached) {
                throw new ReviewedStingException("Somehow the requested coordinate is not covered by the read. Too many deletions?");
            }
        }
        return readBases;
    }

    static {
        readFlagNames.put(1, "Paired");
        readFlagNames.put(2, "Proper");
        readFlagNames.put(4, "Unmapped");
        readFlagNames.put(8, "MateUnmapped");
        readFlagNames.put(16, "Forward");
        readFlagNames.put(64, "FirstOfPair");
        readFlagNames.put(128, "SecondOfPair");
        readFlagNames.put(256, "NotPrimary");
        readFlagNames.put(512, "NON-PF");
        readFlagNames.put(1024, "Duplicate");
    }

    public static enum ReadAndIntervalOverlap {
        NO_OVERLAP_CONTIG,
        NO_OVERLAP_LEFT,
        NO_OVERLAP_RIGHT,
        OVERLAP_LEFT,
        OVERLAP_RIGHT,
        OVERLAP_LEFT_AND_RIGHT,
        OVERLAP_CONTAINED;

    }

    public static enum OverlapType {
        NOT_OVERLAPPING,
        IN_ADAPTOR;

    }
}

