/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class NWaySAMFileWriter
implements SAMFileWriter {
    private Map<SAMReaderID, SAMFileWriter> writerMap = null;
    private boolean presorted;
    GenomeAnalysisEngine toolkit;

    public NWaySAMFileWriter(GenomeAnalysisEngine toolkit, Map<String, String> in2out, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly) {
        this.presorted = presorted;
        this.toolkit = toolkit;
        this.writerMap = new HashMap<SAMReaderID, SAMFileWriter>();
        this.setupByReader(toolkit, in2out, order, presorted, indexOnTheFly);
    }

    public NWaySAMFileWriter(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly) {
        this.presorted = presorted;
        this.toolkit = toolkit;
        this.writerMap = new HashMap<SAMReaderID, SAMFileWriter>();
        this.setupByReader(toolkit, ext, order, presorted, indexOnTheFly);
    }

    public void setupByReader(GenomeAnalysisEngine toolkit, Map<String, String> in2out, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly) {
        if (in2out == null) {
            throw new StingException("input-output bam filename map for n-way-out writing is NULL");
        }
        for (SAMReaderID rid : toolkit.getReadsDataSource().getReaderIDs()) {
            String fName = toolkit.getReadsDataSource().getSAMFile(rid).getName();
            if (!in2out.containsKey(fName)) {
                throw new UserException.BadInput("Input-output bam filename map does not contain an entry for the input file " + fName);
            }
            String outName = in2out.get(fName);
            if (this.writerMap.containsKey(rid)) {
                throw new StingException("nWayOut mode: Reader id for input sam file " + fName + " is already registered");
            }
            this.addWriter(rid, outName, order, presorted, indexOnTheFly);
        }
    }

    public void setupByReader(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly) {
        for (SAMReaderID rid : toolkit.getReadsDataSource().getReaderIDs()) {
            int pos;
            String fName = toolkit.getReadsDataSource().getSAMFile(rid).getName();
            if (fName.toUpperCase().endsWith(".BAM")) {
                pos = fName.toUpperCase().lastIndexOf(".BAM");
            } else if (fName.toUpperCase().endsWith(".SAM")) {
                pos = fName.toUpperCase().lastIndexOf(".SAM");
            } else {
                throw new UserException.BadInput("Input file name " + fName + " does not end with .sam or .bam");
            }
            String prefix = fName.substring(0, pos);
            String outName = prefix + ext;
            if (this.writerMap.containsKey(rid)) {
                throw new StingException("nWayOut mode: Reader id for input sam file " + fName + " is already registered");
            }
            this.addWriter(rid, outName, order, presorted, indexOnTheFly);
        }
    }

    private void addWriter(SAMReaderID id, String outName, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly) {
        File f = new File(outName);
        SAMFileHeader header = this.toolkit.getSAMFileHeader(id).clone();
        header.setSortOrder(order);
        SAMFileWriter sw = new SAMFileWriterFactory().setCreateIndex(indexOnTheFly).makeSAMOrBAMWriter(header, presorted, f);
        this.writerMap.put(id, sw);
    }

    @Override
    public void addAlignment(SAMRecord samRecord) {
        SAMReaderID id = this.toolkit.getReaderIDForRead(samRecord);
        String rg = samRecord.getStringAttribute("RG");
        if (rg != null) {
            String rg_orig = this.toolkit.getReadsDataSource().getOriginalReadGroupId(rg);
            samRecord.setAttribute("RG", (Object)rg_orig);
        }
        this.writerMap.get(id).addAlignment(samRecord);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.toolkit.getSAMFileHeader();
    }

    @Override
    public void close() {
        for (SAMFileWriter w : this.writerMap.values()) {
            w.close();
        }
    }
}

