/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.interval;

import java.util.Iterator;
import org.broadinstitute.sting.gatk.iterators.PushbackIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.bed.BedParser;

public class StringToGenomeLocIteratorAdapter
implements Iterator<GenomeLoc> {
    private GenomeLocParser genomeLocParser;
    private PushbackIterator<String> it = null;
    FORMAT myFormat = FORMAT.GATK;

    public StringToGenomeLocIteratorAdapter(GenomeLocParser genomeLocParser, Iterator<String> it, FORMAT format) {
        this.genomeLocParser = genomeLocParser;
        this.it = new PushbackIterator<String>(it);
        this.myFormat = format;
    }

    public StringToGenomeLocIteratorAdapter(GenomeLocParser genomeLocParser, Iterator<String> it) {
        this(genomeLocParser, it, FORMAT.GATK);
    }

    @Override
    public boolean hasNext() {
        String s = null;
        boolean success = false;
        while (this.it.hasNext()) {
            s = this.it.next();
            if (s.length() == 0 || s.matches("^\\s+$")) continue;
            success = true;
            this.it.pushback(s);
            break;
        }
        return success;
    }

    @Override
    public GenomeLoc next() {
        if (this.myFormat == FORMAT.GATK) {
            return this.genomeLocParser.parseGenomeLoc(this.it.next());
        }
        return BedParser.parseLocation(this.genomeLocParser, this.it.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("method 'remove' is not supported by this iterator");
    }

    public static enum FORMAT {
        BED,
        GATK;

    }
}

