/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.beagle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.broad.tribble.Feature;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.codecs.beagle.BeagleFeature;

public class BeagleCodec
implements ReferenceDependentFeatureCodec<BeagleFeature> {
    private String[] header;
    private BeagleReaderType readerType;
    private int valuesPerSample;
    private int initialSampleIndex;
    private int markerPosition;
    private ArrayList<String> sampleNames;
    private int expectedTokensPerLine;
    private static final String delimiterRegex = "\\s+";
    private GenomeLocParser genomeLocParser;
    private static Pattern MARKER_PATTERN = Pattern.compile("(.+):([0-9]+)");

    @Override
    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readHeader(File source) throws IOException {
        FileInputStream is = new FileInputStream(source);
        try {
            String[] stringArray = BeagleCodec.readHeader(new AsciiLineReader(is), null);
            return stringArray;
        }
        finally {
            is.close();
        }
    }

    @Override
    public Object readHeader(LineReader reader) {
        int[] lineCounter = new int[1];
        try {
            this.header = BeagleCodec.readHeader(reader, lineCounter);
            Boolean getSamples = true;
            this.markerPosition = 0;
            if (this.header[0].matches("I")) {
                this.readerType = BeagleReaderType.GENOTYPES;
                this.valuesPerSample = 2;
                this.initialSampleIndex = 2;
                this.markerPosition = 1;
            } else if (this.header[0].matches("marker")) {
                this.readerType = BeagleReaderType.PROBLIKELIHOOD;
                this.valuesPerSample = 3;
                this.initialSampleIndex = 3;
            } else {
                this.readerType = BeagleReaderType.R2;
                getSamples = false;
                lineCounter[0] = 0;
                this.valuesPerSample = 0;
                this.initialSampleIndex = 0;
            }
            this.sampleNames = new ArrayList();
            if (getSamples.booleanValue()) {
                for (int k = this.initialSampleIndex; k < this.header.length; k += this.valuesPerSample) {
                    this.sampleNames.add(this.header[k]);
                }
                this.expectedTokensPerLine = this.sampleNames.size() * this.valuesPerSample + this.initialSampleIndex;
            } else {
                this.expectedTokensPerLine = 2;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read from file.", e);
        }
        return this.header;
    }

    private static String[] readHeader(LineReader source, int[] lineCounter) throws IOException {
        String line;
        String[] header = null;
        int numLines = 0;
        while ((line = source.readLine()) != null) {
            ++numLines;
            if (line.trim().isEmpty()) continue;
            header = line.split(delimiterRegex);
            break;
        }
        if (header == null) {
            throw new IllegalArgumentException("No header in " + source);
        }
        if (lineCounter != null) {
            lineCounter[0] = numLines;
        }
        return header;
    }

    @Override
    public Class<BeagleFeature> getFeatureType() {
        return BeagleFeature.class;
    }

    @Override
    public BeagleFeature decode(String line) {
        String[] tokens = line.split(delimiterRegex);
        if (tokens.length != this.expectedTokensPerLine) {
            throw new CodecLineParsingException("Incorrect number of fields in Beagle input on line " + line);
        }
        BeagleFeature bglFeature = new BeagleFeature();
        GenomeLoc loc = this.genomeLocParser.parseGenomeLoc(tokens[this.markerPosition]);
        bglFeature.setChr(loc.getContig());
        bglFeature.setStart(loc.getStart());
        bglFeature.setEnd(loc.getStop());
        if (this.readerType == BeagleReaderType.R2) {
            bglFeature.setR2value(Double.valueOf(tokens[1]));
        } else if (this.readerType == BeagleReaderType.GENOTYPES) {
            HashMap<String, ArrayList<String>> sampleGenotypes = new HashMap<String, ArrayList<String>>();
            for (int i = 2; i < tokens.length; i += 2) {
                String sampleName = this.sampleNames.get(i / 2 - 1);
                if (!sampleGenotypes.containsKey(sampleName)) {
                    sampleGenotypes.put(sampleName, new ArrayList());
                }
                sampleGenotypes.get(sampleName).add(tokens[i]);
                sampleGenotypes.get(sampleName).add(tokens[i + 1]);
            }
            bglFeature.setGenotypes(sampleGenotypes);
        } else {
            bglFeature.setAlleleA(tokens[1], true);
            bglFeature.setAlleleB(tokens[2], false);
            HashMap<String, ArrayList<String>> sampleProbLikelihoods = new HashMap<String, ArrayList<String>>();
            for (int i = 3; i < tokens.length; i += 3) {
                String sampleName = this.sampleNames.get(i / 3 - 1);
                if (!sampleProbLikelihoods.containsKey(sampleName)) {
                    sampleProbLikelihoods.put(sampleName, new ArrayList());
                }
                sampleProbLikelihoods.get(sampleName).add(tokens[i]);
                sampleProbLikelihoods.get(sampleName).add(tokens[i + 1]);
                sampleProbLikelihoods.get(sampleName).add(tokens[i + 2]);
            }
            bglFeature.setProbLikelihoods(sampleProbLikelihoods);
        }
        return bglFeature;
    }

    public static enum BeagleReaderType {
        PROBLIKELIHOOD,
        GENOTYPES,
        R2;

    }
}

