/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.sample.Sample;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class MendelianViolation {
    String sampleMom;
    String sampleDad;
    String sampleChild;
    List allelesMom;
    List allelesDad;
    List allelesChild;
    double minGenotypeQuality;
    private static Pattern FAMILY_PATTERN = Pattern.compile("(.*)\\+(.*)=(.*)");

    public String getSampleMom() {
        return this.sampleMom;
    }

    public String getSampleDad() {
        return this.sampleDad;
    }

    public String getSampleChild() {
        return this.sampleChild;
    }

    public double getMinGenotypeQuality() {
        return this.minGenotypeQuality;
    }

    public MendelianViolation(String sampleMomP, String sampleDadP, String sampleChildP) {
        this.sampleMom = sampleMomP;
        this.sampleDad = sampleDadP;
        this.sampleChild = sampleChildP;
    }

    public MendelianViolation(String family, double minGenotypeQualityP) {
        this.minGenotypeQuality = minGenotypeQualityP;
        Matcher m = FAMILY_PATTERN.matcher(family);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformatted family structure string: " + family + " required format is mom+dad=child");
        }
        this.sampleMom = m.group(1);
        this.sampleDad = m.group(2);
        this.sampleChild = m.group(3);
    }

    public MendelianViolation(Sample sample, double minGenotypeQualityP) {
        this.sampleMom = sample.getMother().getId();
        this.sampleDad = sample.getFather().getId();
        this.sampleChild = sample.getId();
        this.minGenotypeQuality = minGenotypeQualityP;
    }

    public MendelianViolation(GenomeAnalysisEngine engine, double minGenotypeQualityP) {
        boolean gotSampleInformation = false;
        Collection<Sample> samples = engine.getSamples();
        for (Sample sample : samples) {
            if (sample.getMother() == null || sample.getFather() == null) continue;
            this.sampleMom = sample.getMother().getId();
            this.sampleDad = sample.getFather().getId();
            this.sampleChild = sample.getId();
            this.minGenotypeQuality = minGenotypeQualityP;
            gotSampleInformation = true;
            break;
        }
        if (!gotSampleInformation) {
            throw new UserException("YAML file has no sample with relationship information (mother/father)");
        }
    }

    public boolean setAlleles(VariantContext vc) {
        Genotype gMom = vc.getGenotypes(this.sampleMom).get(this.sampleMom);
        Genotype gDad = vc.getGenotypes(this.sampleDad).get(this.sampleDad);
        Genotype gChild = vc.getGenotypes(this.sampleChild).get(this.sampleChild);
        if (gMom == null || gDad == null || gChild == null) {
            throw new IllegalArgumentException(String.format("Variant %s:%d didn't contain genotypes for all family members: mom=%s dad=%s child=%s", vc.getChr(), vc.getStart(), this.sampleMom, this.sampleDad, this.sampleChild));
        }
        if (gMom.isNoCall() || gDad.isNoCall() || gChild.isNoCall() || gMom.getPhredScaledQual() < this.minGenotypeQuality || gDad.getPhredScaledQual() < this.minGenotypeQuality || gChild.getPhredScaledQual() < this.minGenotypeQuality) {
            return false;
        }
        this.allelesMom = gMom.getAlleles();
        this.allelesDad = gDad.getAlleles();
        this.allelesChild = gChild.getAlleles();
        return !this.allelesMom.isEmpty() && !this.allelesDad.isEmpty() && !this.allelesChild.isEmpty();
    }

    public boolean isViolation(VariantContext vc) {
        return this.setAlleles(vc) && this.isViolation();
    }

    public boolean isViolation() {
        return (!this.allelesMom.contains(this.allelesChild.get(0)) || !this.allelesDad.contains(this.allelesChild.get(1))) && (!this.allelesMom.contains(this.allelesChild.get(1)) || !this.allelesDad.contains(this.allelesChild.get(0)));
    }
}

