/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.RequiredStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.AnalysisModuleScanner;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.NewEvaluationContext;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.StateKey;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class VariantEvalUtils {
    private final VariantEvalWalker variantEvalWalker;
    Logger logger;

    public VariantEvalUtils(VariantEvalWalker variantEvalWalker) {
        this.variantEvalWalker = variantEvalWalker;
        this.logger = variantEvalWalker.getLogger();
    }

    public void listModulesAndExit() {
        List<Class<VariantStratifier>> vsClasses = new PluginManager<VariantStratifier>(VariantStratifier.class).getPlugins();
        List<Class<VariantEvaluator>> veClasses = new PluginManager<VariantEvaluator>(VariantEvaluator.class).getPlugins();
        this.logger.info("Available stratification modules:");
        this.logger.info("(Standard modules are starred)");
        for (Class<VariantStratifier> clazz : vsClasses) {
            this.logger.info("\t" + clazz.getSimpleName() + (RequiredStratification.class.isAssignableFrom(clazz) || StandardStratification.class.isAssignableFrom(clazz) ? "*" : ""));
        }
        this.logger.info("");
        this.logger.info("Available evaluation modules:");
        this.logger.info("(Standard modules are starred)");
        for (Class<Object> clazz : veClasses) {
            this.logger.info("\t" + clazz.getSimpleName() + (StandardEval.class.isAssignableFrom(clazz) ? "*" : ""));
        }
        this.logger.info("");
        System.exit(0);
    }

    public TreeSet<VariantStratifier> initializeStratificationObjects(VariantEvalWalker variantEvalWalker, boolean noStandardStrats, String[] modulesToUse) {
        TreeSet<VariantStratifier> strats = new TreeSet<VariantStratifier>();
        HashSet<String> stratsToUse = new HashSet<String>();
        HashMap<String, Class<VariantStratifier>> classMap = new HashMap<String, Class<VariantStratifier>>();
        for (Class<VariantStratifier> clazz : new PluginManager<VariantStratifier>(VariantStratifier.class).getPlugins()) {
            classMap.put(clazz.getSimpleName(), clazz);
        }
        for (Class<Object> clazz : new PluginManager<RequiredStratification>(RequiredStratification.class).getPlugins()) {
            if (!classMap.containsKey(clazz.getSimpleName())) continue;
            stratsToUse.add(clazz.getSimpleName());
        }
        if (!noStandardStrats) {
            for (Class<Object> clazz : new PluginManager<StandardStratification>(StandardStratification.class).getPlugins()) {
                if (!classMap.containsKey(clazz.getSimpleName())) continue;
                stratsToUse.add(clazz.getSimpleName());
            }
        }
        stratsToUse.addAll(Arrays.asList(modulesToUse));
        for (String string : stratsToUse) {
            if (!classMap.containsKey(string)) {
                throw new UserException.CommandLineException("Module " + string + " could not be found; please check that you have specified the class name correctly");
            }
            if (!classMap.containsKey(string)) continue;
            Class c = (Class)classMap.get(string);
            try {
                VariantStratifier vs = (VariantStratifier)c.newInstance();
                vs.setVariantEvalWalker(variantEvalWalker);
                vs.initialize();
                strats.add(vs);
            }
            catch (InstantiationException e) {
                throw new StingException("Unable to instantiate stratification module '" + c.getSimpleName() + "'");
            }
            catch (IllegalAccessException e) {
                throw new StingException("Illegal access error when trying to instantiate stratification module '" + c.getSimpleName() + "'");
            }
        }
        return strats;
    }

    public Set<Class<? extends VariantEvaluator>> initializeEvaluationObjects(boolean noStandardEvals, String[] modulesToUse) {
        HashSet<Class<? extends VariantEvaluator>> evals = new HashSet<Class<? extends VariantEvaluator>>();
        HashMap<String, Class<VariantEvaluator>> classMap = new HashMap<String, Class<VariantEvaluator>>();
        for (Class<VariantEvaluator> clazz : new PluginManager<VariantEvaluator>(VariantEvaluator.class).getPlugins()) {
            classMap.put(clazz.getSimpleName(), clazz);
        }
        if (!noStandardEvals) {
            for (Class<Object> clazz : new PluginManager<StandardEval>(StandardEval.class).getPlugins()) {
                if (!classMap.containsKey(clazz.getSimpleName())) continue;
                evals.add((Class<? extends VariantEvaluator>)classMap.get(clazz.getSimpleName()));
            }
        }
        for (String module : modulesToUse) {
            if (!classMap.containsKey(module)) {
                throw new UserException.CommandLineException("Module " + module + " could not be found; please check that you have specified the class name correctly");
            }
            if (!classMap.containsKey(module)) continue;
            evals.add((Class<? extends VariantEvaluator>)classMap.get(module));
        }
        return evals;
    }

    public HashMap<StateKey, NewEvaluationContext> initializeEvaluationContexts(Set<VariantStratifier> stratificationObjects, Set<Class<? extends VariantEvaluator>> evaluationObjects, Stack<VariantStratifier> stratStack, NewEvaluationContext ec) {
        HashMap<StateKey, NewEvaluationContext> ecs = new HashMap<StateKey, NewEvaluationContext>();
        if (stratStack == null) {
            stratStack = new Stack();
            stratStack.addAll(stratificationObjects);
        }
        if (!stratStack.isEmpty()) {
            Stack<VariantStratifier> newStratStack = new Stack<VariantStratifier>();
            newStratStack.addAll(stratStack);
            VariantStratifier vs = (VariantStratifier)newStratStack.pop();
            for (String state : vs.getAllStates()) {
                NewEvaluationContext nec = new NewEvaluationContext();
                if (ec != null) {
                    nec.putAll(ec);
                }
                nec.put(vs, state);
                ecs.putAll(this.initializeEvaluationContexts(stratificationObjects, evaluationObjects, newStratStack, nec));
            }
        } else {
            HashMap<StateKey, NewEvaluationContext> necs = new HashMap<StateKey, NewEvaluationContext>();
            StateKey stateKey = new StateKey();
            for (VariantStratifier vs : ec.keySet()) {
                String state = (String)ec.get(vs);
                stateKey.put(vs.getClass().getSimpleName(), state);
            }
            ec.addEvaluationClassList(this.variantEvalWalker, stateKey, evaluationObjects);
            necs.put(stateKey, ec);
            return necs;
        }
        return ecs;
    }

    public GATKReport initializeGATKReport(Set<VariantStratifier> stratificationObjects, Set<Class<? extends VariantEvaluator>> evaluationObjects) {
        GATKReport report = new GATKReport();
        for (Class<? extends VariantEvaluator> ve : evaluationObjects) {
            String tableName = ve.getSimpleName();
            String tableDesc = ve.getAnnotation(Analysis.class).description();
            report.addTable(tableName, tableDesc);
            GATKReportTable table = report.getTable(tableName);
            table.addPrimaryKey("entry", false);
            table.addColumn(tableName, tableName);
            for (VariantStratifier vs : stratificationObjects) {
                String columnName = vs.getClass().getSimpleName();
                table.addColumn(columnName, "unknown");
            }
            try {
                VariantEvaluator vei = ve.newInstance();
                vei.initialize(this.variantEvalWalker);
                AnalysisModuleScanner scanner = new AnalysisModuleScanner(vei);
                Map<Field, DataPoint> datamap = scanner.getData();
                for (Field field : datamap.keySet()) {
                    field.setAccessible(true);
                    if (field.get(vei) instanceof TableType) continue;
                    table.addColumn(field.getName(), 0.0);
                }
            }
            catch (InstantiationException e) {
                throw new StingException("InstantiationException: " + e);
            }
            catch (IllegalAccessException e) {
                throw new StingException("IllegalAccessException: " + e);
            }
        }
        return report;
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, String sampleName) {
        return this.getSubsetOfVariantContext(vc, Arrays.asList(sampleName));
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, Collection<String> sampleNames) {
        int newAlleleCount;
        VariantContext vcsub = vc.subContextFromGenotypes(vc.getGenotypes(sampleNames).values(), vc.getAlleles());
        HashMap<String, Object> newAts = new HashMap<String, Object>(vcsub.getAttributes());
        int originalAlleleCount = vc.getHetCount() + 2 * vc.getHomVarCount();
        if (originalAlleleCount == (newAlleleCount = vcsub.getHetCount() + 2 * vcsub.getHomVarCount()) && newAlleleCount == 1) {
            newAts.put("ISSINGLETON", true);
        }
        VariantContextUtils.calculateChromosomeCounts(vcsub, newAts, true);
        vcsub = VariantContext.modifyAttributes(vcsub, newAts);
        return vcsub;
    }

    public HashMap<RodBinding<VariantContext>, HashMap<String, Set<VariantContext>>> bindVariantContexts(RefMetaDataTracker tracker, ReferenceContext ref, List<RodBinding<VariantContext>> tracks, boolean byFilter, boolean subsetBySample, boolean trackPerSample) {
        if (tracker == null) {
            return null;
        }
        HashMap<RodBinding<VariantContext>, HashMap<String, Set<VariantContext>>> bindings = new HashMap<RodBinding<VariantContext>, HashMap<String, Set<VariantContext>>>();
        for (RodBinding<VariantContext> track : tracks) {
            HashMap<String, Set<VariantContext>> mapping = new HashMap<String, Set<VariantContext>>();
            Iterator<VariantContext> i$ = tracker.getValues(track, ref.getLocus()).iterator();
            while (i$.hasNext()) {
                VariantContext vc;
                VariantContext vcsub = vc = i$.next();
                if (subsetBySample && vc.hasGenotypes() && vc.hasGenotypes(this.variantEvalWalker.getSampleNamesForEvaluation())) {
                    vcsub = this.getSubsetOfVariantContext(vc, this.variantEvalWalker.getSampleNamesForEvaluation());
                }
                if (byFilter || !vcsub.isFiltered()) {
                    this.addMapping(mapping, VariantEvalWalker.getAllSampleName(), vcsub);
                }
                if (!vc.hasGenotypes() || !trackPerSample) continue;
                for (String sampleName : this.variantEvalWalker.getSampleNamesForEvaluation()) {
                    VariantContext samplevc = this.getSubsetOfVariantContext(vc, sampleName);
                    if (!byFilter && samplevc.isFiltered()) continue;
                    this.addMapping(mapping, sampleName, samplevc);
                }
            }
            bindings.put(track, mapping);
        }
        return bindings;
    }

    private void addMapping(HashMap<String, Set<VariantContext>> mappings, String sample, VariantContext vc) {
        if (!mappings.containsKey(sample)) {
            mappings.put(sample, new HashSet());
        }
        mappings.get(sample).add(vc);
    }

    public ArrayList<StateKey> initializeStateKeys(HashMap<VariantStratifier, List<String>> stateMap, Stack<HashMap<VariantStratifier, List<String>>> stateStack, StateKey stateKey, ArrayList<StateKey> stateKeys) {
        if (stateStack == null) {
            stateStack = new Stack();
            for (VariantStratifier vs : stateMap.keySet()) {
                HashMap<VariantStratifier, List<String>> oneSetOfStates = new HashMap<VariantStratifier, List<String>>();
                oneSetOfStates.put(vs, stateMap.get(vs));
                stateStack.add(oneSetOfStates);
            }
        }
        if (!stateStack.isEmpty()) {
            Stack<HashMap<VariantStratifier, List<String>>> newStateStack = new Stack<HashMap<VariantStratifier, List<String>>>();
            newStateStack.addAll(stateStack);
            HashMap oneSetOfStates = (HashMap)newStateStack.pop();
            VariantStratifier vs = (VariantStratifier)oneSetOfStates.keySet().iterator().next();
            for (String state : (List)oneSetOfStates.get(vs)) {
                StateKey newStateKey = new StateKey();
                if (stateKey != null) {
                    newStateKey.putAll(stateKey);
                }
                newStateKey.put(vs.getClass().getSimpleName(), state);
                this.initializeStateKeys(stateMap, newStateStack, newStateKey, stateKeys);
            }
        } else {
            stateKeys.add(stateKey);
            return stateKeys;
        }
        return stateKeys;
    }
}

