/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.StateKey;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class NewEvaluationContext
extends HashMap<VariantStratifier, String> {
    public TreeMap<String, VariantEvaluator> evaluationInstances;

    @Override
    public String toString() {
        String value = "";
        for (VariantStratifier key : this.keySet()) {
            value = value + "\t" + key.getClass().getSimpleName() + ":" + (String)this.get(key) + "\n";
        }
        return value;
    }

    public void addEvaluationClassList(VariantEvalWalker walker, StateKey stateKey, Set<Class<? extends VariantEvaluator>> evaluationClasses) {
        this.evaluationInstances = new TreeMap();
        for (Class<? extends VariantEvaluator> c : evaluationClasses) {
            try {
                VariantEvaluator eval = c.newInstance();
                eval.initialize(walker);
                if (!eval.stateIsApplicable(stateKey)) continue;
                this.evaluationInstances.put(c.getSimpleName(), eval);
            }
            catch (InstantiationException e) {
                throw new StingException("Unable to instantiate eval module '" + c.getSimpleName() + "'");
            }
            catch (IllegalAccessException e) {
                throw new StingException("Illegal access error when trying to instantiate eval module '" + c.getSimpleName() + "'");
            }
        }
    }

    public TreeMap<String, VariantEvaluator> getEvaluationClassList() {
        return this.evaluationInstances;
    }

    public void apply(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context, VariantContext comp, VariantContext eval) {
        block4: for (VariantEvaluator evaluation : this.evaluationInstances.values()) {
            if (tracker == null) continue;
            switch (evaluation.getComparisonOrder()) {
                case 1: {
                    if (eval == null) continue block4;
                    evaluation.update1(eval, tracker, ref, context);
                    continue block4;
                }
                case 2: {
                    evaluation.update2(eval, comp, tracker, ref, context);
                    continue block4;
                }
            }
            throw new ReviewedStingException("BUG: Unexpected evaluation order " + evaluation);
        }
    }

    public void update0(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        for (VariantEvaluator evaluation : this.evaluationInstances.values()) {
            evaluation.update0(tracker, ref, context);
        }
    }
}

