/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.broadinstitute.sting.commandline.Gatherer;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalDatumOptimized;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class CountCovariatesGatherer
extends Gatherer {
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^#.*");
    private static final Pattern COVARIATE_PATTERN = Pattern.compile("^ReadGroup,QualityScore,.*");
    private static final String EOF_MARKER = "EOF";
    private HashMap<String, RecalDatumOptimized> dataMap;

    private void addCSVData(String line) {
        String[] covariates = line.split(",");
        String key = "";
        for (int i = 0; i < covariates.length - 3; ++i) {
            key = key + covariates[i] + ",";
        }
        RecalDatumOptimized values = new RecalDatumOptimized(Integer.parseInt(covariates[covariates.length - 3]), Integer.parseInt(covariates[covariates.length - 2]));
        if (this.dataMap.get(key) != null) {
            RecalDatumOptimized currentValues = this.dataMap.get(key);
            values.increment(currentValues);
        }
        this.dataMap.put(key, values);
    }

    @Override
    public void gather(List<File> inputs, File output) {
        PrintStream o;
        this.dataMap = new HashMap();
        try {
            o = new PrintStream(output);
        }
        catch (FileNotFoundException e) {
            throw new UserException("File to be output by CountCovariates Gather function was not found");
        }
        boolean sawEOF = false;
        boolean printedHeader = false;
        for (File RECAL_FILE : inputs) {
            try {
                for (String line : new XReadLines(RECAL_FILE)) {
                    if (EOF_MARKER.equals(line)) {
                        sawEOF = true;
                        continue;
                    }
                    if (COMMENT_PATTERN.matcher(line).matches()) continue;
                    if (COVARIATE_PATTERN.matcher(line).matches()) {
                        if (printedHeader) continue;
                        o.println(line);
                        continue;
                    }
                    this.addCSVData(line);
                }
            }
            catch (FileNotFoundException e) {
                throw new UserException.CouldNotReadInputFile(RECAL_FILE, "Can not find input file", e);
            }
            if (!sawEOF) {
                String errorMessage = "No EOF marker was present in the recal covariates table; this could mean that the file is corrupted!";
                throw new UserException.MalformedFile(RECAL_FILE, "No EOF marker was present in the recal covariates table; this could mean that the file is corrupted!");
            }
            printedHeader = true;
        }
        for (String key : this.dataMap.keySet()) {
            RecalDatumOptimized values = this.dataMap.get(key);
            String v = values.getNumObservations() + "," + values.getNumMismatches() + "," + values.empiricalQualByte();
            o.println(key + v);
        }
        o.println(EOF_MARKER);
    }
}

