/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.Arrays;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.qc.ValidationStats;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.codecs.sampileup.SAMPileupFeature;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

@Requires(value={DataSource.READS, DataSource.REFERENCE})
public class ValidatingPileupWalker
extends LocusWalker<Integer, ValidationStats>
implements TreeReducible<ValidationStats> {
    @Input(fullName="pileup", doc="The SAMPileup containing the expected output", required=true)
    RodBinding<SAMPileupFeature> pileup;
    @Output
    private PrintStream out;
    @Argument(fullName="continue_after_error", doc="Continue after an error", required=false)
    public boolean CONTINUE_AFTER_AN_ERROR = false;

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        ReadBackedPileup pileup = context.getBasePileup();
        SAMPileupFeature truePileup = this.getTruePileup(tracker);
        if (truePileup == null) {
            this.out.printf("No truth pileup data available at %s%n", pileup.getPileupString(Character.valueOf(ref.getBaseAsChar())));
            if (!this.CONTINUE_AFTER_AN_ERROR) {
                throw new UserException.CommandLineException(String.format("No pileup data available at %s given GATK's output of %s -- this walker requires samtools pileup data over all bases", context.getLocation(), new String(pileup.getBases())));
            }
        } else {
            String pileupDiff = this.pileupDiff(pileup, truePileup, true);
            if (pileupDiff != null) {
                this.out.printf("%s vs. %s%n", pileup.getPileupString(Character.valueOf(ref.getBaseAsChar())), truePileup.getPileupString());
                if (!this.CONTINUE_AFTER_AN_ERROR) {
                    throw new RuntimeException(String.format("Pileups aren't equal: %s", pileupDiff));
                }
            }
        }
        return pileup.size();
    }

    private static String maybeSorted(String x, boolean sortMe) {
        if (sortMe) {
            byte[] bytes = x.getBytes();
            Arrays.sort(bytes);
            return new String(bytes);
        }
        return x;
    }

    public String pileupDiff(ReadBackedPileup a, SAMPileupFeature b, boolean orderDependent) {
        String bQuals;
        if (a.size() != b.size()) {
            return "Sizes not equal";
        }
        GenomeLoc featureLocation = this.getToolkit().getGenomeLocParser().createGenomeLoc(b.getChr(), b.getStart(), b.getEnd());
        if (a.getLocation().compareTo(featureLocation) != 0) {
            return "Locations not equal";
        }
        String aBases = ValidatingPileupWalker.maybeSorted(new String(a.getBases()), !orderDependent);
        String bBases = ValidatingPileupWalker.maybeSorted(b.getBasesAsString(), !orderDependent);
        if (!aBases.toUpperCase().equals(bBases.toUpperCase())) {
            return "Bases not equal";
        }
        String aQuals = ValidatingPileupWalker.maybeSorted(new String(a.getQuals()), !orderDependent);
        if (!aQuals.equals(bQuals = ValidatingPileupWalker.maybeSorted(new String(b.getQuals()), !orderDependent))) {
            return "Quals not equal";
        }
        return null;
    }

    @Override
    public ValidationStats reduceInit() {
        return new ValidationStats();
    }

    @Override
    public ValidationStats reduce(Integer value, ValidationStats sum) {
        ++sum.nLoci;
        sum.nBases += (long)value.intValue();
        return sum;
    }

    @Override
    public ValidationStats treeReduce(ValidationStats lhs, ValidationStats rhs) {
        ValidationStats combined = new ValidationStats();
        combined.nLoci = lhs.nLoci + rhs.nLoci;
        combined.nBases = lhs.nBases + rhs.nBases;
        return combined;
    }

    private SAMPileupFeature getTruePileup(RefMetaDataTracker tracker) {
        SAMPileupFeature pileupArg = tracker.getFirstValue(this.pileup);
        if (pileupArg == null) {
            return null;
        }
        if (pileupArg.hasPointGenotype()) {
            return pileupArg.getPointGenotype();
        }
        if (pileupArg.hasIndelGenotype()) {
            return pileupArg.getIndelGenotype();
        }
        throw new ReviewedStingException("Unsupported pileup type: " + pileupArg);
    }
}

