/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.sam.SamPairUtil;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class ConstrainedMateFixingManager {
    protected static final Logger logger = Logger.getLogger(ConstrainedMateFixingManager.class);
    private static final boolean DEBUG = false;
    private static final int EMIT_FREQUENCY = 1000;
    final int MAX_POS_MOVE_ALLOWED;
    final int MAX_RECORDS_IN_MEMORY;
    private final SAMRecordComparator comparer = new SAMRecordCoordinateComparator();
    final SAMFileWriter writer;
    final int maxInsertSizeForMovingReadPairs;
    final GenomeLocParser genomeLocParser;
    private GenomeLoc lastLocFlushed = null;
    int counter = 0;
    HashMap<String, SAMRecordHashObject> forMateMatching = new HashMap();
    TreeSet<SAMRecord> waitingReads = new TreeSet<SAMRecord>(this.comparer);

    private SAMRecord remove(TreeSet<SAMRecord> treeSet) {
        SAMRecord first = treeSet.first();
        if (!treeSet.remove(first)) {
            throw new UserException("Error caching SAM record " + first.getReadName() + ", which is usually caused by malformed SAM/BAM files in which multiple identical copies of a read are present.");
        }
        return first;
    }

    public ConstrainedMateFixingManager(SAMFileWriter writer, GenomeLocParser genomeLocParser, int maxInsertSizeForMovingReadPairs, int maxMoveAllowed, int maxRecordsInMemory) {
        this.writer = writer;
        this.genomeLocParser = genomeLocParser;
        this.maxInsertSizeForMovingReadPairs = maxInsertSizeForMovingReadPairs;
        this.MAX_POS_MOVE_ALLOWED = maxMoveAllowed;
        this.MAX_RECORDS_IN_MEMORY = maxRecordsInMemory;
    }

    public int getNReadsInQueue() {
        return this.waitingReads.size();
    }

    public boolean canMoveReads(GenomeLoc earliestPosition) {
        return this.lastLocFlushed == null || this.lastLocFlushed.compareContigs(earliestPosition) != 0 || this.lastLocFlushed.distance(earliestPosition) > this.maxInsertSizeForMovingReadPairs;
    }

    private boolean noReadCanMoveBefore(int pos, SAMRecord addedRead) {
        return pos + 2 * this.MAX_POS_MOVE_ALLOWED < addedRead.getAlignmentStart();
    }

    public void addRead(SAMRecord newRead, boolean readWasModified) {
        this.addRead(newRead, readWasModified, true);
    }

    public void addReads(List<SAMRecord> newReads, Set<SAMRecord> modifiedReads) {
        for (SAMRecord newRead : newReads) {
            this.addRead(newRead, modifiedReads.contains(newRead), false);
        }
    }

    private void addRead(SAMRecord newRead, boolean readWasModified, boolean canFlush) {
        boolean tooManyReads;
        boolean bl = tooManyReads = this.getNReadsInQueue() >= this.MAX_RECORDS_IN_MEMORY;
        if (canFlush && tooManyReads || this.getNReadsInQueue() > 0 && !this.waitingReads.first().getReferenceIndex().equals(newRead.getReferenceIndex())) {
            while (this.getNReadsInQueue() > 1) {
                this.writeRead(this.remove(this.waitingReads));
            }
            SAMRecord lastRead = this.remove(this.waitingReads);
            this.lastLocFlushed = lastRead.getReferenceIndex() == -1 ? null : this.genomeLocParser.createGenomeLoc(lastRead);
            this.writeRead(lastRead);
            if (!tooManyReads) {
                this.forMateMatching.clear();
            } else {
                this.purgeUnmodifiedMates();
            }
        }
        if (newRead.getReadPairedFlag()) {
            SAMRecordHashObject mate = this.forMateMatching.get(newRead.getReadName());
            if (mate != null) {
                boolean doNotFixMates;
                boolean bl2 = doNotFixMates = newRead.getReadUnmappedFlag() && (mate.record.getReadUnmappedFlag() || !this.waitingReads.contains(mate.record));
                if (!doNotFixMates) {
                    boolean reQueueMate;
                    boolean bl3 = reQueueMate = mate.record.getReadUnmappedFlag() && !newRead.getReadUnmappedFlag();
                    if (reQueueMate && !this.waitingReads.remove(mate.record)) {
                        reQueueMate = false;
                    }
                    SamPairUtil.setMateInfo(mate.record, newRead, null);
                    if (reQueueMate) {
                        this.waitingReads.add(mate.record);
                    }
                }
                this.forMateMatching.remove(newRead.getReadName());
            } else if (this.pairedReadIsMovable(newRead)) {
                this.forMateMatching.put(newRead.getReadName(), new SAMRecordHashObject(newRead, readWasModified));
            }
        }
        this.waitingReads.add(newRead);
        if (++this.counter % 1000 == 0) {
            SAMRecord read;
            while (!this.waitingReads.isEmpty() && this.noReadCanMoveBefore((read = this.waitingReads.first()).getAlignmentStart(), newRead) && (!this.pairedReadIsMovable(read) || this.noReadCanMoveBefore(read.getMateAlignmentStart(), newRead))) {
                this.forMateMatching.remove(read.getReadName());
                this.writeRead(this.remove(this.waitingReads));
            }
        }
    }

    private void writeRead(SAMRecord read) {
        try {
            this.writer.addAlignment(read);
        }
        catch (IllegalArgumentException e) {
            throw new UserException("If the maximum allowable reads in memory is too small, it may cause reads to be written out of order when trying to write the BAM; please see the --maxReadsInMemory argument for details.  " + e.getMessage(), e);
        }
    }

    public boolean iSizeTooBigToMove(SAMRecord read) {
        return ConstrainedMateFixingManager.iSizeTooBigToMove(read, this.maxInsertSizeForMovingReadPairs);
    }

    public static boolean iSizeTooBigToMove(SAMRecord read, int maxInsertSizeForMovingReadPairs) {
        return read.getReadPairedFlag() && !read.getMateUnmappedFlag() && read.getReferenceName() != read.getMateReferenceName() || Math.abs(read.getInferredInsertSize()) > maxInsertSizeForMovingReadPairs;
    }

    private void purgeUnmodifiedMates() {
        HashMap<String, SAMRecordHashObject> forMateMatchingCleaned = new HashMap<String, SAMRecordHashObject>();
        for (Map.Entry<String, SAMRecordHashObject> entry : this.forMateMatching.entrySet()) {
            if (!entry.getValue().wasModified) continue;
            forMateMatchingCleaned.put(entry.getKey(), entry.getValue());
        }
        this.forMateMatching.clear();
        this.forMateMatching = forMateMatchingCleaned;
    }

    private boolean pairedReadIsMovable(SAMRecord read) {
        return read.getReadPairedFlag() && (!read.getReadUnmappedFlag() || !read.getMateUnmappedFlag()) && !this.iSizeTooBigToMove(read);
    }

    public void close() {
        while (!this.waitingReads.isEmpty()) {
            this.writeRead(this.remove(this.waitingReads));
        }
    }

    private class SAMRecordHashObject {
        public SAMRecord record;
        public boolean wasModified;

        public SAMRecordHashObject(SAMRecord record, boolean wasModified) {
            this.record = record;
            this.wasModified = wasModified;
        }
    }
}

