/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class MultiallelicGenotypeLikelihoods {
    private String sample;
    private double[] GLs;
    private ArrayList<Allele> alleleList;
    private int depth;

    public MultiallelicGenotypeLikelihoods(String sample, ArrayList<Allele> A, double[] log10Likelihoods, int depth) {
        int numAlleles = A.size();
        if (log10Likelihoods.length != numAlleles * (numAlleles + 1) / 2) {
            throw new StingException("BUG: Incorrect length of GL vector when creating MultiallelicGenotypeLikelihoods object!");
        }
        this.sample = sample;
        this.alleleList = A;
        this.GLs = log10Likelihoods;
        this.depth = depth;
    }

    public String getSample() {
        return this.sample;
    }

    public double[] getLikelihoods() {
        return this.GLs;
    }

    public ArrayList<Allele> getAlleles() {
        return this.alleleList;
    }

    public int getDepth() {
        return this.depth;
    }
}

