/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidIndelGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.MultiallelicGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.indels.HaplotypeIndelErrorModel;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.genotype.Haplotype;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class IndelGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    private final int HAPLOTYPE_SIZE;
    private final int minIndelCountForGenotyping;
    private final boolean getAlleleListFromVCF;
    private boolean DEBUG = false;
    private boolean ignoreSNPAllelesWhenGenotypingIndels = false;
    private PairHMMIndelErrorModel pairModel;
    private static ThreadLocal<HashMap<PileupElement, LinkedHashMap<Allele, Double>>> indelLikelihoodMap = new ThreadLocal<HashMap<PileupElement, LinkedHashMap<Allele, Double>>>(){

        @Override
        protected synchronized HashMap<PileupElement, LinkedHashMap<Allele, Double>> initialValue() {
            return new HashMap<PileupElement, LinkedHashMap<Allele, Double>>();
        }
    };
    private LinkedHashMap<Allele, Haplotype> haplotypeMap;
    private HaplotypeIndelErrorModel model;
    private boolean useOldWrongHorribleHackedUpLikelihoodModel = false;
    private GenomeLoc lastSiteVisited;
    private ArrayList<Allele> alleleList;
    private static final EnumSet<VariantContext.Type> allowableTypes;

    protected IndelGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        if (!UAC.GSA_PRODUCTION_ONLY) {
            this.pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, UAC.DO_CONTEXT_DEPENDENT_PENALTIES, UAC.dovit, UAC.GET_GAP_PENALTIES_FROM_DATA, UAC.INDEL_RECAL_FILE);
            this.useOldWrongHorribleHackedUpLikelihoodModel = false;
        } else {
            this.useOldWrongHorribleHackedUpLikelihoodModel = true;
            double INSERTION_START_PROBABILITY = 0.001;
            double INSERTION_END_PROBABILITY = 0.5;
            double ALPHA_DELETION_PROBABILITY = 0.001;
            this.model = new HaplotypeIndelErrorModel(3, INSERTION_START_PROBABILITY, INSERTION_END_PROBABILITY, ALPHA_DELETION_PROBABILITY, UAC.INDEL_HAPLOTYPE_SIZE, false, UAC.OUTPUT_DEBUG_INDEL_INFO);
        }
        this.pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, UAC.DO_CONTEXT_DEPENDENT_PENALTIES, UAC.dovit, UAC.GET_GAP_PENALTIES_FROM_DATA, UAC.INDEL_RECAL_FILE);
        this.alleleList = new ArrayList();
        this.getAlleleListFromVCF = UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
        this.minIndelCountForGenotyping = UAC.MIN_INDEL_COUNT_FOR_GENOTYPING;
        this.HAPLOTYPE_SIZE = UAC.INDEL_HAPLOTYPE_SIZE;
        this.DEBUG = UAC.OUTPUT_DEBUG_INDEL_INFO;
        this.haplotypeMap = new LinkedHashMap();
        this.ignoreSNPAllelesWhenGenotypingIndels = UAC.IGNORE_SNP_ALLELES;
    }

    private ArrayList<Allele> computeConsensusAlleles(ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType) {
        ReadBackedExtendedEventPileup indelPileup;
        AlignmentContext context;
        Allele refAllele = null;
        Allele altAllele = null;
        GenomeLoc loc = ref.getLocus();
        ArrayList<Allele> aList = new ArrayList<Allele>();
        if (this.DEBUG) {
            System.out.println("'''''''''''''''''''''");
            System.out.println("Loc:" + loc.toString());
        }
        HashMap<String, Integer> consensusIndelStrings = new HashMap<String, Integer>();
        int insCount = 0;
        int delCount = 0;
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            indelPileup = context.getExtendedEventPileup();
            insCount += indelPileup.getNumberOfInsertions();
            delCount += indelPileup.getNumberOfDeletions();
        }
        if (insCount < this.minIndelCountForGenotyping && delCount < this.minIndelCountForGenotyping) {
            return aList;
        }
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            int dcount;
            int icount;
            context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            indelPileup = context.getExtendedEventPileup();
            for (ExtendedEventPileupElement p : indelPileup.toExtendedIterable()) {
                GATKSAMRecord read = ReadUtils.hardClipAdaptorSequence(p.getRead());
                if (read == null || ReadUtils.is454Read(read)) continue;
                if (this.DEBUG && p.isIndel()) {
                    System.out.format("Read: %s, cigar: %s, aln start: %d, aln end: %d, p.len:%d, Type:%s, EventBases:%s\n", read.getReadName(), read.getCigar().toString(), read.getAlignmentStart(), read.getAlignmentEnd(), p.getEventLength(), p.getType().toString(), p.getEventBases());
                }
                String indelString = p.getEventBases();
                if (p.isInsertion()) {
                    int cnt;
                    boolean foundKey = false;
                    if (read.getAlignmentEnd() == loc.getStart()) {
                        for (String s : consensusIndelStrings.keySet()) {
                            cnt = (Integer)consensusIndelStrings.get(s);
                            if (s.startsWith(indelString)) {
                                consensusIndelStrings.put(s, cnt + 1);
                                foundKey = true;
                                break;
                            }
                            if (!indelString.startsWith(s)) continue;
                            consensusIndelStrings.remove(s);
                            consensusIndelStrings.put(indelString, cnt + 1);
                            foundKey = true;
                            break;
                        }
                        if (foundKey) continue;
                        consensusIndelStrings.put(indelString, 1);
                        continue;
                    }
                    if (read.getAlignmentStart() == loc.getStart() + 1) {
                        for (String s : consensusIndelStrings.keySet()) {
                            cnt = (Integer)consensusIndelStrings.get(s);
                            if (s.endsWith(indelString)) {
                                consensusIndelStrings.put(s, cnt + 1);
                                foundKey = true;
                                break;
                            }
                            if (!indelString.endsWith(s)) continue;
                            consensusIndelStrings.remove(s);
                            consensusIndelStrings.put(indelString, cnt + 1);
                            foundKey = true;
                            break;
                        }
                        if (foundKey) continue;
                        consensusIndelStrings.put(indelString, 1);
                        continue;
                    }
                    int cnt2 = consensusIndelStrings.containsKey(indelString) ? (Integer)consensusIndelStrings.get(indelString) : 0;
                    consensusIndelStrings.put(indelString, cnt2 + 1);
                    continue;
                }
                if (!p.isDeletion()) continue;
                indelString = String.format("D%d", p.getEventLength());
                int cnt = consensusIndelStrings.containsKey(indelString) ? (Integer)consensusIndelStrings.get(indelString) : 0;
                consensusIndelStrings.put(indelString, cnt + 1);
            }
            if (!this.DEBUG || (icount = indelPileup.getNumberOfInsertions()) + (dcount = indelPileup.getNumberOfDeletions()) <= 0) continue;
            List<Pair<String, Integer>> eventStrings = indelPileup.getEventStringsWithCounts(ref.getBases());
            System.out.format("#ins: %d, #del:%d\n", insCount, delCount);
            for (int i = 0; i < eventStrings.size(); ++i) {
                System.out.format("%s:%d,", eventStrings.get((int)i).first, eventStrings.get((int)i).second);
            }
            System.out.println();
        }
        int maxAlleleCnt = 0;
        String bestAltAllele = "";
        for (String s : consensusIndelStrings.keySet()) {
            int curCnt = (Integer)consensusIndelStrings.get(s);
            if (curCnt > maxAlleleCnt) {
                maxAlleleCnt = curCnt;
                bestAltAllele = s;
            }
            if (!this.DEBUG) continue;
            System.out.format("Key:%s, number: %d\n", s, consensusIndelStrings.get(s));
        }
        if (maxAlleleCnt < this.minIndelCountForGenotyping) {
            return aList;
        }
        if (bestAltAllele.startsWith("D")) {
            int dLen = Integer.valueOf(bestAltAllele.substring(1));
            int startIdxInReference = 1 + loc.getStart() - ref.getWindow().getStart();
            byte[] refBases = Arrays.copyOfRange(ref.getBases(), startIdxInReference, startIdxInReference + dLen);
            if (Allele.acceptableAlleleBases(refBases)) {
                refAllele = Allele.create(refBases, true);
                altAllele = Allele.create("-", false);
            }
        } else if (Allele.acceptableAlleleBases(bestAltAllele)) {
            refAllele = Allele.create("-", true);
            altAllele = Allele.create(bestAltAllele, false);
        }
        if (refAllele != null && altAllele != null) {
            aList.add(0, refAllele);
            aList.add(1, altAllele);
        }
        return aList;
    }

    @Override
    public Allele getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenotypePriors priors, Map<String, MultiallelicGenotypeLikelihoods> GLs, Allele alternateAlleleToUse, boolean useBAQedPileup) {
        if (tracker == null) {
            return null;
        }
        GenomeLoc loc = ref.getLocus();
        VariantContext vc = null;
        if (!ref.getLocus().equals(this.lastSiteVisited)) {
            this.alleleList.clear();
            this.lastSiteVisited = ref.getLocus();
            indelLikelihoodMap.set(new HashMap());
            this.haplotypeMap.clear();
            if (this.getAlleleListFromVCF) {
                for (VariantContext vc_input : tracker.getValues(this.UAC.alleles, loc)) {
                    if (vc_input == null || !allowableTypes.contains((Object)vc_input.getType()) || ref.getLocus().getStart() != vc_input.getStart()) continue;
                    vc = vc_input;
                    break;
                }
                if (vc == null) {
                    return null;
                }
                this.alleleList.clear();
                if (this.ignoreSNPAllelesWhenGenotypingIndels) {
                    for (Allele a : vc.getAlleles()) {
                        if (a.isNonReference() && a.getBases().length == vc.getReference().getBases().length) continue;
                        this.alleleList.add(a);
                    }
                } else {
                    for (Allele a : vc.getAlleles()) {
                        this.alleleList.add(a);
                    }
                }
            } else {
                this.alleleList = this.computeConsensusAlleles(ref, contexts, contextType);
                if (this.alleleList.isEmpty()) {
                    return null;
                }
            }
        }
        if (loc.getStart() <= this.HAPLOTYPE_SIZE) {
            return null;
        }
        if (ref.getWindow().getStop() < loc.getStop() + this.HAPLOTYPE_SIZE) {
            return null;
        }
        if (!(priors instanceof DiploidIndelGenotypePriors)) {
            throw new StingException("Only diploid-based Indel priors are supported in the DINDEL GL model");
        }
        if (this.alleleList.isEmpty()) {
            return null;
        }
        Allele refAllele = this.alleleList.get(0);
        Allele altAllele = this.alleleList.get(1);
        int maxLenDiff = 0;
        for (Allele a : this.alleleList) {
            int lenDiff;
            if (!a.isNonReference() || (lenDiff = Math.abs(a.getBaseString().length() - refAllele.getBaseString().length())) <= maxLenDiff) continue;
            maxLenDiff = lenDiff;
            altAllele = a;
        }
        int eventLength = altAllele.getBaseString().length() - refAllele.getBaseString().length();
        int hsize = (int)ref.getWindow().size() - Math.abs(eventLength) - 1;
        int numPrefBases = ref.getLocus().getStart() - ref.getWindow().getStart() + 1;
        if (this.useOldWrongHorribleHackedUpLikelihoodModel) {
            numPrefBases = 20;
            hsize = 80;
        }
        if (this.DEBUG) {
            System.out.format("hsize: %d eventLength: %d refSize: %d, locStart: %d numpr: %d\n", hsize, eventLength, (int)ref.getWindow().size(), loc.getStart(), numPrefBases);
        }
        this.haplotypeMap = Haplotype.makeHaplotypeListFromAlleles(this.alleleList, loc.getStart(), ref, hsize, numPrefBases);
        GLs.clear();
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            AlignmentContext context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            ReadBackedPileup pileup = null;
            if (context.hasExtendedEventPileup()) {
                pileup = context.getExtendedEventPileup();
            } else if (context.hasBasePileup()) {
                pileup = context.getBasePileup();
            }
            if (pileup == null) continue;
            double[] genotypeLikelihoods = this.useOldWrongHorribleHackedUpLikelihoodModel ? this.model.computeReadHaplotypeLikelihoods(pileup, this.haplotypeMap) : this.pairModel.computeReadHaplotypeLikelihoods(pileup, this.haplotypeMap, ref, eventLength, IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap());
            GLs.put(sample.getKey(), new MultiallelicGenotypeLikelihoods(sample.getKey(), this.alleleList, genotypeLikelihoods, this.getFilteredDepth(pileup)));
            if (!this.DEBUG) continue;
            System.out.format("Sample:%s Alleles:%s GL:", sample.getKey(), this.alleleList.toString());
            for (int k = 0; k < genotypeLikelihoods.length; ++k) {
                System.out.format("%1.4f ", genotypeLikelihoods[k]);
            }
            System.out.println();
        }
        return refAllele;
    }

    public static HashMap<PileupElement, LinkedHashMap<Allele, Double>> getIndelLikelihoodMap() {
        return indelLikelihoodMap.get();
    }

    @Override
    protected int getFilteredDepth(ReadBackedPileup pileup) {
        int count = 0;
        for (PileupElement p : pileup) {
            if (!p.isDeletion() && !BaseUtils.isRegularBase(p.getBase())) continue;
            ++count;
        }
        return count;
    }

    static {
        indelLikelihoodMap.set(new HashMap());
        allowableTypes = EnumSet.of(VariantContext.Type.INDEL, VariantContext.Type.MIXED);
    }
}

