/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class GridSearchAFEstimation
extends AlleleFrequencyCalculationModel {
    protected static final double LOG10_OPTIMIZATION_EPSILON = 8.0;
    private AlleleFrequencyMatrix AFMatrix;

    protected GridSearchAFEstimation(UnifiedArgumentCollection UAC, int N, Logger logger, PrintStream verboseWriter) {
        super(UAC, N, logger, verboseWriter);
        this.AFMatrix = new AlleleFrequencyMatrix(N);
    }

    @Override
    protected void getLog10PNonRef(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, Genotype> GLs, Set<Allele> alleles, double[] log10AlleleFrequencyPriors, double[] log10AlleleFrequencyPosteriors) {
        this.initializeAFMatrix(GLs);
        log10AlleleFrequencyPosteriors[0] = this.AFMatrix.getLikelihoodsOfFrequency() + log10AlleleFrequencyPriors[0];
        double maxLikelihoodSeen = log10AlleleFrequencyPosteriors[0];
        int maxAlleleFrequencyToTest = this.AFMatrix.getSamples().size() * 2;
        for (int i = 1; i <= maxAlleleFrequencyToTest; ++i) {
            this.AFMatrix.incrementFrequency();
            log10AlleleFrequencyPosteriors[i] = this.AFMatrix.getLikelihoodsOfFrequency() + log10AlleleFrequencyPriors[i];
            if (maxLikelihoodSeen - log10AlleleFrequencyPosteriors[i] > 8.0) {
                return;
            }
            if (!(log10AlleleFrequencyPosteriors[i] > maxLikelihoodSeen)) continue;
            maxLikelihoodSeen = log10AlleleFrequencyPosteriors[i];
        }
    }

    @Override
    protected Map<String, Genotype> assignGenotypes(VariantContext vc, double[] log10AlleleFrequencyPosteriors, int AFofMaxLikelihood) {
        if (!vc.isVariant()) {
            throw new UserException("The VCF record passed in does not contain an ALT allele at " + vc.getChr() + ":" + vc.getStart());
        }
        Allele refAllele = vc.getReference();
        Allele altAllele = vc.getAlternateAllele(0);
        HashMap<String, Genotype> calls = new HashMap<String, Genotype>();
        for (String sample : this.AFMatrix.getSamples()) {
            Genotype g = vc.getGenotype(sample);
            Pair<Integer, Double> AFbasedGenotype = this.AFMatrix.getGenotype(AFofMaxLikelihood, sample);
            ArrayList<Allele> myAlleles = new ArrayList<Allele>();
            if (((Integer)AFbasedGenotype.first).intValue() == AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal()) {
                myAlleles.add(refAllele);
                myAlleles.add(refAllele);
            } else if (((Integer)AFbasedGenotype.first).intValue() == AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()) {
                myAlleles.add(refAllele);
                myAlleles.add(altAllele);
            } else {
                myAlleles.add(altAllele);
                myAlleles.add(altAllele);
            }
            calls.put(sample, new Genotype(sample, myAlleles, (Double)AFbasedGenotype.second, null, g.getAttributes(), false));
        }
        return calls;
    }

    private void initializeAFMatrix(Map<String, Genotype> GLs) {
        this.AFMatrix.clear();
        for (Genotype g : GLs.values()) {
            if (!g.hasLikelihoods()) continue;
            this.AFMatrix.setLikelihoods(g.getLikelihoods().getAsVector(), g.getSampleName());
        }
    }

    protected static class AlleleFrequencyMatrix {
        private double[][] matrix;
        private int[] indexes;
        private int maxN;
        private int frequency;
        private ArrayList<String> samples = new ArrayList();
        private HashMap<Integer, HashMap<String, Pair<Integer, Double>>> samplesToGenotypesPerAF = new HashMap();

        public AlleleFrequencyMatrix(int N) {
            this.maxN = N;
            this.matrix = new double[N][3];
            this.indexes = new int[N];
            this.clear();
        }

        public List<String> getSamples() {
            return this.samples;
        }

        public void clear() {
            this.frequency = 0;
            for (int i = 0; i < this.maxN; ++i) {
                this.indexes[i] = 0;
            }
            this.samples.clear();
            this.samplesToGenotypesPerAF.clear();
        }

        public void setLikelihoods(double[] GLs, String sample) {
            int index = this.samples.size();
            this.samples.add(sample);
            this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal()] = GLs[0];
            this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()] = GLs[1];
            this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.BB.ordinal()] = GLs[2];
        }

        public void incrementFrequency() {
            int N = this.samples.size();
            if (this.frequency == 2 * N) {
                throw new ReviewedStingException("Frequency was incremented past N; how is this possible?");
            }
            ++this.frequency;
            double greedy = -1.7976931348623157E308;
            int greedyIndex = -1;
            for (int i = 0; i < N; ++i) {
                if (this.indexes[i] == AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()) {
                    if (!(this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.BB.ordinal()] - this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()] > greedy)) continue;
                    greedy = this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.BB.ordinal()] - this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()];
                    greedyIndex = i;
                    continue;
                }
                if (this.indexes[i] != AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal() || !(this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()] - this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal()] > greedy)) continue;
                greedy = this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()] - this.matrix[i][AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal()];
                greedyIndex = i;
            }
            if (greedyIndex == -1) {
                throw new ReviewedStingException("There is no best choice for a new alternate allele; how is this possible?");
            }
            this.indexes[greedyIndex] = this.indexes[greedyIndex] == AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal() ? AlleleFrequencyCalculationModel.GenotypeType.BB.ordinal() : AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal();
        }

        public double getLikelihoodsOfFrequency() {
            double likelihoods = 0.0;
            int N = this.samples.size();
            for (int i = 0; i < N; ++i) {
                likelihoods += this.matrix[i][this.indexes[i]];
            }
            this.recordGenotypes();
            return likelihoods;
        }

        public Pair<Integer, Double> getGenotype(int frequency, String sample) {
            return this.samplesToGenotypesPerAF.get(frequency).get(sample);
        }

        private void recordGenotypes() {
            HashMap<String, Pair<Integer, Double>> samplesToGenotypes = new HashMap<String, Pair<Integer, Double>>();
            int index = 0;
            for (String sample : this.samples) {
                double score;
                int genotype = this.indexes[index];
                int maxEntry = MathUtils.maxElementIndex(this.matrix[index]);
                if (genotype == maxEntry) {
                    score = genotype == AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal() ? this.matrix[index][genotype] - Math.max(this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()], this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.BB.ordinal()]) : (genotype == AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal() ? this.matrix[index][genotype] - Math.max(this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal()], this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.BB.ordinal()]) : this.matrix[index][genotype] - Math.max(this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.AA.ordinal()], this.matrix[index][AlleleFrequencyCalculationModel.GenotypeType.AB.ordinal()]));
                } else {
                    double[] normalized = MathUtils.normalizeFromLog10(this.matrix[index]);
                    double chosenGenotype = normalized[genotype];
                    score = -1.0 * Math.log10(1.0 - chosenGenotype);
                }
                samplesToGenotypes.put(sample, new Pair<Integer, Double>(genotype, Math.abs(score)));
                ++index;
            }
            this.samplesToGenotypesPerAF.put(this.frequency, samplesToGenotypes);
        }
    }
}

