/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffEngine;
import org.broadinstitute.sting.gatk.walkers.diffengine.Difference;

public class DiffObjectsWalker
extends RodWalker<Integer, Integer> {
    @Output(doc="File to which results should be written", required=true)
    protected PrintStream out;
    @Argument(fullName="master", shortName="m", doc="Master file: expected results", required=true)
    File masterFile;
    @Argument(fullName="test", shortName="t", doc="Test file: new results to compare to the master file", required=true)
    File testFile;
    @Argument(fullName="maxObjectsToRead", shortName="motr", doc="Max. number of objects to read from the files.  -1 [default] means unlimited", required=false)
    int MAX_OBJECTS_TO_READ = -1;
    @Argument(fullName="maxDiffs", shortName="M", doc="Max. number of diffs to process", required=false)
    int MAX_DIFFS = 0;
    @Argument(fullName="maxCount1Diffs", shortName="M1", doc="Max. number of diffs occuring exactly once in the file to process", required=false)
    int MAX_COUNT1_DIFFS = 0;
    @Argument(fullName="minCountForDiff", shortName="MCFD", doc="Min number of observations for a records to display", required=false)
    int minCountForDiff = 1;
    @Argument(fullName="showItemizedDifferences", shortName="SID", doc="Should we enumerate all differences between the files?", required=false)
    boolean showItemizedDifferences = false;
    DiffEngine diffEngine;

    @Override
    public void initialize() {
        this.diffEngine = new DiffEngine();
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        this.out.printf("Reading master file %s%n", this.masterFile);
        DiffElement master = this.diffEngine.createDiffableFromFile(this.masterFile, this.MAX_OBJECTS_TO_READ);
        this.out.printf("  Read %d objects%n", master.size());
        this.out.printf("Reading test file %s%n", this.testFile);
        DiffElement test = this.diffEngine.createDiffableFromFile(this.testFile, this.MAX_OBJECTS_TO_READ);
        this.out.printf("  Read %d objects%n", test.size());
        List<Difference> diffs = this.diffEngine.diff(master, test);
        if (this.showItemizedDifferences) {
            this.out.printf("Itemized results%n", new Object[0]);
            for (Difference diff : diffs) {
                this.out.printf("DIFF: %s%n", diff.toString());
            }
        }
        DiffEngine.SummaryReportParams params = new DiffEngine.SummaryReportParams(this.out, this.MAX_DIFFS, this.MAX_COUNT1_DIFFS, this.minCountForDiff);
        params.setDescending(false);
        this.diffEngine.reportSummarizedDifferences(diffs, params);
    }
}

