/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.Multiplexer;
import org.broadinstitute.sting.gatk.walkers.coverage.DoCOutputType;

class DoCOutputMultiplexer
implements Multiplexer<DoCOutputType> {
    private final Set<DoCOutputType.Partition> partitions;
    private final File refSeqGeneList;
    private final boolean omitDepthOutput;
    private final boolean omitIntervals;
    private final boolean omitSampleSummary;
    private final boolean omitLocusTable;

    public DoCOutputMultiplexer(Set<DoCOutputType.Partition> partitions, File refSeqGeneList, boolean omitDepthOutput, boolean omitIntervals, boolean omitSampleSummary, boolean omitLocusTable) {
        this.partitions = partitions;
        this.refSeqGeneList = refSeqGeneList;
        this.omitDepthOutput = omitDepthOutput;
        this.omitIntervals = omitIntervals;
        this.omitSampleSummary = omitSampleSummary;
        this.omitLocusTable = omitLocusTable;
    }

    @Override
    public Collection<DoCOutputType> multiplex() {
        ArrayList<DoCOutputType> outputs = new ArrayList<DoCOutputType>();
        if (!this.omitDepthOutput) {
            outputs.add(new DoCOutputType(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary));
        }
        if (!this.omitIntervals) {
            for (DoCOutputType.Partition partition : this.partitions) {
                outputs.add(new DoCOutputType(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.summary));
                outputs.add(new DoCOutputType(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.statistics));
            }
        }
        if (this.refSeqGeneList != null && this.partitions.contains((Object)DoCOutputType.Partition.sample)) {
            DoCOutputType geneSummaryOut = new DoCOutputType(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.summary);
            outputs.add(geneSummaryOut);
        }
        if (!this.omitSampleSummary) {
            for (DoCOutputType.Partition partition : this.partitions) {
                outputs.add(new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.summary));
                outputs.add(new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.statistics));
            }
        }
        if (!this.omitLocusTable) {
            for (DoCOutputType.Partition partition : this.partitions) {
                outputs.add(new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_counts));
                outputs.add(new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_proportions));
            }
        }
        return outputs;
    }

    @Override
    public String transformArgument(DoCOutputType outputType, String argument) {
        return outputType.getFileName(argument);
    }
}

