/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.broad.tribble.bed.BEDFeature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.coverage.CallableLociWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class CompareCallableLociWalker
extends RodWalker<List<CallableLociWalker.CallableBaseState>, long[][]> {
    @Output
    protected PrintStream out;
    @Input(fullName="comp1", shortName="comp1", doc="First comparison track name", required=true)
    public RodBinding<BEDFeature> compTrack1;
    @Input(fullName="comp2", shortName="comp2", doc="Second comparison track name", required=true)
    public RodBinding<BEDFeature> compTrack2;
    @Argument(shortName="printState", doc="If provided, prints sites satisfying this state pair", required=false)
    protected String printState = null;
    CallableLociWalker.CalledState printState1 = CallableLociWalker.CalledState.REF_N;
    CallableLociWalker.CalledState printState2 = CallableLociWalker.CalledState.REF_N;

    @Override
    public void initialize() {
        if (this.printState != null) {
            String[] states = this.printState.split(",");
            this.printState1 = CallableLociWalker.CalledState.valueOf(states[0]);
            this.printState2 = CallableLociWalker.CalledState.valueOf(states[1]);
        }
    }

    @Override
    public List<CallableLociWalker.CallableBaseState> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker != null) {
            CallableLociWalker.CallableBaseState comp1 = this.getCallableBaseState(tracker, this.compTrack1);
            CallableLociWalker.CallableBaseState comp2 = this.getCallableBaseState(tracker, this.compTrack2);
            if (this.printState != null && comp1.getState() == this.printState1 && comp2.getState() == this.printState2) {
                this.out.printf("%s %s %s %s%n", new Object[]{comp1.getLocation(), comp1.getState(), comp2.getLocation(), comp2.getState()});
            }
            return Arrays.asList(comp1, comp2);
        }
        return null;
    }

    private CallableLociWalker.CallableBaseState getCallableBaseState(RefMetaDataTracker tracker, RodBinding<BEDFeature> rodBinding) {
        List<BEDFeature> bindings = tracker.getValues(rodBinding);
        if (bindings.size() != 1) {
            throw new UserException.MalformedFile(String.format("%s track isn't a properly formated CallableBases object!", rodBinding.getName()));
        }
        BEDFeature bed = bindings.get(0);
        GenomeLoc loc = this.getToolkit().getGenomeLocParser().createGenomeLoc(bed.getChr(), bed.getStart(), bed.getEnd());
        CallableLociWalker.CalledState state = CallableLociWalker.CalledState.valueOf(bed.getName());
        return new CallableLociWalker.CallableBaseState(this.getToolkit().getGenomeLocParser(), loc, state);
    }

    @Override
    public long[][] reduceInit() {
        int n = CallableLociWalker.CalledState.values().length;
        return new long[n][n];
    }

    @Override
    public long[][] reduce(List<CallableLociWalker.CallableBaseState> comps, long[][] sum) {
        if (comps != null) {
            CallableLociWalker.CallableBaseState comp1 = comps.get(0);
            CallableLociWalker.CallableBaseState comp2 = comps.get(1);
            long[] lArray = sum[comp1.getState().ordinal()];
            int n = comp2.getState().ordinal();
            lArray[n] = lArray[n] + 1L;
        }
        return sum;
    }

    @Override
    public void onTraversalDone(long[][] result) {
        for (CallableLociWalker.CalledState state1 : CallableLociWalker.CalledState.values()) {
            for (CallableLociWalker.CalledState state2 : CallableLociWalker.CalledState.values()) {
                this.out.printf("%s %s %s %s %d%n", new Object[]{this.compTrack1.getName(), this.compTrack2.getName(), state1, state2, result[state1.ordinal()][state2.ordinal()]});
            }
        }
    }
}

