/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.io.PrintStream;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;

public class CoarseCoverageWalker
extends ReadWalker<Integer, Integer> {
    @Output
    public PrintStream out;
    @Argument(fullName="granularity", shortName="G", doc="Granularity", required=true)
    public Integer N;
    @Argument(fullName="dontZeroMissingContigs", shortName="Z", doc="If provided, we won't emit 0 counts for all sites on contigs skipped", required=true)
    public boolean dontZeroMissingContigs;
    private int chunkStart = 1;
    private int contig = 0;
    private int count = 0;
    private static String zeroString = "0";

    @Override
    public void initialize() {
        this.chunkStart = 1;
        this.contig = 0;
        this.count = 0;
    }

    @Override
    public Integer map(ReferenceContext ref, SAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (read.getReadUnmappedFlag() || read.getDuplicateReadFlag() || read.getNotPrimaryAlignmentFlag() || read.getMappingQuality() == 0) {
            return 0;
        }
        if (read.getReferenceIndex() != this.contig) {
            this.out.printf("%d%n", this.count);
            this.count = 0;
            ++this.contig;
            while (this.contig < read.getReferenceIndex()) {
                if (!this.dontZeroMissingContigs) {
                    int contigSize = read.getHeader().getSequence(this.contig).getSequenceLength();
                    for (int k = 1; k < contigSize; k += this.N.intValue()) {
                        this.out.println(zeroString);
                    }
                }
                ++this.contig;
            }
            this.chunkStart = 1;
        }
        while (this.chunkStart + this.N < read.getAlignmentStart()) {
            this.out.printf("%d%n", this.count);
            this.count = 0;
            this.chunkStart += this.N.intValue();
        }
        ++this.count;
        return 1;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.printf("%d%n", this.count);
        super.onTraversalDone(result);
    }
}

