/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.ReadBasedReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReadReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.ReadShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadView;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.GenomeLoc;

public class TraverseReads<M, T>
extends TraversalEngine<M, T, ReadWalker<M, T>, ReadShardDataProvider> {
    protected static Logger logger = Logger.getLogger(TraverseReads.class);

    @Override
    protected String getTraversalType() {
        return "reads";
    }

    @Override
    public T traverse(ReadWalker<M, T> walker, ReadShardDataProvider dataProvider, T sum) {
        logger.debug(String.format("TraverseReads.traverse Covered dataset is %s", dataProvider));
        if (!dataProvider.hasReads()) {
            throw new IllegalArgumentException("Unable to traverse reads; no read data is available.");
        }
        boolean needsReferenceBasesP = WalkerManager.isRequired(walker, DataSource.REFERENCE_BASES);
        ReadView reads = new ReadView(dataProvider);
        ReadReferenceView reference = new ReadReferenceView(dataProvider);
        ReadBasedReferenceOrderedView rodView = new ReadBasedReferenceOrderedView(dataProvider);
        boolean done = walker.isDone();
        for (SAMRecord read : reads) {
            if (done) break;
            ReferenceContext refContext = null;
            if (needsReferenceBasesP && !read.getReadUnmappedFlag() && dataProvider.hasReference()) {
                refContext = reference.getReferenceContext(read);
            }
            ReadMetrics readMetrics = dataProvider.getShard().getReadMetrics();
            readMetrics.incrementNumIterations();
            ReadMetaDataTracker tracker = read.getReferenceIndex() >= 0 ? rodView.getReferenceOrderedDataForRead(read) : null;
            boolean keepMeP = walker.filter(refContext, read);
            if (keepMeP) {
                M x = walker.map(refContext, read, tracker);
                sum = walker.reduce(x, sum);
            }
            GenomeLoc locus = read.getReferenceIndex() == -1 ? null : this.engine.getGenomeLocParser().createGenomeLoc(read.getReferenceName(), read.getAlignmentStart());
            this.printProgress(dataProvider.getShard(), locus);
            done = walker.isDone();
        }
        return sum;
    }
}

