/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.util.TreeMap;

public class GATKReportColumn
extends TreeMap<Object, Object> {
    private String columnName;
    private Object defaultValue;
    private boolean display;

    public GATKReportColumn(String columnName, Object defaultValue, boolean display) {
        this.columnName = columnName;
        this.defaultValue = defaultValue;
        this.display = display;
    }

    public void initialize(Object primaryKey) {
        this.put(primaryKey, this.defaultValue);
    }

    private Object getWithoutSideEffects(Object primaryKey) {
        if (!this.containsKey(primaryKey)) {
            return this.defaultValue;
        }
        return this.get(primaryKey);
    }

    public String getStringValue(Object primaryKey) {
        return GATKReportColumn.toString(this.getWithoutSideEffects(primaryKey));
    }

    public boolean isDisplayable() {
        return this.display;
    }

    public int getColumnWidth() {
        int maxWidth = this.columnName.length();
        for (Object obj : this.values()) {
            int width;
            if (obj == null || (width = GATKReportColumn.toString(obj).length()) <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private static String toString(Object obj) {
        String value = obj == null ? "null" : (obj instanceof Float ? String.format("%.8f", (Float)obj) : (obj instanceof Double ? String.format("%.8f", (Double)obj) : obj.toString()));
        return value;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

