/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;

public class RMDIntervalGenerator {
    public ReferenceOrderedDataSource dataSource;

    public RMDIntervalGenerator(ReferenceOrderedDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Data source cannot be null");
        }
        this.dataSource = dataSource;
    }

    public List<GenomeLoc> toGenomeLocList() {
        LocationAwareSeekableRODIterator iter = this.dataSource.seek((GenomeLoc)null);
        ArrayList<GenomeLoc> locations = new ArrayList<GenomeLoc>();
        while (iter.hasNext()) {
            RODRecordList feature = (RODRecordList)iter.next();
            GenomeLoc loc = feature.getLocation();
            if (loc == null) continue;
            locations.add(loc);
        }
        return locations;
    }

    public static Map<String, ReferenceOrderedDataSource> getRMDTrackNames(List<ReferenceOrderedDataSource> sources) {
        HashMap<String, ReferenceOrderedDataSource> rodNames = new HashMap<String, ReferenceOrderedDataSource>();
        for (ReferenceOrderedDataSource rod : sources) {
            rodNames.put(rod.getName(), rod);
        }
        return rodNames;
    }
}

