/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.sample;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.utils.exceptions.StingException;

public class Sample
implements Serializable {
    private final String id;
    private boolean hasSampleFileEntry = false;
    private boolean hasSAMFileEntry = false;
    private HashMap<String, Object> properties = new HashMap();
    private HashMap<String, Sample> relationships = new HashMap();

    public Sample(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = (HashMap)properties;
    }

    public Map<String, Sample> getRelationships() {
        return Collections.unmodifiableMap(this.relationships);
    }

    public void setSampleFileEntry(boolean value) {
        this.hasSampleFileEntry = value;
    }

    public boolean hasSAMFileEntry() {
        return this.hasSAMFileEntry;
    }

    public void setSAMFileEntry(boolean value) {
        this.hasSAMFileEntry = value;
    }

    public boolean hasSampleFileEntry() {
        return this.hasSampleFileEntry;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (this.relationships.containsKey(key)) {
            throw new StingException("The same key cannot exist as a property and a relationship");
        }
        if (key.equals("gender") && value.getClass() != Gender.class) {
            throw new StingException("'gender' property must be of type Sample.Gender");
        }
        if (key.equals("population") && value.getClass() != String.class) {
            throw new StingException("'population' property must be of type String");
        }
        this.properties.put(key, value);
    }

    public Sample getRelationship(String key) {
        return this.relationships.get(key);
    }

    public void setRelationship(String key, Sample value) {
        if (this.properties.containsKey(key)) {
            throw new StingException("The same key cannot exist as a property and a relationship");
        }
        this.relationships.put(key, value);
    }

    public Sample getMother() {
        return this.getRelationship("mother");
    }

    public Sample getFather() {
        return this.getRelationship("father");
    }

    public Gender getGender() {
        return (Gender)((Object)this.properties.get("gender"));
    }

    public String getPopulation() {
        return (String)this.properties.get("population");
    }

    public String getFamilyId() {
        return (String)this.properties.get("familyId");
    }

    public boolean isMale() {
        return this.properties.get("gender") == Gender.MALE;
    }

    public boolean isFemale() {
        return this.properties.get("gender") == Gender.MALE;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sample sample = (Sample)o;
        if (this.hasSAMFileEntry != sample.hasSAMFileEntry) {
            return false;
        }
        if (this.hasSampleFileEntry != sample.hasSampleFileEntry) {
            return false;
        }
        if (this.id != null ? !this.id.equals(sample.id) : sample.id != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(sample.properties) : sample.properties != null) {
            return false;
        }
        return !(this.relationships != null ? !this.relationships.equals(sample.relationships) : sample.relationships != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : "".hashCode();
    }

    public static enum Gender {
        MALE,
        FEMALE,
        UNKNOWN;

    }
}

