/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import net.sf.samtools.Bin;
import net.sf.samtools.BrowseableBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;

class ReaderBin {
    public final SAMReaderID id;
    public final BrowseableBAMIndex index;
    public final int referenceSequence;
    public final Bin bin;

    public ReaderBin(SAMReaderID id, BrowseableBAMIndex index, int referenceSequence, Bin bin) {
        this.id = id;
        this.index = index;
        this.referenceSequence = referenceSequence;
        this.bin = bin;
    }

    public int getStart() {
        return this.index.getFirstLocusInBin(this.bin);
    }

    public int getStop() {
        return this.index.getLastLocusInBin(this.bin);
    }
}

