/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.Iterator;
import net.sf.picard.util.PeekableIterator;
import org.broadinstitute.sting.gatk.datasources.reads.BAMScheduler;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class LowMemoryIntervalSharder
implements Iterator<FilePointer> {
    private final PeekableIterator<FilePointer> wrappedIterator;
    private final GenomeLocParser parser;

    public LowMemoryIntervalSharder(SAMDataSource dataSource, GenomeLocSortedSet loci) {
        this.wrappedIterator = new PeekableIterator<FilePointer>(new BAMScheduler(dataSource, loci));
        this.parser = loci.getGenomeLocParser();
    }

    @Override
    public boolean hasNext() {
        return this.wrappedIterator.hasNext();
    }

    @Override
    public FilePointer next() {
        FilePointer current = this.wrappedIterator.next();
        while (this.wrappedIterator.hasNext() && current.minus(this.wrappedIterator.peek()) == 0L) {
            current = current.combine(this.parser, this.wrappedIterator.next());
        }
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unable to remove from an interval sharder.");
    }
}

