/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.CommandLineUtils;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.arguments.GATKArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.MonolithicShardStrategy;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategy;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategyFactory;
import org.broadinstitute.sting.gatk.datasources.reference.ReferenceDataSource;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.datasources.sample.Sample;
import org.broadinstitute.sting.gatk.datasources.sample.SampleDataSource;
import org.broadinstitute.sting.gatk.executive.MicroScheduler;
import org.broadinstitute.sting.gatk.filters.FilterManager;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.filters.ReadGroupBlackListFilter;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.RMDIntervalGenerator;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.DuplicateWalker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.SequenceDictionaryUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class GenomeAnalysisEngine {
    private static Logger logger = Logger.getLogger(GenomeAnalysisEngine.class);
    private ParsingEngine parsingEngine;
    private GenomeLocParser genomeLocParser;
    private SAMDataSource readsDataSource = null;
    private ReferenceDataSource referenceDataSource = null;
    private SampleDataSource sampleDataSource = null;
    private List<ReferenceOrderedDataSource> rodDataSources;
    private GATKArgumentCollection argCollection;
    private GenomeLocSortedSet intervals = null;
    private Map<ArgumentSource, Object> inputs = new HashMap<ArgumentSource, Object>();
    private Collection<Stub<?>> outputs = new ArrayList();
    private Collection<ReadFilter> filters;
    private String myName = "GATK_" + Math.abs(GenomeAnalysisEngine.getRandomGenerator().nextInt());
    private final WalkerManager walkerManager = new WalkerManager();
    private Walker<?, ?> walker;
    private Collection<SAMReaderID> samReaderIDs = Collections.emptyList();
    private Collection<RMDTriplet> referenceMetaDataFiles;
    private static final long GATK_RANDOM_SEED = 47382911L;
    private static Random randomGenerator = new Random(47382911L);
    private final FilterManager filterManager = new FilterManager();
    private Date startTime = null;

    public void setIntervals(GenomeLocSortedSet intervals) {
        this.intervals = intervals;
    }

    public void setWalker(Walker<?, ?> walker) {
        this.walker = walker;
    }

    public void setSAMFileIDs(Collection<SAMReaderID> samReaderIDs) {
        this.samReaderIDs = samReaderIDs;
    }

    public void setReferenceMetaDataFiles(Collection<RMDTriplet> referenceMetaDataFiles) {
        this.referenceMetaDataFiles = referenceMetaDataFiles;
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public static void resetRandomGenerator() {
        randomGenerator.setSeed(47382911L);
    }

    public static void resetRandomGenerator(long seed) {
        randomGenerator.setSeed(seed);
    }

    public Object execute() {
        this.setStartTime(new Date());
        if (this.getArguments() == null) {
            throw new ReviewedStingException("The GATKArgumentCollection passed to GenomeAnalysisEngine can not be null.");
        }
        if (this.walker == null) {
            throw new ReviewedStingException("The walker passed to GenomeAnalysisEngine can not be null.");
        }
        if (this.getArguments().nonDeterministicRandomSeed) {
            GenomeAnalysisEngine.resetRandomGenerator(System.currentTimeMillis());
        }
        this.initializeDataSources();
        this.initializeIntervals();
        this.validateSuppliedIntervals();
        MicroScheduler microScheduler = this.createMicroscheduler();
        this.initializeTempDirectory();
        this.initializeOutputStreams(microScheduler.getOutputTracker());
        ShardStrategy shardStrategy = this.getShardStrategy(this.readsDataSource, microScheduler.getReference(), this.intervals);
        Object result = microScheduler.execute(this.walker, shardStrategy);
        return result;
    }

    public Walker<?, ?> getWalkerByName(String walkerName) {
        return (Walker)this.walkerManager.createByName(walkerName);
    }

    public String getWalkerName(Class<? extends Walker> walkerType) {
        return this.walkerManager.getName(walkerType);
    }

    public String getName() {
        return this.myName;
    }

    public Collection<ReadFilter> createFilters() {
        HashSet<ReadFilter> filters = new HashSet<ReadFilter>();
        filters.addAll(WalkerManager.getReadFilters(this.walker, this.getFilterManager()));
        if (this.getArguments().readGroupBlackList != null && this.getArguments().readGroupBlackList.size() > 0) {
            filters.add(new ReadGroupBlackListFilter(this.getArguments().readGroupBlackList));
        }
        for (String filterName : this.getArguments().readFilters) {
            filters.add((ReadFilter)this.getFilterManager().createByName(filterName));
        }
        return Collections.unmodifiableSet(filters);
    }

    protected WalkerManager getWalkerManager() {
        return this.walkerManager;
    }

    private MicroScheduler createMicroscheduler() {
        if ((this.walker instanceof ReadWalker || this.walker instanceof DuplicateWalker || this.walker instanceof ReadPairWalker) && this.getArguments().referenceFile == null) {
            throw new UserException.CommandLineException("Read-based traversals require a reference file but none was given");
        }
        return MicroScheduler.create(this, this.walker, this.getReadsDataSource(), this.getReferenceDataSource().getReference(), this.getRodDataSources(), this.getArguments().numberOfThreads);
    }

    protected DownsamplingMethod getDownsamplingMethod() {
        GATKArgumentCollection argCollection = this.getArguments();
        DownsamplingMethod method = argCollection.getDownsamplingMethod() != null ? argCollection.getDownsamplingMethod() : (WalkerManager.getDownsamplingMethod(this.walker) != null ? WalkerManager.getDownsamplingMethod(this.walker) : argCollection.getDefaultDownsamplingMethod());
        return method;
    }

    public BAQ.QualityMode getWalkerBAQQualityMode() {
        return WalkerManager.getBAQQualityMode(this.walker);
    }

    public BAQ.ApplicationTime getWalkerBAQApplicationTime() {
        return WalkerManager.getBAQApplicationTime(this.walker);
    }

    protected boolean generateExtendedEvents() {
        return this.walker.generateExtendedEvents();
    }

    protected boolean includeReadsWithDeletionAtLoci() {
        return this.walker.includeReadsWithDeletionAtLoci();
    }

    protected void validateSuppliedReads() {
        GATKArgumentCollection arguments = this.getArguments();
        if (WalkerManager.isRequired(this.walker, DataSource.READS) && (arguments.samFiles == null || arguments.samFiles.size() == 0)) {
            throw new ArgumentException("Walker requires reads but none were provided.");
        }
        if (arguments.samFiles != null && arguments.samFiles.size() > 0 && !WalkerManager.isAllowed(this.walker, DataSource.READS)) {
            throw new ArgumentException("Walker does not allow reads but reads were provided.");
        }
        this.checkForDuplicateSamFiles();
    }

    protected void checkForDuplicateSamFiles() {
        HashSet<SAMReaderID> encounteredSamFiles = new HashSet<SAMReaderID>();
        LinkedHashSet<String> duplicateSamFiles = new LinkedHashSet<String>();
        for (SAMReaderID samFile : this.samReaderIDs) {
            if (encounteredSamFiles.contains(samFile)) {
                duplicateSamFiles.add(samFile.getSamFilePath());
                continue;
            }
            encounteredSamFiles.add(samFile);
        }
        if (duplicateSamFiles.size() > 0) {
            throw new ArgumentException("The following BAM files appear multiple times in the list of input files: " + duplicateSamFiles + " BAM files may be specified at most once.");
        }
    }

    protected void validateSuppliedReference() {
        GATKArgumentCollection arguments = this.getArguments();
        if (arguments.referenceFile == null) {
            throw new ArgumentException("Walker requires a reference but none was provided.");
        }
        if (arguments.referenceFile != null && !WalkerManager.isAllowed(this.walker, DataSource.REFERENCE)) {
            throw new ArgumentException("Walker does not allow a reference but one was provided.");
        }
    }

    protected void validateSuppliedIntervals() {
        GenomeLocSortedSet intervals;
        if (!(this.walker instanceof ReadWalker) && (intervals = this.getIntervals()) != null && this.getIntervals().contains(GenomeLoc.UNMAPPED)) {
            throw new ArgumentException("Interval list specifies unmapped region.  Only read walkers may include the unmapped region.");
        }
        if (this.intervals != null && this.intervals.isEmpty()) {
            throw new ArgumentException("The given combination of -L and -XL options results in an empty set. No intervals to process.");
        }
    }

    protected ShardStrategy getShardStrategy(SAMDataSource readsDataSource, ReferenceSequenceFile drivingDataSource, GenomeLocSortedSet intervals) {
        ValidationExclusion exclusions = readsDataSource != null ? readsDataSource.getReadsInfo().getValidationExclusionList() : null;
        ReferenceDataSource referenceDataSource = this.getReferenceDataSource();
        if (readsDataSource != null && !readsDataSource.hasIndex()) {
            List<GenomeLoc> region;
            Shard.ShardType shardType;
            if (!exclusions.contains(ValidationExclusion.TYPE.ALLOW_UNINDEXED_BAM)) {
                throw new UserException.CommandLineException("Cannot process the provided BAM file(s) because they were not indexed.  The GATK does offer limited processing of unindexed BAMs in --unsafe mode, but this GATK feature is currently unsupported.");
            }
            if (intervals != null && !this.argCollection.allowIntervalsWithUnindexedBAM) {
                throw new UserException.CommandLineException("Cannot perform interval processing when reads are present but no index is available.");
            }
            if (this.walker instanceof LocusWalker) {
                if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                    throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, "Locus walkers can only traverse coordinate-sorted data.  Please resort your input BAM file(s) or set the Sort Order tag in the header appropriately.");
                }
                shardType = Shard.ShardType.LOCUS;
            } else if (this.walker instanceof ReadWalker || this.walker instanceof DuplicateWalker || this.walker instanceof ReadPairWalker) {
                shardType = Shard.ShardType.READ;
            } else {
                throw new UserException.CommandLineException("The GATK cannot currently process unindexed BAM files");
            }
            if (intervals != null) {
                region = intervals.toList();
            } else {
                region = new ArrayList<GenomeLoc>();
                for (SAMSequenceRecord sequenceRecord : drivingDataSource.getSequenceDictionary().getSequences()) {
                    region.add(this.getGenomeLocParser().createGenomeLoc(sequenceRecord.getSequenceName(), 1, sequenceRecord.getSequenceLength()));
                }
            }
            return new MonolithicShardStrategy(this.getGenomeLocParser(), readsDataSource, shardType, region);
        }
        ShardStrategy shardStrategy = null;
        long SHARD_SIZE = 100000L;
        if (this.walker instanceof LocusWalker) {
            if (this.walker instanceof RodWalker) {
                SHARD_SIZE *= 1000L;
            }
            if (intervals != null && !intervals.isEmpty()) {
                if (!readsDataSource.isEmpty() && readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                    throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, "Locus walkers can only traverse coordinate-sorted data.  Please resort your input BAM file(s) or set the Sort Order tag in the header appropriately.");
                }
                shardStrategy = ShardStrategyFactory.shatter(readsDataSource, referenceDataSource.getReference(), ShardStrategyFactory.SHATTER_STRATEGY.LOCUS_EXPERIMENTAL, drivingDataSource.getSequenceDictionary(), SHARD_SIZE, this.getGenomeLocParser(), intervals);
            } else {
                shardStrategy = ShardStrategyFactory.shatter(readsDataSource, referenceDataSource.getReference(), ShardStrategyFactory.SHATTER_STRATEGY.LOCUS_EXPERIMENTAL, drivingDataSource.getSequenceDictionary(), SHARD_SIZE, this.getGenomeLocParser());
            }
        } else if (this.walker instanceof ReadWalker || this.walker instanceof DuplicateWalker) {
            ShardStrategyFactory.SHATTER_STRATEGY shardType = ShardStrategyFactory.SHATTER_STRATEGY.READS_EXPERIMENTAL;
            shardStrategy = intervals != null && !intervals.isEmpty() ? ShardStrategyFactory.shatter(readsDataSource, referenceDataSource.getReference(), shardType, drivingDataSource.getSequenceDictionary(), SHARD_SIZE, this.getGenomeLocParser(), intervals) : ShardStrategyFactory.shatter(readsDataSource, referenceDataSource.getReference(), shardType, drivingDataSource.getSequenceDictionary(), SHARD_SIZE, this.getGenomeLocParser());
        } else if (this.walker instanceof ReadPairWalker) {
            if (readsDataSource != null && readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.queryname) {
                throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.queryname, "Read pair walkers can only walk over query name-sorted data.  Please resort your input BAM file.");
            }
            if (intervals != null && !intervals.isEmpty()) {
                throw new UserException.CommandLineException("Pairs traversal cannot be used in conjunction with intervals.");
            }
            shardStrategy = ShardStrategyFactory.shatter(readsDataSource, referenceDataSource.getReference(), ShardStrategyFactory.SHATTER_STRATEGY.READS_EXPERIMENTAL, drivingDataSource.getSequenceDictionary(), SHARD_SIZE, this.getGenomeLocParser());
        } else {
            throw new ReviewedStingException("Unable to support walker of type" + this.walker.getClass().getName());
        }
        return shardStrategy;
    }

    protected boolean flashbackData() {
        return this.walker instanceof ReadWalker;
    }

    private void initializeTempDirectory() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        tempDir.mkdirs();
    }

    private void initializeOutputStreams(OutputTracker outputTracker) {
        for (Map.Entry<ArgumentSource, Object> entry : this.getInputs().entrySet()) {
            outputTracker.addInput(entry.getKey(), entry.getValue());
        }
        for (Stub stub : this.getOutputs()) {
            outputTracker.addOutput(stub);
        }
        outputTracker.prepareWalker(this.walker, this.getArguments().strictnessLevel);
    }

    public ReferenceDataSource getReferenceDataSource() {
        return this.referenceDataSource;
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    public void setParser(ParsingEngine parsingEngine) {
        this.parsingEngine = parsingEngine;
    }

    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    protected void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    protected void initializeIntervals() {
        GenomeLocSortedSet includeSortedSet;
        if (this.argCollection.intervals == null && this.argCollection.excludeIntervals == null && this.argCollection.RODToInterval == null) {
            return;
        }
        if (this.argCollection.intervals != null) {
            for (String interval : this.argCollection.intervals) {
                if (!interval.trim().equals("all")) continue;
                if (this.argCollection.intervals.size() > 1) {
                    throw new UserException("'-L all' was specified along with other intervals or interval lists; the GATK cannot combine '-L all' with other intervals.");
                }
                return;
            }
        }
        GenomeLocSortedSet genomeLocSortedSet = includeSortedSet = this.argCollection.intervals == null && this.argCollection.RODToInterval == null ? GenomeLocSortedSet.createSetFromSequenceDictionary(this.referenceDataSource.getReference().getSequenceDictionary()) : this.loadIntervals(this.argCollection.intervals, IntervalUtils.mergeIntervalLocations(this.getRODIntervals(), this.argCollection.intervalMerging));
        if (this.argCollection.excludeIntervals == null) {
            this.intervals = includeSortedSet;
        } else {
            GenomeLocSortedSet excludeSortedSet = this.loadIntervals(this.argCollection.excludeIntervals, null);
            this.intervals = includeSortedSet.subtractRegions(excludeSortedSet);
            long toPruneSize = includeSortedSet.coveredSize();
            long toExcludeSize = excludeSortedSet.coveredSize();
            long intervalSize = this.intervals.coveredSize();
            logger.info(String.format("Initial include intervals span %d loci; exclude intervals span %d loci", toPruneSize, toExcludeSize));
            logger.info(String.format("Excluding %d loci from original intervals (%.2f%% reduction)", toPruneSize - intervalSize, (double)(toPruneSize - intervalSize) / (0.01 * (double)toPruneSize)));
        }
    }

    protected GenomeLocSortedSet loadIntervals(List<String> argList, List<GenomeLoc> rodIntervals) {
        boolean allowEmptyIntervalList = this.argCollection.unsafe == ValidationExclusion.TYPE.ALLOW_EMPTY_INTERVAL_LIST || this.argCollection.unsafe == ValidationExclusion.TYPE.ALL;
        List<GenomeLoc> nonRODIntervals = IntervalUtils.parseIntervalArguments(this.genomeLocParser, argList, allowEmptyIntervalList);
        List<GenomeLoc> allIntervals = IntervalUtils.mergeListsBySetOperator(rodIntervals, nonRODIntervals, this.argCollection.BTIMergeRule);
        return IntervalUtils.sortAndMergeIntervals(this.genomeLocParser, allIntervals, this.argCollection.intervalMerging);
    }

    private List<GenomeLoc> getRODIntervals() {
        Map<String, ReferenceOrderedDataSource> rodNames = RMDIntervalGenerator.getRMDTrackNames(this.rodDataSources);
        ArrayList<GenomeLoc> ret = new ArrayList<GenomeLoc>();
        if (rodNames != null && this.argCollection.RODToInterval != null) {
            String rodName = this.argCollection.RODToInterval;
            if (!rodNames.containsKey(rodName)) {
                throw new UserException.CommandLineException("--rodToIntervalTrackName (-BTI) was passed the name '" + rodName + "', which wasn't given as a ROD name in the -B option");
            }
            for (String str : rodNames.keySet()) {
                if (!str.equals(rodName)) continue;
                logger.info("Adding interval list from track (ROD) named " + rodName);
                RMDIntervalGenerator intervalGenerator = new RMDIntervalGenerator(rodNames.get(str));
                ret.addAll(intervalGenerator.toGenomeLocList());
            }
        }
        return ret;
    }

    public void addInput(ArgumentSource argumentSource, Object value) {
        this.inputs.put(argumentSource, value);
    }

    public void addOutput(Stub<?> stub) {
        this.outputs.add(stub);
    }

    public Tags getTags(Object key) {
        return this.parsingEngine.getTags(key);
    }

    protected void initializeDataSources() {
        logger.info("Strictness is " + (Object)((Object)this.argCollection.strictnessLevel));
        BAQ.DEFAULT_GOP = this.argCollection.BAQGOP;
        this.validateSuppliedReference();
        this.setReferenceDataSource(this.argCollection.referenceFile);
        this.validateSuppliedReads();
        this.readsDataSource = this.createReadsDataSource(this.argCollection, this.genomeLocParser, this.referenceDataSource.getReference());
        for (ReadFilter filter : this.filters) {
            filter.initialize(this);
        }
        this.sampleDataSource = new SampleDataSource(this.getSAMFileHeader(), this.argCollection.sampleFiles);
        this.rodDataSources = this.getReferenceOrderedDataSources(this.referenceMetaDataFiles, this.referenceDataSource.getReference().getSequenceDictionary(), this.genomeLocParser, this.argCollection.unsafe);
    }

    public SAMReaderID getReaderIDForRead(SAMRecord read) {
        return this.getReadsDataSource().getReaderID(read);
    }

    public File getSourceFileForReaderID(SAMReaderID id) {
        return this.getReadsDataSource().getSAMFile(id);
    }

    public List<Set<String>> getSamplesByReaders() {
        Collection<SAMReaderID> readers = this.getReadsDataSource().getReaderIDs();
        ArrayList<Set<String>> sample_sets = new ArrayList<Set<String>>(readers.size());
        for (SAMReaderID r : readers) {
            HashSet<String> samples = new HashSet<String>(1);
            sample_sets.add(samples);
            for (SAMReadGroupRecord g : this.getReadsDataSource().getHeader(r).getReadGroups()) {
                samples.add(g.getSample());
            }
        }
        return sample_sets;
    }

    public List<Set<String>> getLibrariesByReaders() {
        Collection<SAMReaderID> readers = this.getReadsDataSource().getReaderIDs();
        ArrayList<Set<String>> lib_sets = new ArrayList<Set<String>>(readers.size());
        for (SAMReaderID r : readers) {
            HashSet<String> libs = new HashSet<String>(2);
            lib_sets.add(libs);
            for (SAMReadGroupRecord g : this.getReadsDataSource().getHeader(r).getReadGroups()) {
                libs.add(g.getLibrary());
            }
        }
        return lib_sets;
    }

    public List<Set<String>> getMergedReadGroupsByReaders() {
        Collection<SAMReaderID> readers = this.getReadsDataSource().getReaderIDs();
        ArrayList<Set<String>> rg_sets = new ArrayList<Set<String>>(readers.size());
        for (SAMReaderID r : readers) {
            HashSet<String> groups = new HashSet<String>(5);
            rg_sets.add(groups);
            for (SAMReadGroupRecord g : this.getReadsDataSource().getHeader(r).getReadGroups()) {
                if (this.getReadsDataSource().hasReadGroupCollisions()) {
                    groups.add(this.getReadsDataSource().getReadGroupId(r, g.getReadGroupId()));
                    continue;
                }
                groups.add(g.getReadGroupId());
            }
        }
        return rg_sets;
    }

    private void validateSourcesAgainstReference(SAMDataSource reads, ReferenceSequenceFile reference, Collection<ReferenceOrderedDataSource> rods, RMDTrackBuilder manager) {
        if (reads.isEmpty() && (rods == null || rods.isEmpty()) || reference == null) {
            return;
        }
        SAMSequenceDictionary referenceDictionary = reference.getSequenceDictionary();
        if (!reads.isEmpty()) {
            SAMSequenceDictionary readsDictionary = reads.getHeader().getSequenceDictionary();
            if (readsDictionary.size() == 0) {
                logger.info("Reads file is unmapped.  Skipping validation against reference.");
                return;
            }
            SequenceDictionaryUtils.validateDictionaries(logger, this.getArguments().unsafe, "reads", readsDictionary, "reference", referenceDictionary);
        }
        for (ReferenceOrderedDataSource rod : rods) {
            manager.validateTrackSequenceDictionary(rod.getName(), rod.getSequenceDictionary(), referenceDictionary);
        }
    }

    private SAMDataSource createReadsDataSource(GATKArgumentCollection argCollection, GenomeLocParser genomeLocParser, IndexedFastaSequenceFile refReader) {
        DownsamplingMethod method = this.getDownsamplingMethod();
        if (this.getWalkerBAQApplicationTime() == BAQ.ApplicationTime.FORBIDDEN && argCollection.BAQMode != BAQ.CalculationMode.OFF) {
            throw new UserException.BadArgumentValue("baq", "Walker cannot accept BAQ'd base qualities, and yet BAQ mode " + (Object)((Object)argCollection.BAQMode) + " was requested.");
        }
        SAMDataSource dataSource = new SAMDataSource(this.samReaderIDs, genomeLocParser, argCollection.useOriginalBaseQualities, argCollection.strictnessLevel, argCollection.readBufferSize, method, new ValidationExclusion(Arrays.asList(argCollection.unsafe)), this.filters, this.includeReadsWithDeletionAtLoci(), this.generateExtendedEvents(), this.getWalkerBAQApplicationTime() == BAQ.ApplicationTime.ON_INPUT ? argCollection.BAQMode : BAQ.CalculationMode.OFF, this.getWalkerBAQQualityMode(), refReader, argCollection.defaultBaseQualities, !argCollection.disableLowMemorySharding);
        return dataSource;
    }

    public void setReferenceDataSource(File refFile) {
        this.referenceDataSource = new ReferenceDataSource(refFile);
        this.genomeLocParser = new GenomeLocParser(this.referenceDataSource.getReference());
    }

    private List<ReferenceOrderedDataSource> getReferenceOrderedDataSources(Collection<RMDTriplet> referenceMetaDataFiles, SAMSequenceDictionary sequenceDictionary, GenomeLocParser genomeLocParser, ValidationExclusion.TYPE validationExclusionType) {
        RMDTrackBuilder builder = new RMDTrackBuilder(sequenceDictionary, genomeLocParser, validationExclusionType);
        ArrayList<ReferenceOrderedDataSource> dataSources = new ArrayList<ReferenceOrderedDataSource>();
        for (RMDTriplet fileDescriptor : referenceMetaDataFiles) {
            dataSources.add(new ReferenceOrderedDataSource(fileDescriptor, builder, sequenceDictionary, genomeLocParser, this.flashbackData()));
        }
        this.validateSourcesAgainstReference(this.readsDataSource, this.referenceDataSource.getReference(), dataSources, builder);
        return dataSources;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.readsDataSource.getHeader();
    }

    public SAMFileHeader getSAMFileHeader(SAMReaderID reader) {
        return this.readsDataSource.getHeader(reader);
    }

    public SAMDataSource getReadsDataSource() {
        return this.readsDataSource;
    }

    public void setArguments(GATKArgumentCollection argCollection) {
        this.argCollection = argCollection;
    }

    public GATKArgumentCollection getArguments() {
        return this.argCollection;
    }

    public GenomeLocSortedSet getIntervals() {
        return this.intervals;
    }

    public Collection<ReadFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<ReadFilter> filters) {
        this.filters = filters;
    }

    protected FilterManager getFilterManager() {
        return this.filterManager;
    }

    protected Map<ArgumentSource, Object> getInputs() {
        return this.inputs;
    }

    protected Collection<Stub<?>> getOutputs() {
        return this.outputs;
    }

    public List<ReferenceOrderedDataSource> getRodDataSources() {
        return this.rodDataSources;
    }

    public ReadMetrics getCumulativeMetrics() {
        return this.readsDataSource == null ? null : this.readsDataSource.getCumulativeReadMetrics();
    }

    public SampleDataSource getSampleMetadata() {
        return this.sampleDataSource;
    }

    public Sample getSampleById(String id) {
        return this.sampleDataSource.getSampleById(id);
    }

    public Sample getSampleByReadGroup(SAMReadGroupRecord readGroup) {
        return this.sampleDataSource.getSampleByReadGroup(readGroup);
    }

    public Sample getSampleByRead(SAMRecord read) {
        return this.getSampleByReadGroup(read.getReadGroup());
    }

    public int sampleCount() {
        return this.sampleDataSource.sampleCount();
    }

    public Set<Sample> getFamily(String familyId) {
        return this.sampleDataSource.getFamily(familyId);
    }

    public Set<Sample> getChildren(Sample sample) {
        return this.sampleDataSource.getChildren(sample);
    }

    public Collection<Sample> getSamples() {
        return this.sampleDataSource.getSamples();
    }

    public Set<Sample> getSamples(Collection<String> sampleNameList) {
        return this.sampleDataSource.getSamples(sampleNameList);
    }

    public Set<Sample> getSamplesWithProperty(String key) {
        return this.sampleDataSource.getSamplesWithProperty(key);
    }

    public Set<Sample> getSamplesWithProperty(String key, String value) {
        return this.sampleDataSource.getSamplesWithProperty(key, value);
    }

    public Set<Sample> getSamplesByVariantContext(VariantContext context) {
        HashSet<Sample> samples = new HashSet<Sample>();
        for (String sampleName : context.getSampleNames()) {
            samples.add(this.sampleDataSource.getOrCreateSample(sampleName));
        }
        return samples;
    }

    public Set<Sample> getSAMFileSamples() {
        return this.sampleDataSource.getSAMFileSamples();
    }

    public VariantContext subContextFromSampleProperty(VariantContext context, String key, String value) {
        return this.sampleDataSource.subContextFromSampleProperty(context, key, value);
    }

    public Map<String, String> getApproximateCommandLineArguments(Object ... argumentProviders) {
        return CommandLineUtils.getApproximateCommandLineArguments(this.parsingEngine, argumentProviders);
    }

    public String createApproximateCommandLineArgumentString(Object ... argumentProviders) {
        return CommandLineUtils.createApproximateCommandLineArgumentString(this.parsingEngine, argumentProviders);
    }
}

